/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessageType;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.IMSI;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.sms.IpSmGwGuidance;
import org.restcomm.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.restcomm.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.restcomm.protocols.ss7.map.primitives.IMSIImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.service.sms.IpSmGwGuidanceImpl;
import org.restcomm.protocols.ss7.map.service.sms.LocationInfoWithLMSIImpl;
import org.restcomm.protocols.ss7.map.service.sms.SmsMessageImpl;

public class SendRoutingInfoForSMResponseImpl
extends SmsMessageImpl
implements SendRoutingInfoForSMResponse {
    protected static final int _TAG_LocationInfoWithLMSI = 0;
    protected static final int _TAG_mwdSet = 2;
    protected static final int _TAG_ExtensionContainer = 4;
    protected static final int _TAG_IpSmGwGuidance = 5;
    protected String _PrimitiveName = "SendRoutingInfoForSMResponse";
    private IMSI imsi;
    private LocationInfoWithLMSI locationInfoWithLMSI;
    private MAPExtensionContainer extensionContainer;
    private Boolean mwdSet;
    private IpSmGwGuidance ipSmGwGuidance;

    public SendRoutingInfoForSMResponseImpl() {
    }

    public SendRoutingInfoForSMResponseImpl(IMSI imsi, LocationInfoWithLMSI locationInfoWithLMSI, MAPExtensionContainer extensionContainer, Boolean mwdSet, IpSmGwGuidance ipSmGwGuidance) {
        this.imsi = imsi;
        this.locationInfoWithLMSI = locationInfoWithLMSI;
        this.extensionContainer = extensionContainer;
        this.mwdSet = mwdSet;
        this.ipSmGwGuidance = ipSmGwGuidance;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.sendRoutingInfoForSM_Response;
    }

    @Override
    public int getOperationCode() {
        return 45;
    }

    @Override
    public IMSI getIMSI() {
        return this.imsi;
    }

    @Override
    public LocationInfoWithLMSI getLocationInfoWithLMSI() {
        return this.locationInfoWithLMSI;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public Boolean getMwdSet() {
        return this.mwdSet;
    }

    @Override
    public IpSmGwGuidance getIpSmGwGuidance() {
        return this.ipSmGwGuidance;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.locationInfoWithLMSI = null;
        this.extensionContainer = null;
        this.mwdSet = null;
        this.ipSmGwGuidance = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imsi = new IMSIImpl();
                    ((IMSIImpl)this.imsi).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 0) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".locationInfoWithLMSI: Parameter 1 bad tag class or tag or primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.locationInfoWithLMSI = new LocationInfoWithLMSIImpl();
                    ((LocationInfoWithLMSIImpl)this.locationInfoWithLMSI).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 4: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                            case 2: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".mwdSet: Parameter mwdSet is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.mwdSet = ais.readBoolean();
                                break block0;
                            }
                            case 5: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ipSmGwGuidance: Parameter ipSmGwGuidance is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.ipSmGwGuidance = new IpSmGwGuidanceImpl();
                                ((IpSmGwGuidanceImpl)this.ipSmGwGuidance).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 2) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi == null || this.locationInfoWithLMSI == null) {
            throw new MAPException("imsi and locationInfoWithLMSI must not be null");
        }
        ((IMSIImpl)this.imsi).encodeAll(asnOs);
        ((LocationInfoWithLMSIImpl)this.locationInfoWithLMSI).encodeAll(asnOs, 2, 0);
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 4);
        }
        if (this.mwdSet != null) {
            try {
                asnOs.writeBoolean(2, 2, this.mwdSet);
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
            }
        }
        if (this.ipSmGwGuidance != null) {
            ((IpSmGwGuidanceImpl)this.ipSmGwGuidance).encodeAll(asnOs, 2, 5);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SendRoutingInfoForSMResponse [");
        if (this.getMAPDialog() != null) {
            sb.append("DialogId=").append(this.getMAPDialog().getLocalDialogId());
        }
        if (this.imsi != null) {
            sb.append(", imsi=");
            sb.append(this.imsi.toString());
        }
        if (this.locationInfoWithLMSI != null) {
            sb.append(", locationInfoWithLMSI=");
            sb.append(this.locationInfoWithLMSI.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        if (this.mwdSet != null) {
            sb.append(", mwdSet=");
            sb.append(this.mwdSet.toString());
        }
        if (this.ipSmGwGuidance != null) {
            sb.append(", ipSmGwGuidance=");
            sb.append(this.ipSmGwGuidance.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

