/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.FQDN;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.PDNGWIdentity;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.PDPAddress;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.FQDNImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.PDPAddressImpl;

public class PDNGWIdentityImpl
extends SequenceBase
implements PDNGWIdentity {
    private static final int _TAG_pdnGwIpv4Address = 0;
    private static final int _TAG_pdnGwIpv6Address = 1;
    private static final int _TAG_pdnGwName = 2;
    private static final int _TAG_extensionContainer = 3;
    private PDPAddress pdnGwIpv4Address;
    private PDPAddress pdnGwIpv6Address;
    private FQDN pdnGwName;
    private MAPExtensionContainer extensionContainer;

    public PDNGWIdentityImpl() {
        super("PDNGWIdentity");
    }

    public PDNGWIdentityImpl(PDPAddress pdnGwIpv4Address, PDPAddress pdnGwIpv6Address, FQDN pdnGwName, MAPExtensionContainer extensionContainer) {
        super("PDNGWIdentity");
        this.pdnGwIpv4Address = pdnGwIpv4Address;
        this.pdnGwIpv6Address = pdnGwIpv6Address;
        this.pdnGwName = pdnGwName;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public PDPAddress getPdnGwIpv4Address() {
        return this.pdnGwIpv4Address;
    }

    @Override
    public PDPAddress getPdnGwIpv6Address() {
        return this.pdnGwIpv6Address;
    }

    @Override
    public FQDN getPdnGwName() {
        return this.pdnGwName;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.pdnGwIpv4Address = null;
        this.pdnGwIpv6Address = null;
        this.pdnGwName = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block9: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".pdnGwIpv4Address: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.pdnGwIpv4Address = new PDPAddressImpl();
                            ((PDPAddressImpl)this.pdnGwIpv4Address).decodeAll(ais);
                            continue block9;
                        }
                        case 1: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".pdnGwIpv6Address: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.pdnGwIpv6Address = new PDPAddressImpl();
                            ((PDPAddressImpl)this.pdnGwIpv6Address).decodeAll(ais);
                            continue block9;
                        }
                        case 2: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".pdnGwName: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.pdnGwName = new FQDNImpl();
                            ((FQDNImpl)this.pdnGwName).decodeAll(ais);
                            continue block9;
                        }
                        case 3: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block9;
                        }
                    }
                    ais.advanceElement();
                    continue block9;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.pdnGwIpv4Address != null) {
            ((PDPAddressImpl)this.pdnGwIpv4Address).encodeAll(asnOs, 2, 0);
        }
        if (this.pdnGwIpv6Address != null) {
            ((PDPAddressImpl)this.pdnGwIpv6Address).encodeAll(asnOs, 2, 1);
        }
        if (this.pdnGwName != null) {
            ((FQDNImpl)this.pdnGwName).encodeAll(asnOs, 2, 2);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.pdnGwIpv4Address != null) {
            sb.append("pdnGwIpv4Address=");
            sb.append(this.pdnGwIpv4Address.toString());
            sb.append(", ");
        }
        if (this.pdnGwIpv6Address != null) {
            sb.append("pdnGwIpv6Address=");
            sb.append(this.pdnGwIpv6Address.toString());
            sb.append(", ");
        }
        if (this.pdnGwName != null) {
            sb.append("pdnGwName=");
            sb.append(this.pdnGwName.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

