/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.BearerServiceCode;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.TeleserviceCode;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.BearerServiceCodeImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.TeleserviceCodeImpl;

public class BasicServiceCodeImpl
implements BasicServiceCode,
MAPAsnPrimitive {
    private static final String BEARER_SERVICE = "bearerService";
    private static final String TELE_SERVICE = "teleservice";
    public static final int _TAG_bearerService = 2;
    public static final int _TAG_teleservice = 3;
    public static final String _PrimitiveName = "BasicServiceCode";
    private BearerServiceCode bearerService;
    private TeleserviceCode teleservice;
    protected static final XMLFormat<BasicServiceCodeImpl> BASIC_SERVICE_CODE_XMLS = new XMLFormat<BasicServiceCodeImpl>(BasicServiceCodeImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, BasicServiceCodeImpl ssCode) throws XMLStreamException {
            ssCode.bearerService = xml.get(BasicServiceCodeImpl.BEARER_SERVICE, BearerServiceCodeImpl.class);
            ssCode.teleservice = xml.get(BasicServiceCodeImpl.TELE_SERVICE, TeleserviceCodeImpl.class);
        }

        @Override
        public void write(BasicServiceCodeImpl ssCode, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.add((BearerServiceCodeImpl)ssCode.getBearerService(), BasicServiceCodeImpl.BEARER_SERVICE, BearerServiceCodeImpl.class);
            xml.add((TeleserviceCodeImpl)ssCode.getTeleservice(), BasicServiceCodeImpl.TELE_SERVICE, TeleserviceCodeImpl.class);
        }
    };

    public BasicServiceCodeImpl() {
    }

    public BasicServiceCodeImpl(TeleserviceCode teleservice) {
        this.teleservice = teleservice;
    }

    public BasicServiceCodeImpl(BearerServiceCode bearerService) {
        this.bearerService = bearerService;
    }

    @Override
    public BearerServiceCode getBearerService() {
        return this.bearerService;
    }

    @Override
    public TeleserviceCode getTeleservice() {
        return this.teleservice;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.bearerService != null) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding BasicServiceCode: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding BasicServiceCode: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding BasicServiceCode: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding BasicServiceCode: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        block7: {
            block6: {
                this.bearerService = null;
                this.teleservice = null;
                int tag = ais.getTag();
                if (ais.getTagClass() != 2) break block6;
                switch (tag) {
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding BasicServiceCode.bearerService: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.bearerService = new BearerServiceCodeImpl();
                        ((BearerServiceCodeImpl)this.bearerService).decodeData(ais, length);
                        break block7;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding BasicServiceCode.teleservice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.teleservice = new TeleserviceCodeImpl();
                        ((TeleserviceCodeImpl)this.teleservice).decodeData(ais, length);
                        break block7;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding BasicServiceCode: bad choice tag", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new MAPParsingComponentException("Error while decoding BasicServiceCode: bad choice tagClass", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding BasicServiceCode: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.bearerService == null && this.teleservice == null || this.bearerService != null && this.teleservice != null) {
            throw new MAPException("Error while decoding BasicServiceCode: One and only one choice must be selected");
        }
        if (this.bearerService != null) {
            ((BearerServiceCodeImpl)this.bearerService).encodeData(asnOs);
        } else {
            ((TeleserviceCodeImpl)this.teleservice).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.bearerService != null) {
            sb.append("bearerService=" + this.bearerService.toString());
            sb.append(", ");
        }
        if (this.teleservice != null) {
            sb.append("teleservice=" + this.teleservice.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bearerService == null ? 0 : this.bearerService.hashCode());
        result = 31 * result + (this.teleservice == null ? 0 : this.teleservice.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicServiceCodeImpl other = (BasicServiceCodeImpl)obj;
        if (this.bearerService == null ? other.bearerService != null : !this.bearerService.equals(other.bearerService)) {
            return false;
        }
        return !(this.teleservice == null ? other.teleservice != null : !this.teleservice.equals(other.teleservice));
    }
}

