/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.GSNAddress;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.GPRSChargingID;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.PDPContextInfo;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.TEID;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.TransactionId;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.APN;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ChargingCharacteristics;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.Ext2QoSSubscribed;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.Ext3QoSSubscribed;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.Ext4QoSSubscribed;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtPDPType;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtQoSSubscribed;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.PDPAddress;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.PDPType;
import org.restcomm.protocols.ss7.map.primitives.GSNAddressImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.GPRSChargingIDImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.TEIDImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation.TransactionIdImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.APNImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ChargingCharacteristicsImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.Ext2QoSSubscribedImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.Ext3QoSSubscribedImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.Ext4QoSSubscribedImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ExtPDPTypeImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ExtQoSSubscribedImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.PDPAddressImpl;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.PDPTypeImpl;

public class PDPContextInfoImpl
implements PDPContextInfo,
MAPAsnPrimitive {
    public static final int _ID_pdpContextIdentifier = 0;
    public static final int _ID_pdpContextActive = 1;
    public static final int _ID_pdpType = 2;
    public static final int _ID_pdpAddress = 3;
    public static final int _ID_apnSubscribed = 4;
    public static final int _ID_apnInUse = 5;
    public static final int _ID_nsapi = 6;
    public static final int _ID_transactionId = 7;
    public static final int _ID_teidForGnAndGp = 8;
    public static final int _ID_teidForIu = 9;
    public static final int _ID_ggsnAddress = 10;
    public static final int _ID_qosSubscribed = 11;
    public static final int _ID_qosRequested = 12;
    public static final int _ID_qosNegotiated = 13;
    public static final int _ID_chargingId = 14;
    public static final int _ID_chargingCharacteristics = 15;
    public static final int _ID_rncAddress = 16;
    public static final int _ID_extensionContainer = 17;
    public static final int _ID_qos2Subscribed = 18;
    public static final int _ID_qos2Requested = 19;
    public static final int _ID_qos2Negotiated = 20;
    public static final int _ID_qos3Subscribed = 21;
    public static final int _ID_qos3Requested = 22;
    public static final int _ID_qos3Negotiated = 23;
    public static final int _ID_qos4Subscribed = 25;
    public static final int _ID_qos4Requested = 26;
    public static final int _ID_qos4Negotiated = 27;
    public static final int _ID_extPdpType = 28;
    public static final int _ID_extPdpAddress = 29;
    public static final String _PrimitiveName = "PDPContextInfo";
    private static final String PDP_CONTEXT_IDENTIFIER = "pdpContextIdentifier";
    private static final String PDP_CONTEXT_ACTIVE = "pdpContextActive";
    private static final String PDP_TYPE = "pdpType";
    private static final String PDP_ADDRESS = "pdpAddress";
    private static final String APN_SUBSCRIBED = "apnSubscribed";
    private static final String APN_IN_USE = "apnInUse";
    private static final String NSAPI = "nsapi";
    private static final String TRANSACTION_ID = "transactionId";
    private static final String TEID_FOR_GN_AND_GP = "teidForGnAndGp";
    private static final String TEID_FOR_IU = "teidForIu";
    private static final String GGSN_ADDRESS = "ggsnAddress";
    private static final String QOS_SUBSCRIBED = "qosSubscribed";
    private static final String QOS_REQUESTED = "qosRequested";
    private static final String QOS_NEGOTIATED = "qosNegotiated";
    private static final String CHARGING_ID = "chargingId";
    private static final String CHARGING_CHARACTERISTICS = "chargingCharacteristics";
    private static final String RNC_ADDRESS = "rncAddress";
    private static final String EXTENTSION_CONTAINER = "extensionContainer";
    private static final String QOS2_SUBSCRIBED = "qos2Subscribed";
    private static final String QOS2_REQUESTED = "qos2Requested";
    private static final String QOS2_NEGOTIATED = "qos2Negotiated";
    private static final String QOS3_SUBSCRIBED = "qos3Subscribed";
    private static final String QOS3_REQUESTED = "qos3Requested";
    private static final String QOS3_NEGOTIATED = "qos3Negotiated";
    private static final String QOS4_SUBSCRIBED = "qos4Subscribed";
    private static final String QOS4_REQUESTED = "qos4Requested";
    private static final String QOS4_NEGOTIATED = "qos4Negotiated";
    private static final String EXT_PDP_TYPE = "extPdpType";
    private static final String EXT_PDP_ADDRESS = "extPdpAddress";
    private static final Integer DEFAULT_INTEGER_VALUE = 0;
    private static final Boolean DEFAULT_BOOL_VALUE = false;
    private int pdpContextIdentifier;
    private boolean pdpContextActive;
    private PDPType pdpType;
    private PDPAddress pdpAddress;
    private APN apnSubscribed;
    private APN apnInUse;
    private Integer nsapi;
    private TransactionId transactionId;
    private TEID teidForGnAndGp;
    private TEID teidForIu;
    private GSNAddress ggsnAddress;
    private ExtQoSSubscribed qosSubscribed;
    private ExtQoSSubscribed qosRequested;
    private ExtQoSSubscribed qosNegotiated;
    private GPRSChargingID chargingId;
    private ChargingCharacteristics chargingCharacteristics;
    private GSNAddress rncAddress;
    private MAPExtensionContainer extensionContainer;
    private Ext2QoSSubscribed qos2Subscribed;
    private Ext2QoSSubscribed qos2Requested;
    private Ext2QoSSubscribed qos2Negotiated;
    private Ext3QoSSubscribed qos3Subscribed;
    private Ext3QoSSubscribed qos3Requested;
    private Ext3QoSSubscribed qos3Negotiated;
    private Ext4QoSSubscribed qos4Subscribed;
    private Ext4QoSSubscribed qos4Requested;
    private Ext4QoSSubscribed qos4Negotiated;
    private ExtPDPType extPdpType;
    private PDPAddress extPdpAddress;
    protected static final XMLFormat<PDPContextInfoImpl> PDP_CONTEXT_INFO_XML = new XMLFormat<PDPContextInfoImpl>(PDPContextInfoImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, PDPContextInfoImpl pdpContextInfo) throws XMLStreamException {
            pdpContextInfo.pdpContextIdentifier = xml.getAttribute(PDPContextInfoImpl.PDP_CONTEXT_IDENTIFIER, DEFAULT_INTEGER_VALUE);
            Boolean bv = xml.getAttribute(PDPContextInfoImpl.PDP_CONTEXT_ACTIVE, DEFAULT_BOOL_VALUE);
            if (bv != null) {
                pdpContextInfo.pdpContextActive = bv;
            }
            pdpContextInfo.pdpType = xml.get(PDPContextInfoImpl.PDP_TYPE, PDPTypeImpl.class);
            pdpContextInfo.pdpAddress = xml.get(PDPContextInfoImpl.PDP_ADDRESS, PDPAddressImpl.class);
            pdpContextInfo.apnSubscribed = xml.get(PDPContextInfoImpl.APN_SUBSCRIBED, APNImpl.class);
            pdpContextInfo.apnInUse = xml.get(PDPContextInfoImpl.APN_IN_USE, APNImpl.class);
            pdpContextInfo.nsapi = xml.get(PDPContextInfoImpl.NSAPI, Integer.class);
            pdpContextInfo.transactionId = xml.get(PDPContextInfoImpl.TRANSACTION_ID, TransactionIdImpl.class);
            pdpContextInfo.teidForGnAndGp = xml.get(PDPContextInfoImpl.TEID_FOR_GN_AND_GP, TEIDImpl.class);
            pdpContextInfo.teidForIu = xml.get(PDPContextInfoImpl.TEID_FOR_IU, TEIDImpl.class);
            pdpContextInfo.ggsnAddress = xml.get(PDPContextInfoImpl.GGSN_ADDRESS, GSNAddressImpl.class);
            pdpContextInfo.qosSubscribed = xml.get(PDPContextInfoImpl.QOS_SUBSCRIBED, ExtQoSSubscribedImpl.class);
            pdpContextInfo.qosRequested = xml.get(PDPContextInfoImpl.QOS_REQUESTED, ExtQoSSubscribedImpl.class);
            pdpContextInfo.qosNegotiated = xml.get(PDPContextInfoImpl.QOS_NEGOTIATED, ExtQoSSubscribedImpl.class);
            pdpContextInfo.chargingId = xml.get(PDPContextInfoImpl.CHARGING_ID, GPRSChargingIDImpl.class);
            pdpContextInfo.chargingCharacteristics = xml.get(PDPContextInfoImpl.CHARGING_CHARACTERISTICS, ChargingCharacteristicsImpl.class);
            pdpContextInfo.rncAddress = xml.get(PDPContextInfoImpl.RNC_ADDRESS, GSNAddressImpl.class);
            pdpContextInfo.extensionContainer = xml.get(PDPContextInfoImpl.EXTENTSION_CONTAINER, MAPExtensionContainerImpl.class);
            pdpContextInfo.qos2Subscribed = xml.get(PDPContextInfoImpl.QOS2_SUBSCRIBED, Ext2QoSSubscribedImpl.class);
            pdpContextInfo.qos2Requested = xml.get(PDPContextInfoImpl.QOS2_REQUESTED, Ext2QoSSubscribedImpl.class);
            pdpContextInfo.qos2Negotiated = xml.get(PDPContextInfoImpl.QOS2_NEGOTIATED, Ext2QoSSubscribedImpl.class);
            pdpContextInfo.qos3Subscribed = xml.get(PDPContextInfoImpl.QOS3_SUBSCRIBED, Ext3QoSSubscribedImpl.class);
            pdpContextInfo.qos3Requested = xml.get(PDPContextInfoImpl.QOS3_REQUESTED, Ext3QoSSubscribedImpl.class);
            pdpContextInfo.qos3Negotiated = xml.get(PDPContextInfoImpl.QOS3_NEGOTIATED, Ext3QoSSubscribedImpl.class);
            pdpContextInfo.qos4Subscribed = xml.get(PDPContextInfoImpl.QOS4_SUBSCRIBED, Ext4QoSSubscribedImpl.class);
            pdpContextInfo.qos4Requested = xml.get(PDPContextInfoImpl.QOS4_REQUESTED, Ext4QoSSubscribedImpl.class);
            pdpContextInfo.qos4Negotiated = xml.get(PDPContextInfoImpl.QOS4_NEGOTIATED, Ext4QoSSubscribedImpl.class);
            pdpContextInfo.extPdpType = xml.get(PDPContextInfoImpl.EXT_PDP_TYPE, ExtPDPTypeImpl.class);
            pdpContextInfo.extPdpAddress = xml.get(PDPContextInfoImpl.EXT_PDP_ADDRESS, PDPAddressImpl.class);
        }

        @Override
        public void write(PDPContextInfoImpl pdpContextInfo, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(PDPContextInfoImpl.PDP_CONTEXT_IDENTIFIER, pdpContextInfo.getPdpContextIdentifier());
            if (pdpContextInfo.getPdpContextActive()) {
                xml.setAttribute(PDPContextInfoImpl.PDP_CONTEXT_ACTIVE, pdpContextInfo.getPdpContextActive());
            }
            if (pdpContextInfo.getPdpType() != null) {
                xml.add((PDPTypeImpl)pdpContextInfo.getPdpType(), PDPContextInfoImpl.PDP_TYPE, PDPTypeImpl.class);
            }
            if (pdpContextInfo.getPdpAddress() != null) {
                xml.add((PDPAddressImpl)pdpContextInfo.getPdpAddress(), PDPContextInfoImpl.PDP_ADDRESS, PDPAddressImpl.class);
            }
            if (pdpContextInfo.getApnSubscribed() != null) {
                xml.add((APNImpl)pdpContextInfo.getApnSubscribed(), PDPContextInfoImpl.APN_SUBSCRIBED, APNImpl.class);
            }
            if (pdpContextInfo.getApnInUse() != null) {
                xml.add((APNImpl)pdpContextInfo.getApnInUse(), PDPContextInfoImpl.APN_IN_USE, APNImpl.class);
            }
            xml.add(pdpContextInfo.getNsapi(), PDPContextInfoImpl.NSAPI, Integer.class);
            if (pdpContextInfo.getTransactionId() != null) {
                xml.add((TransactionIdImpl)pdpContextInfo.getTransactionId(), PDPContextInfoImpl.TRANSACTION_ID, TransactionIdImpl.class);
            }
            if (pdpContextInfo.getTeidForGnAndGp() != null) {
                xml.add((TEIDImpl)pdpContextInfo.getTeidForGnAndGp(), PDPContextInfoImpl.TEID_FOR_GN_AND_GP, TEIDImpl.class);
            }
            if (pdpContextInfo.getTeidForIu() != null) {
                xml.add((TEIDImpl)pdpContextInfo.getTeidForIu(), PDPContextInfoImpl.TEID_FOR_IU, TEIDImpl.class);
            }
            if (pdpContextInfo.getGgsnAddress() != null) {
                xml.add((GSNAddressImpl)pdpContextInfo.getGgsnAddress(), PDPContextInfoImpl.GGSN_ADDRESS, GSNAddressImpl.class);
            }
            if (pdpContextInfo.getQosSubscribed() != null) {
                xml.add((ExtQoSSubscribedImpl)pdpContextInfo.getQosSubscribed(), PDPContextInfoImpl.QOS_SUBSCRIBED, ExtQoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQosRequested() != null) {
                xml.add((ExtQoSSubscribedImpl)pdpContextInfo.getQosRequested(), PDPContextInfoImpl.QOS_REQUESTED, ExtQoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQosNegotiated() != null) {
                xml.add((ExtQoSSubscribedImpl)pdpContextInfo.getQosNegotiated(), PDPContextInfoImpl.QOS_NEGOTIATED, ExtQoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getChargingId() != null) {
                xml.add((GPRSChargingIDImpl)pdpContextInfo.getChargingId(), PDPContextInfoImpl.CHARGING_ID, GPRSChargingIDImpl.class);
            }
            if (pdpContextInfo.getChargingCharacteristics() != null) {
                xml.add((ChargingCharacteristicsImpl)pdpContextInfo.getChargingCharacteristics(), PDPContextInfoImpl.CHARGING_CHARACTERISTICS, ChargingCharacteristicsImpl.class);
            }
            if (pdpContextInfo.getRncAddress() != null) {
                xml.add((GSNAddressImpl)pdpContextInfo.getRncAddress(), PDPContextInfoImpl.RNC_ADDRESS, GSNAddressImpl.class);
            }
            if (pdpContextInfo.getExtensionContainer() != null) {
                xml.add((MAPExtensionContainerImpl)pdpContextInfo.getExtensionContainer(), PDPContextInfoImpl.EXTENTSION_CONTAINER, MAPExtensionContainerImpl.class);
            }
            if (pdpContextInfo.getQos2Subscribed() != null) {
                xml.add((Ext2QoSSubscribedImpl)pdpContextInfo.getQos2Subscribed(), PDPContextInfoImpl.QOS2_SUBSCRIBED, Ext2QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos2Requested() != null) {
                xml.add((Ext2QoSSubscribedImpl)pdpContextInfo.getQos2Requested(), PDPContextInfoImpl.QOS2_REQUESTED, Ext2QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos2Negotiated() != null) {
                xml.add((Ext2QoSSubscribedImpl)pdpContextInfo.getQos2Negotiated(), PDPContextInfoImpl.QOS2_NEGOTIATED, Ext2QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos3Subscribed() != null) {
                xml.add((Ext3QoSSubscribedImpl)pdpContextInfo.getQos3Subscribed(), PDPContextInfoImpl.QOS3_SUBSCRIBED, Ext3QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos3Requested() != null) {
                xml.add((Ext3QoSSubscribedImpl)pdpContextInfo.getQos3Requested(), PDPContextInfoImpl.QOS3_REQUESTED, Ext3QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos3Negotiated() != null) {
                xml.add((Ext3QoSSubscribedImpl)pdpContextInfo.getQos3Negotiated(), PDPContextInfoImpl.QOS3_NEGOTIATED, Ext3QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos4Subscribed() != null) {
                xml.add((Ext4QoSSubscribedImpl)pdpContextInfo.getQos4Subscribed(), PDPContextInfoImpl.QOS4_SUBSCRIBED, Ext4QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos4Requested() != null) {
                xml.add((Ext4QoSSubscribedImpl)pdpContextInfo.getQos4Requested(), PDPContextInfoImpl.QOS4_REQUESTED, Ext4QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getQos4Negotiated() != null) {
                xml.add((Ext4QoSSubscribedImpl)pdpContextInfo.getQos4Negotiated(), PDPContextInfoImpl.QOS4_NEGOTIATED, Ext4QoSSubscribedImpl.class);
            }
            if (pdpContextInfo.getExtPdpType() != null) {
                xml.add((ExtPDPTypeImpl)pdpContextInfo.getExtPdpType(), PDPContextInfoImpl.EXT_PDP_TYPE, ExtPDPTypeImpl.class);
            }
            if (pdpContextInfo.getExtPdpAddress() != null) {
                xml.add((PDPAddressImpl)pdpContextInfo.getExtPdpAddress(), PDPContextInfoImpl.EXT_PDP_ADDRESS, PDPAddressImpl.class);
            }
        }
    };

    public PDPContextInfoImpl() {
    }

    public PDPContextInfoImpl(int pdpContextIdentifier, boolean pdpContextActive, PDPType pdpType, PDPAddress pdpAddress, APN apnSubscribed, APN apnInUse, Integer asapi, TransactionId transactionId, TEID teidForGnAndGp, TEID teidForIu, GSNAddress ggsnAddress, ExtQoSSubscribed qosSubscribed, ExtQoSSubscribed qosRequested, ExtQoSSubscribed qosNegotiated, GPRSChargingID chargingId, ChargingCharacteristics chargingCharacteristics, GSNAddress rncAddress, MAPExtensionContainer extensionContainer, Ext2QoSSubscribed qos2Subscribed, Ext2QoSSubscribed qos2Requested, Ext2QoSSubscribed qos2Negotiated, Ext3QoSSubscribed qos3Subscribed, Ext3QoSSubscribed qos3Requested, Ext3QoSSubscribed qos3Negotiated, Ext4QoSSubscribed qos4Subscribed, Ext4QoSSubscribed qos4Requested, Ext4QoSSubscribed qos4Negotiated, ExtPDPType extPdpType, PDPAddress extPdpAddress) {
        this.pdpContextIdentifier = pdpContextIdentifier;
        this.pdpContextActive = pdpContextActive;
        this.pdpType = pdpType;
        this.pdpAddress = pdpAddress;
        this.apnSubscribed = apnSubscribed;
        this.apnInUse = apnInUse;
        this.nsapi = asapi;
        this.transactionId = transactionId;
        this.teidForGnAndGp = teidForGnAndGp;
        this.teidForIu = teidForIu;
        this.ggsnAddress = ggsnAddress;
        this.qosSubscribed = qosSubscribed;
        this.qosRequested = qosRequested;
        this.qosNegotiated = qosNegotiated;
        this.chargingId = chargingId;
        this.chargingCharacteristics = chargingCharacteristics;
        this.rncAddress = rncAddress;
        this.extensionContainer = extensionContainer;
        this.qos2Subscribed = qos2Subscribed;
        this.qos2Requested = qos2Requested;
        this.qos2Negotiated = qos2Negotiated;
        this.qos3Subscribed = qos3Subscribed;
        this.qos3Requested = qos3Requested;
        this.qos3Negotiated = qos3Negotiated;
        this.qos4Subscribed = qos4Subscribed;
        this.qos4Requested = qos4Requested;
        this.qos4Negotiated = qos4Negotiated;
        this.extPdpType = extPdpType;
        this.extPdpAddress = extPdpAddress;
    }

    @Override
    public int getPdpContextIdentifier() {
        return this.pdpContextIdentifier;
    }

    @Override
    public boolean getPdpContextActive() {
        return this.pdpContextActive;
    }

    @Override
    public PDPType getPdpType() {
        return this.pdpType;
    }

    @Override
    public PDPAddress getPdpAddress() {
        return this.pdpAddress;
    }

    @Override
    public APN getApnSubscribed() {
        return this.apnSubscribed;
    }

    @Override
    public APN getApnInUse() {
        return this.apnInUse;
    }

    @Override
    public Integer getNsapi() {
        return this.nsapi;
    }

    @Override
    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    @Override
    public TEID getTeidForGnAndGp() {
        return this.teidForGnAndGp;
    }

    @Override
    public TEID getTeidForIu() {
        return this.teidForIu;
    }

    @Override
    public GSNAddress getGgsnAddress() {
        return this.ggsnAddress;
    }

    @Override
    public ExtQoSSubscribed getQosSubscribed() {
        return this.qosSubscribed;
    }

    @Override
    public ExtQoSSubscribed getQosRequested() {
        return this.qosRequested;
    }

    @Override
    public ExtQoSSubscribed getQosNegotiated() {
        return this.qosNegotiated;
    }

    @Override
    public GPRSChargingID getChargingId() {
        return this.chargingId;
    }

    @Override
    public ChargingCharacteristics getChargingCharacteristics() {
        return this.chargingCharacteristics;
    }

    @Override
    public GSNAddress getRncAddress() {
        return this.rncAddress;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public Ext2QoSSubscribed getQos2Subscribed() {
        return this.qos2Subscribed;
    }

    @Override
    public Ext2QoSSubscribed getQos2Requested() {
        return this.qos2Requested;
    }

    @Override
    public Ext2QoSSubscribed getQos2Negotiated() {
        return this.qos2Negotiated;
    }

    @Override
    public Ext3QoSSubscribed getQos3Subscribed() {
        return this.qos3Subscribed;
    }

    @Override
    public Ext3QoSSubscribed getQos3Requested() {
        return this.qos3Requested;
    }

    @Override
    public Ext3QoSSubscribed getQos3Negotiated() {
        return this.qos3Negotiated;
    }

    @Override
    public Ext4QoSSubscribed getQos4Subscribed() {
        return this.qos4Subscribed;
    }

    @Override
    public Ext4QoSSubscribed getQos4Requested() {
        return this.qos4Requested;
    }

    @Override
    public Ext4QoSSubscribed getQos4Negotiated() {
        return this.qos4Negotiated;
    }

    @Override
    public ExtPDPType getExtPdpType() {
        return this.extPdpType;
    }

    @Override
    public PDPAddress getExtPdpAddress() {
        return this.extPdpAddress;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PDPContextInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PDPContextInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PDPContextInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PDPContextInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.pdpContextIdentifier = 0;
        this.pdpContextActive = false;
        this.pdpType = null;
        this.pdpAddress = null;
        this.apnSubscribed = null;
        this.apnInUse = null;
        this.nsapi = null;
        this.transactionId = null;
        this.teidForGnAndGp = null;
        this.teidForIu = null;
        this.ggsnAddress = null;
        this.qosSubscribed = null;
        this.qosRequested = null;
        this.qosNegotiated = null;
        this.chargingId = null;
        this.chargingCharacteristics = null;
        this.rncAddress = null;
        this.extensionContainer = null;
        this.qos2Subscribed = null;
        this.qos2Requested = null;
        this.qos2Negotiated = null;
        this.qos3Subscribed = null;
        this.qos3Requested = null;
        this.qos3Negotiated = null;
        this.qos4Subscribed = null;
        this.qos4Requested = null;
        this.qos4Negotiated = null;
        this.extPdpType = null;
        this.extPdpAddress = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        boolean pdpContextIdentifierIsRead = false;
        block31: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo pdpContextIdentifier: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpContextIdentifier = (int)ais.readInteger();
                        pdpContextIdentifierIsRead = true;
                        continue block31;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo pdpContextActive: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.pdpContextActive = true;
                        continue block31;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo pdpType: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpType = new PDPTypeImpl();
                        ((PDPTypeImpl)this.pdpType).decodeAll(ais);
                        continue block31;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo pdpAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpAddress = new PDPAddressImpl();
                        ((PDPAddressImpl)this.pdpAddress).decodeAll(ais);
                        continue block31;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo apnSubscribed: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.apnSubscribed = new APNImpl();
                        ((APNImpl)this.apnSubscribed).decodeAll(ais);
                        continue block31;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo apnInUse: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.apnInUse = new APNImpl();
                        ((APNImpl)this.apnInUse).decodeAll(ais);
                        continue block31;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo nsapi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.nsapi = (int)ais.readInteger();
                        continue block31;
                    }
                    case 7: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo transactionId: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.transactionId = new TransactionIdImpl();
                        ((TransactionIdImpl)this.transactionId).decodeAll(ais);
                        continue block31;
                    }
                    case 8: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo teidForGnAndGp: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.teidForGnAndGp = new TEIDImpl();
                        ((TEIDImpl)this.teidForGnAndGp).decodeAll(ais);
                        continue block31;
                    }
                    case 9: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo teidForIu: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.teidForIu = new TEIDImpl();
                        ((TEIDImpl)this.teidForIu).decodeAll(ais);
                        continue block31;
                    }
                    case 10: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo ggsnAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ggsnAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.ggsnAddress).decodeAll(ais);
                        continue block31;
                    }
                    case 11: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qosSubscribed: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qosSubscribed = new ExtQoSSubscribedImpl();
                        ((ExtQoSSubscribedImpl)this.qosSubscribed).decodeAll(ais);
                        continue block31;
                    }
                    case 12: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qosRequested: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qosRequested = new ExtQoSSubscribedImpl();
                        ((ExtQoSSubscribedImpl)this.qosRequested).decodeAll(ais);
                        continue block31;
                    }
                    case 13: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qosNegotiated: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qosNegotiated = new ExtQoSSubscribedImpl();
                        ((ExtQoSSubscribedImpl)this.qosNegotiated).decodeAll(ais);
                        continue block31;
                    }
                    case 14: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo chargingId: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.chargingId = new GPRSChargingIDImpl();
                        ((GPRSChargingIDImpl)this.chargingId).decodeAll(ais);
                        continue block31;
                    }
                    case 15: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo chargingCharacteristics: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.chargingCharacteristics = new ChargingCharacteristicsImpl();
                        ((ChargingCharacteristicsImpl)this.chargingCharacteristics).decodeAll(ais);
                        continue block31;
                    }
                    case 16: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo rncAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.rncAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.rncAddress).decodeAll(ais);
                        continue block31;
                    }
                    case 17: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block31;
                    }
                    case 18: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos2Subscribed: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos2Subscribed = new Ext2QoSSubscribedImpl();
                        ((Ext2QoSSubscribedImpl)this.qos2Subscribed).decodeAll(ais);
                        continue block31;
                    }
                    case 19: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos2Requested: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos2Requested = new Ext2QoSSubscribedImpl();
                        ((Ext2QoSSubscribedImpl)this.qos2Requested).decodeAll(ais);
                        continue block31;
                    }
                    case 20: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos2Negotiated: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos2Negotiated = new Ext2QoSSubscribedImpl();
                        ((Ext2QoSSubscribedImpl)this.qos2Negotiated).decodeAll(ais);
                        continue block31;
                    }
                    case 21: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos3Subscribed: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos3Subscribed = new Ext3QoSSubscribedImpl();
                        ((Ext3QoSSubscribedImpl)this.qos3Subscribed).decodeAll(ais);
                        continue block31;
                    }
                    case 22: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos3Requested: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos3Requested = new Ext3QoSSubscribedImpl();
                        ((Ext3QoSSubscribedImpl)this.qos3Requested).decodeAll(ais);
                        continue block31;
                    }
                    case 23: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos3Negotiated: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos3Negotiated = new Ext3QoSSubscribedImpl();
                        ((Ext3QoSSubscribedImpl)this.qos3Negotiated).decodeAll(ais);
                        continue block31;
                    }
                    case 25: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos4Subscribed: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos4Subscribed = new Ext4QoSSubscribedImpl();
                        ((Ext4QoSSubscribedImpl)this.qos4Subscribed).decodeAll(ais);
                        continue block31;
                    }
                    case 26: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos4Requested: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos4Requested = new Ext4QoSSubscribedImpl();
                        ((Ext4QoSSubscribedImpl)this.qos4Requested).decodeAll(ais);
                        continue block31;
                    }
                    case 27: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo qos4Negotiated: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qos4Negotiated = new Ext4QoSSubscribedImpl();
                        ((Ext4QoSSubscribedImpl)this.qos4Negotiated).decodeAll(ais);
                        continue block31;
                    }
                    case 28: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo extPdpType: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extPdpType = new ExtPDPTypeImpl();
                        ((ExtPDPTypeImpl)this.extPdpType).decodeAll(ais);
                        continue block31;
                    }
                    case 29: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding PDPContextInfo extPdpAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extPdpAddress = new PDPAddressImpl();
                        ((PDPAddressImpl)this.extPdpAddress).decodeAll(ais);
                        continue block31;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (!pdpContextIdentifierIsRead) {
            throw new MAPParsingComponentException("Error while decoding PDPContextInfo: pdpContextIdentifier paramater is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PDPContextInfo: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeInteger(2, 0, this.pdpContextIdentifier);
            if (this.pdpContextActive) {
                asnOs.writeNull(2, 1);
            }
            if (this.pdpType != null) {
                ((PDPTypeImpl)this.pdpType).encodeAll(asnOs, 2, 2);
            }
            if (this.pdpAddress != null) {
                ((PDPAddressImpl)this.pdpAddress).encodeAll(asnOs, 2, 3);
            }
            if (this.apnSubscribed != null) {
                ((APNImpl)this.apnSubscribed).encodeAll(asnOs, 2, 4);
            }
            if (this.apnInUse != null) {
                ((APNImpl)this.apnInUse).encodeAll(asnOs, 2, 5);
            }
            if (this.nsapi != null) {
                asnOs.writeInteger(2, 6, this.nsapi.intValue());
            }
            if (this.transactionId != null) {
                ((TransactionIdImpl)this.transactionId).encodeAll(asnOs, 2, 7);
            }
            if (this.teidForGnAndGp != null) {
                ((TEIDImpl)this.teidForGnAndGp).encodeAll(asnOs, 2, 8);
            }
            if (this.teidForIu != null) {
                ((TEIDImpl)this.teidForIu).encodeAll(asnOs, 2, 9);
            }
            if (this.ggsnAddress != null) {
                ((GSNAddressImpl)this.ggsnAddress).encodeAll(asnOs, 2, 10);
            }
            if (this.qosSubscribed != null) {
                ((ExtQoSSubscribedImpl)this.qosSubscribed).encodeAll(asnOs, 2, 11);
            }
            if (this.qosRequested != null) {
                ((ExtQoSSubscribedImpl)this.qosRequested).encodeAll(asnOs, 2, 12);
            }
            if (this.qosNegotiated != null) {
                ((ExtQoSSubscribedImpl)this.qosNegotiated).encodeAll(asnOs, 2, 13);
            }
            if (this.chargingId != null) {
                ((GPRSChargingIDImpl)this.chargingId).encodeAll(asnOs, 2, 14);
            }
            if (this.chargingCharacteristics != null) {
                ((ChargingCharacteristicsImpl)this.chargingCharacteristics).encodeAll(asnOs, 2, 15);
            }
            if (this.rncAddress != null) {
                ((GSNAddressImpl)this.rncAddress).encodeAll(asnOs, 2, 16);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 17);
            }
            if (this.qos2Subscribed != null) {
                ((Ext2QoSSubscribedImpl)this.qos2Subscribed).encodeAll(asnOs, 2, 18);
            }
            if (this.qos2Requested != null) {
                ((Ext2QoSSubscribedImpl)this.qos2Requested).encodeAll(asnOs, 2, 19);
            }
            if (this.qos2Negotiated != null) {
                ((Ext2QoSSubscribedImpl)this.qos2Negotiated).encodeAll(asnOs, 2, 20);
            }
            if (this.qos3Subscribed != null) {
                ((Ext3QoSSubscribedImpl)this.qos3Subscribed).encodeAll(asnOs, 2, 21);
            }
            if (this.qos3Requested != null) {
                ((Ext3QoSSubscribedImpl)this.qos3Requested).encodeAll(asnOs, 2, 22);
            }
            if (this.qos3Negotiated != null) {
                ((Ext3QoSSubscribedImpl)this.qos3Negotiated).encodeAll(asnOs, 2, 23);
            }
            if (this.qos4Subscribed != null) {
                ((Ext4QoSSubscribedImpl)this.qos4Subscribed).encodeAll(asnOs, 2, 25);
            }
            if (this.qos4Requested != null) {
                ((Ext4QoSSubscribedImpl)this.qos4Requested).encodeAll(asnOs, 2, 26);
            }
            if (this.qos4Negotiated != null) {
                ((Ext4QoSSubscribedImpl)this.qos4Negotiated).encodeAll(asnOs, 2, 27);
            }
            if (this.extPdpType != null) {
                ((ExtPDPTypeImpl)this.extPdpType).encodeAll(asnOs, 2, 28);
            }
            if (this.extPdpAddress != null) {
                ((PDPAddressImpl)this.extPdpAddress).encodeAll(asnOs, 2, 29);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding PDPContextInfo: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PDPContextInfo: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        sb.append("pdpContextIdentifier=");
        sb.append(this.pdpContextIdentifier);
        if (this.pdpContextActive) {
            sb.append(", pdpContextActive");
        }
        if (this.pdpType != null) {
            sb.append(", pdpType=");
            sb.append(this.pdpType);
        }
        if (this.pdpAddress != null) {
            sb.append(", pdpAddress=");
            sb.append(this.pdpAddress);
        }
        if (this.apnSubscribed != null) {
            sb.append(", apnSubscribed=");
            sb.append(this.apnSubscribed);
        }
        if (this.apnInUse != null) {
            sb.append(", apnInUse=");
            sb.append(this.apnInUse);
        }
        if (this.nsapi != null) {
            sb.append(", nsapi=");
            sb.append(this.nsapi);
        }
        if (this.transactionId != null) {
            sb.append(", transactionId=");
            sb.append(this.transactionId);
        }
        if (this.teidForGnAndGp != null) {
            sb.append(", teidForGnAndGp=");
            sb.append(this.teidForGnAndGp);
        }
        if (this.teidForIu != null) {
            sb.append(", teidForIu=");
            sb.append(this.teidForIu);
        }
        if (this.ggsnAddress != null) {
            sb.append(", ggsnAddress=");
            sb.append(this.ggsnAddress);
        }
        if (this.qosSubscribed != null) {
            sb.append(", qosSubscribed=");
            sb.append(this.qosSubscribed);
        }
        if (this.qosRequested != null) {
            sb.append(", qosRequested=");
            sb.append(this.qosRequested);
        }
        if (this.qosNegotiated != null) {
            sb.append(", qosNegotiated=");
            sb.append(this.qosNegotiated);
        }
        if (this.chargingId != null) {
            sb.append(", chargingId=");
            sb.append(this.chargingId);
        }
        if (this.chargingCharacteristics != null) {
            sb.append(", chargingCharacteristics=");
            sb.append(this.chargingCharacteristics);
        }
        if (this.rncAddress != null) {
            sb.append(", rncAddress=");
            sb.append(this.rncAddress);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        if (this.qos2Subscribed != null) {
            sb.append(", qos2Subscribed=");
            sb.append(this.qos2Subscribed);
        }
        if (this.qos2Requested != null) {
            sb.append(", qos2Requested=");
            sb.append(this.qos2Requested);
        }
        if (this.qos2Negotiated != null) {
            sb.append(", qos2Negotiated=");
            sb.append(this.qos2Negotiated);
        }
        if (this.qos3Subscribed != null) {
            sb.append(", qos3Subscribed=");
            sb.append(this.qos3Subscribed);
        }
        if (this.qos3Requested != null) {
            sb.append(", qos3Requested=");
            sb.append(this.qos3Requested);
        }
        if (this.qos3Negotiated != null) {
            sb.append(", qos3Negotiated=");
            sb.append(this.qos3Negotiated);
        }
        if (this.qos4Subscribed != null) {
            sb.append(", qos4Subscribed=");
            sb.append(this.qos4Subscribed);
        }
        if (this.qos4Requested != null) {
            sb.append(", qos4Requested=");
            sb.append(this.qos4Requested);
        }
        if (this.qos4Negotiated != null) {
            sb.append(", qos4Negotiated=");
            sb.append(this.qos4Negotiated);
        }
        if (this.extPdpType != null) {
            sb.append(", extPdpType=");
            sb.append(this.extPdpType);
        }
        if (this.extPdpAddress != null) {
            sb.append(", extPdpAddress=");
            sb.append(this.extPdpAddress);
        }
        sb.append("]");
        return sb.toString();
    }
}

