/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.ODBInfo;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ODBData;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ODBDataImpl;

public class ODBInfoImpl
extends SequenceBase
implements ODBInfo {
    public static final String _PrimitiveName = "ODBInfo";
    private ODBData odbData;
    private boolean notificationToCSE;
    private MAPExtensionContainer extensionContainer;

    public ODBInfoImpl() {
        super(_PrimitiveName);
    }

    public ODBInfoImpl(ODBData odbData, boolean notificationToCSE, MAPExtensionContainer extensionContainer) {
        super(_PrimitiveName);
        this.odbData = odbData;
        this.notificationToCSE = notificationToCSE;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public ODBData getOdbData() {
        return this.odbData;
    }

    @Override
    public boolean getNotificationToCSE() {
        return this.notificationToCSE;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.odbData = null;
        this.notificationToCSE = false;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 0 || tag != 16 || ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ODBInfo: Parameter odbData has bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.odbData = new ODBDataImpl();
        ((ODBDataImpl)this.odbData).decodeAll(ais);
        block4: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ODBInfo.notificationToCSE: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.notificationToCSE = Boolean.TRUE;
                        continue block4;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ODBInfo.extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.odbData == null) {
            throw new MAPException("Error while encoding ODBInfo the mandatory parameter odbData is not defined");
        }
        try {
            ((ODBDataImpl)this.odbData).encodeAll(asnOs);
            if (this.notificationToCSE) {
                asnOs.writeNull();
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ODBInfo: " + e.getMessage(), e);
        }
        catch (AsnException ae) {
            throw new MAPException("AsnException when encoding ODBInfo: " + ae.getMessage(), ae);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.odbData != null) {
            sb.append("odbData=");
            sb.append(this.odbData);
        }
        if (this.notificationToCSE) {
            sb.append(", notificationToCSE");
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        sb.append("]");
        return sb.toString();
    }
}

