/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.CallForwardingData;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtForwFeature;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.ExtForwFeatureImpl;

public class CallForwardingDataImpl
extends SequenceBase
implements CallForwardingData {
    private static final int _TAG_extensionContainer = 0;
    private ArrayList<ExtForwFeature> forwardingFeatureList;
    private boolean isNotificationToCSE;
    private MAPExtensionContainer extensionContainer;

    public CallForwardingDataImpl() {
        super("CallForwardingData");
    }

    public CallForwardingDataImpl(ArrayList<ExtForwFeature> forwardingFeatureList, boolean isNotificationToCSE, MAPExtensionContainer extensionContainer) {
        super("CallForwardingData");
        this.forwardingFeatureList = forwardingFeatureList;
        this.isNotificationToCSE = isNotificationToCSE;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public ArrayList<ExtForwFeature> getForwardingFeatureList() {
        return this.forwardingFeatureList;
    }

    @Override
    public boolean getNotificationToCSE() {
        return this.isNotificationToCSE;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.forwardingFeatureList = null;
        this.isNotificationToCSE = false;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block11: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".forwardingFeatureList: Parameter forwardingFeatureList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.forwardingFeatureList = new ArrayList();
                            while (ais2.available() != 0) {
                                if (ais2.readTag() != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extForwFeature: Parameter extForwFeature is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ExtForwFeatureImpl extForwFeature = new ExtForwFeatureImpl();
                                extForwFeature.decodeAll(ais2);
                                this.forwardingFeatureList.add(extForwFeature);
                            }
                            if (this.forwardingFeatureList.size() >= 1 && this.forwardingFeatureList.size() <= 32) break;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter forwardingFeatureList size must be from 1 to 32, found: " + this.forwardingFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        case 5: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".isNotificationToCSE: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.isNotificationToCSE = Boolean.TRUE;
                        }
                    }
                    continue block11;
                }
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                    continue block11;
                }
            }
            ais.advanceElement();
        }
        if (this.forwardingFeatureList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "forwardingFeatureList is mandatory but it is absent", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.forwardingFeatureList == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter forwardingFeatureList is not defined");
        }
        if (this.forwardingFeatureList.isEmpty() || this.forwardingFeatureList.size() > 32) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " size forwardingFeatureList is out of range (1..32)");
        }
        try {
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (ExtForwFeature extForwFeature : this.forwardingFeatureList) {
                ((ExtForwFeatureImpl)extForwFeature).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.isNotificationToCSE) {
                asnOs.writeNull();
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 0);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException ae) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + ae.getMessage(), ae);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.forwardingFeatureList != null) {
            sb.append("forwardingFeatureList=[");
            boolean firstItem = true;
            for (ExtForwFeature extForwFeature : this.forwardingFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(extForwFeature);
            }
            sb.append("], ");
        }
        if (this.isNotificationToCSE) {
            sb.append("isNotificationToCSE, ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

