/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.datacoding;

import org.restcomm.protocols.ss7.map.api.datacoding.CBSDataCodingGroup;
import org.restcomm.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.restcomm.protocols.ss7.map.api.datacoding.CBSNationalLanguage;
import org.restcomm.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.restcomm.protocols.ss7.map.api.smstpdu.DataCodingSchemaMessageClass;

public class CBSDataCodingSchemeImpl
implements CBSDataCodingScheme {
    private int code;

    public CBSDataCodingSchemeImpl(int code) {
        this.code = code;
    }

    public CBSDataCodingSchemeImpl(CBSDataCodingGroup dataCodingGroup, CharacterSet characterSet, CBSNationalLanguage nationalLanguageShiftTable, DataCodingSchemaMessageClass messageClass, boolean isCompressed) {
        if (dataCodingGroup == null) {
            this.code = 15;
            return;
        }
        switch (dataCodingGroup) {
            case GeneralGsm7: {
                if (nationalLanguageShiftTable != null) {
                    this.code = nationalLanguageShiftTable.getCode();
                    break;
                }
                this.code = 15;
                break;
            }
            case GeneralWithLanguageIndication: {
                if (characterSet == CharacterSet.GSM7) {
                    this.code = 16;
                    break;
                }
                this.code = 17;
                break;
            }
            case GeneralDataCodingIndication: {
                this.code = 64;
                if (isCompressed) {
                    this.code |= 0x20;
                }
                if (messageClass != null) {
                    this.code |= 16 + messageClass.getCode();
                }
                if (characterSet == null) break;
                this.code |= characterSet.getCode() << 2;
                break;
            }
            case MessageWithUserDataHeader: {
                this.code = 144;
                if (messageClass != null) {
                    this.code |= messageClass.getCode();
                }
                if (characterSet == null) break;
                this.code |= characterSet.getCode() << 2;
                break;
            }
            case I1ProtocolMessage: {
                this.code = 208;
                break;
            }
            case DefinedByTheWAPForum: {
                this.code = 224;
                break;
            }
            case DataCodingMessageClass: {
                this.code = 240;
                if (messageClass != null) {
                    this.code |= messageClass.getCode();
                }
                if (characterSet == null || characterSet != CharacterSet.GSM8) break;
                this.code |= 4;
                break;
            }
            default: {
                this.code = 15;
            }
        }
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public CBSDataCodingGroup getDataCodingGroup() {
        switch ((this.code & 0xF0) >> 4) {
            case 0: 
            case 2: 
            case 3: {
                return CBSDataCodingGroup.GeneralGsm7;
            }
            case 1: {
                return CBSDataCodingGroup.GeneralWithLanguageIndication;
            }
            case 9: {
                return CBSDataCodingGroup.MessageWithUserDataHeader;
            }
            case 13: {
                return CBSDataCodingGroup.I1ProtocolMessage;
            }
            case 14: {
                return CBSDataCodingGroup.DefinedByTheWAPForum;
            }
            case 15: {
                return CBSDataCodingGroup.DataCodingMessageClass;
            }
        }
        if ((this.code & 0xC0) == 64) {
            return CBSDataCodingGroup.GeneralDataCodingIndication;
        }
        return CBSDataCodingGroup.Reserved;
    }

    @Override
    public CBSNationalLanguage getNationalLanguageShiftTable() {
        if (this.getDataCodingGroup() == CBSDataCodingGroup.GeneralGsm7) {
            return CBSNationalLanguage.getInstance((this.code & 0xF0) >> 4, this.code & 0xF);
        }
        return null;
    }

    @Override
    public CharacterSet getCharacterSet() {
        switch (this.getDataCodingGroup()) {
            case GeneralGsm7: {
                return CharacterSet.GSM7;
            }
            case GeneralWithLanguageIndication: {
                if ((this.code & 0xF) == 1) {
                    return CharacterSet.UCS2;
                }
                return CharacterSet.GSM7;
            }
            case GeneralDataCodingIndication: 
            case MessageWithUserDataHeader: {
                return CharacterSet.getInstance((this.code & 0xC) >> 2);
            }
            case DataCodingMessageClass: {
                if ((this.code & 4) != 0) {
                    return CharacterSet.GSM8;
                }
                return CharacterSet.GSM7;
            }
        }
        return null;
    }

    @Override
    public DataCodingSchemaMessageClass getMessageClass() {
        switch (this.getDataCodingGroup()) {
            case GeneralDataCodingIndication: {
                if ((this.code & 0x10) != 0) {
                    return DataCodingSchemaMessageClass.getInstance(this.code & 3);
                }
                return null;
            }
            case MessageWithUserDataHeader: 
            case DataCodingMessageClass: {
                return DataCodingSchemaMessageClass.getInstance(this.code & 3);
            }
        }
        return null;
    }

    @Override
    public boolean getIsCompressed() {
        return this.getDataCodingGroup() == CBSDataCodingGroup.GeneralDataCodingIndication && (this.code & 0x20) != 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CBSDataCodingSchemeImpl other = (CBSDataCodingSchemeImpl)obj;
        return this.code == other.code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CBSDataCodingScheme [");
        sb.append("Code=");
        sb.append(this.code);
        sb.append(", CBSDataCodingGroup=");
        sb.append((Object)this.getDataCodingGroup());
        if (this.getMessageClass() != null) {
            sb.append(", MessageClass=");
            sb.append((Object)this.getMessageClass());
        }
        if (this.getNationalLanguageShiftTable() != null) {
            sb.append(", NationalLanguageShiftTable=");
            sb.append((Object)this.getNationalLanguageShiftTable());
        }
        if (this.getCharacterSet() != null) {
            sb.append(", CharacterSet=");
            sb.append((Object)this.getCharacterSet());
        }
        if (this.getIsCompressed()) {
            sb.append(", Compressed");
        }
        sb.append("]");
        return sb.toString();
    }
}

