/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.fsm;

import javolution.util.FastList;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSMStateEventHandler;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.Transition;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;

public class FSMState {
    private String name;
    private FSM fsm;
    private FastList<Transition> transitions = new FastList();
    protected long timeout;
    private long activated;
    private long oldActivated;
    private FSMStateEventHandler enterEventHandler;
    private FSMStateEventHandler exitEventHandler;
    private FSMStateEventHandler timeOutEventHandler;

    protected FSMState(FSM fsm, String name) {
        this.name = name;
        this.fsm = fsm;
        this.timeout = 0L;
    }

    public FSMState setOnEnter(FSMStateEventHandler handler) {
        this.enterEventHandler = handler;
        return this;
    }

    public FSMState setOnExit(FSMStateEventHandler handler) {
        this.exitEventHandler = handler;
        return this;
    }

    public FSMState setOnTimeOut(FSMStateEventHandler handler, long timeout) {
        this.timeOutEventHandler = handler;
        this.timeout = timeout;
        return this;
    }

    protected void enter() {
        this.oldActivated = this.activated = System.currentTimeMillis();
        if (this.enterEventHandler != null) {
            this.enterEventHandler.onEvent(this);
        }
    }

    protected void leave() {
        this.activated = 0L;
        if (this.exitEventHandler != null) {
            this.exitEventHandler.onEvent(this);
        }
    }

    protected void cancelLeave() {
        this.activated = this.oldActivated;
    }

    protected void tick(long now) {
        if (this.timeout > 0L && this.activated > 0L && now - this.activated > this.timeout) {
            if (this.timeOutEventHandler != null) {
                this.timeOutEventHandler.onEvent(this);
            }
            try {
                this.fsm.signal("timeout");
            }
            catch (UnknownTransitionException unknownTransitionException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public FSM getFSM() {
        return this.fsm;
    }

    protected void add(Transition t) {
        this.transitions.add(t);
    }

    public FSMState signal(String namem) throws UnknownTransitionException {
        Transition t = this.find(namem);
        if (t != null) {
            return t.process(this);
        }
        throw new UnknownTransitionException(String.format("Transition=%s. %s", namem, this.fsm.toString()));
    }

    private Transition find(String name) {
        for (Transition t : this.transitions) {
            if (!t.getName().matches(name)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

