/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.indicator;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.indicator.GlobalTitleIndicator;
import org.restcomm.protocols.ss7.indicator.RoutingIndicator;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;

public class AddressIndicator
implements XMLSerializable {
    private static final String VALUE = "value";
    private GlobalTitleIndicator globalTitleIndicator;
    private boolean pcPresent;
    private boolean ssnPresent;
    private RoutingIndicator routingIndicator;
    private boolean reservedForNationalUseBit;
    protected static final XMLFormat<AddressIndicator> XML = new XMLFormat<AddressIndicator>(AddressIndicator.class){

        @Override
        public void write(AddressIndicator ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(AddressIndicator.VALUE, ai.getValue(SccpProtocolVersion.ITU));
        }

        @Override
        public void read(XMLFormat.InputElement xml, AddressIndicator ai) throws XMLStreamException {
            byte b = (byte)xml.getAttribute(AddressIndicator.VALUE).toInt();
            ai.init(b, SccpProtocolVersion.ITU);
        }
    };

    public AddressIndicator() {
    }

    public AddressIndicator(boolean pcPresent, boolean ssnPresent, RoutingIndicator rti, GlobalTitleIndicator gti) {
        this.pcPresent = pcPresent;
        this.ssnPresent = ssnPresent;
        this.routingIndicator = rti;
        this.globalTitleIndicator = gti;
    }

    public AddressIndicator(byte v, SccpProtocolVersion sccpProtocolVersion) {
        this.init(v, sccpProtocolVersion);
    }

    private void init(byte v, SccpProtocolVersion sccpProtocolVersion) {
        if (sccpProtocolVersion == SccpProtocolVersion.ANSI) {
            this.ssnPresent = (v & 1) == 1;
            this.pcPresent = (v & 2) == 2;
            int gtiCode = v >> 2 & 0xF;
            switch (gtiCode) {
                case 1: {
                    this.globalTitleIndicator = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME;
                    break;
                }
                case 2: {
                    this.globalTitleIndicator = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY;
                    break;
                }
                default: {
                    this.globalTitleIndicator = GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED;
                    break;
                }
            }
        } else {
            this.pcPresent = (v & 1) == 1;
            this.ssnPresent = (v & 2) == 2;
            this.globalTitleIndicator = GlobalTitleIndicator.valueOf(v >> 2 & 0xF);
            if (this.globalTitleIndicator == null) {
                this.globalTitleIndicator = GlobalTitleIndicator.NO_GLOBAL_TITLE_INCLUDED;
            }
        }
        this.routingIndicator = (v >> 6 & 1) == 1 ? RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN : RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE;
        this.reservedForNationalUseBit = (v & 0x80) == 128;
    }

    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return this.globalTitleIndicator;
    }

    public boolean isPCPresent() {
        return this.pcPresent;
    }

    public boolean isSSNPresent() {
        return this.ssnPresent;
    }

    public RoutingIndicator getRoutingIndicator() {
        return this.routingIndicator;
    }

    public boolean isReservedForNationalUseBit() {
        return this.reservedForNationalUseBit;
    }

    public byte getValue(SccpProtocolVersion sccpProtocolVersion) {
        int b = 0;
        if (sccpProtocolVersion == SccpProtocolVersion.ANSI) {
            if (this.ssnPresent) {
                b |= 1;
            }
            if (this.pcPresent) {
                b |= 2;
            }
            int gtiCode = 0;
            switch (this.globalTitleIndicator) {
                case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                    gtiCode = 1;
                    break;
                }
                case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                    gtiCode = 2;
                }
            }
            b |= gtiCode << 2;
        } else {
            if (this.pcPresent) {
                b |= 1;
            }
            if (this.ssnPresent) {
                b |= 2;
            }
            b |= this.globalTitleIndicator.getValue() << 2;
        }
        if (this.routingIndicator == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN) {
            b |= 0x40;
        }
        if (sccpProtocolVersion == SccpProtocolVersion.ANSI) {
            b |= 0x80;
        }
        return (byte)b;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.globalTitleIndicator == null ? 0 : this.globalTitleIndicator.hashCode());
        result = 31 * result + (this.pcPresent ? 1231 : 1237);
        result = 31 * result + (this.routingIndicator == null ? 0 : this.routingIndicator.hashCode());
        result = 31 * result + (this.ssnPresent ? 1231 : 1237);
        result = 31 * result + (this.reservedForNationalUseBit ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressIndicator other = (AddressIndicator)obj;
        if (this.globalTitleIndicator != other.globalTitleIndicator) {
            return false;
        }
        if (this.pcPresent != other.pcPresent) {
            return false;
        }
        if (this.routingIndicator != other.routingIndicator) {
            return false;
        }
        return this.ssnPresent == other.ssnPresent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AddressIndicator[");
        sb.append("globalTitleIndicator=");
        sb.append((Object)this.globalTitleIndicator);
        sb.append(", pcPresent=");
        sb.append(this.pcPresent);
        sb.append(", ssnPresent=");
        sb.append(this.ssnPresent);
        sb.append(", routingIndicator=");
        sb.append((Object)this.routingIndicator);
        if (this.reservedForNationalUseBit) {
            sb.append(", reservedForNationalUseBit");
        }
        sb.append("]");
        return sb.toString();
    }
}

