/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp.netty;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.sctp.netty.NettyAssociationImpl;
import org.mobicents.protocols.sctp.netty.NettySctpChannelInboundHandlerAdapter;

public class NettySctpClientHandler
extends NettySctpChannelInboundHandlerAdapter {
    private final Logger logger = Logger.getLogger(NettySctpClientHandler.class);

    public NettySctpClientHandler(NettyAssociationImpl nettyAssociationImpl) {
        this.association = nettyAssociationImpl;
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.logger.warn(String.format("ChannelUnregistered event: association=%s", this.association));
        this.association.setChannelHandler(null);
        this.association.scheduleConnect();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("channelRegistered event: association=%s", this.association));
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("channelActive event: association=%s", this.association));
        }
        this.ctx = ctx;
        this.channel = ctx.channel();
        this.association.setChannelHandler(this);
        String host = null;
        int port = 0;
        InetSocketAddress sockAdd = (InetSocketAddress)this.channel.remoteAddress();
        if (sockAdd != null) {
            host = sockAdd.getAddress().getHostAddress();
            port = sockAdd.getPort();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Association=%s connected to host=%s port=%d", this.association.getName(), host, port));
        }
        if (this.association.getIpChannelType() == IpChannelType.TCP) {
            this.association.markAssociationUp(1, 1);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("ExceptionCaught for Associtaion: " + this.association.getName() + "\n", cause);
        ctx.close();
    }
}

