/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.ss7.congestion;

import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.restcomm.ss7.congestion.BaseCongestionMonitor;
import org.restcomm.ss7.congestion.CongestionTicketImpl;
import org.restcomm.ss7.congestion.ExecutorCongestionMonitor;

public class ExecutorCongestionMonitorImpl
extends BaseCongestionMonitor
implements ExecutorCongestionMonitor {
    private static final String SOURCE = "EXECUTOR_";
    private String productName;
    private String source;
    private int currentAlarmLevel = 0;
    private ExecutorService[] executors;
    private double[] delayThreshold = new double[]{1.0, 6.0, 12.0};
    private double[] backToNormalDelayThreshold = new double[]{0.5, 3.0, 8.0};
    protected double calculatedMaxValue;

    public ExecutorCongestionMonitorImpl(String productName, ExecutorService[] executors) {
        this.productName = productName;
        this.executors = executors;
        this.source = SOURCE + productName;
    }

    @Override
    public void monitor() {
        TestMonitor testMonitor = new TestMonitor();
        testMonitor.startMonitor();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    protected CongestionTicketImpl generateTicket() {
        return new CongestionTicketImpl(this.source, this.currentAlarmLevel);
    }

    @Override
    public int getAlarmLevel() {
        return this.currentAlarmLevel;
    }

    @Override
    protected void setAlarmLevel(int val) {
        this.currentAlarmLevel = val;
    }

    @Override
    public double getDelayThreshold_1() {
        return this.delayThreshold[0];
    }

    @Override
    public double getDelayThreshold_2() {
        return this.delayThreshold[1];
    }

    @Override
    public double getDelayThreshold_3() {
        return this.delayThreshold[2];
    }

    @Override
    public double getBackToNormalDelayThreshold_1() {
        return this.backToNormalDelayThreshold[0];
    }

    @Override
    public double getBackToNormalDelayThreshold_2() {
        return this.backToNormalDelayThreshold[1];
    }

    @Override
    public double getBackToNormalDelayThreshold_3() {
        return this.backToNormalDelayThreshold[2];
    }

    @Override
    public void setDelayThreshold_1(double value) throws Exception {
        this.delayThreshold[0] = value;
    }

    @Override
    public void setDelayThreshold_2(double value) throws Exception {
        this.delayThreshold[1] = value;
    }

    @Override
    public void setDelayThreshold_3(double value) throws Exception {
        this.delayThreshold[2] = value;
    }

    @Override
    public void setBackToNormalDelayThreshold_1(double value) throws Exception {
        this.backToNormalDelayThreshold[0] = value;
    }

    @Override
    public void setBackToNormalDelayThreshold_2(double value) throws Exception {
        this.backToNormalDelayThreshold[1] = value;
    }

    @Override
    public void setBackToNormalDelayThreshold_3(double value) throws Exception {
        this.backToNormalDelayThreshold[2] = value;
    }

    private void registerResults(double maxValue) {
        this.calculatedMaxValue = maxValue;
        super.applyNewValue(this.currentAlarmLevel, maxValue, this.delayThreshold, this.backToNormalDelayThreshold, true);
    }

    @Override
    protected String getAlarmDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Last measured max delay between delivering an IP message for sending and a moment when the message was transferred via an IP channel (seconds): ");
        sb.append(this.calculatedMaxValue);
        return sb.toString();
    }

    public class ExecutorTestMonitor
    implements Runnable {
        private TestMonitor testMonitor;
        private long startTime;
        private double delay;
        private boolean finished = false;

        public ExecutorTestMonitor(TestMonitor testMonitor) {
            this.testMonitor = testMonitor;
            this.startTime = new Date().getTime();
        }

        @Override
        public void run() {
            long endTime = new Date().getTime();
            this.delay = ((double)endTime - (double)this.startTime) / 1000.0;
            this.finished = true;
            this.testMonitor.monitor();
        }

        public double getDelay() {
            return this.delay;
        }

        public boolean getFinished() {
            return this.finished;
        }
    }

    public class TestMonitor {
        private ExecutorTestMonitor[] monitorList;
        private int cnt;
        private int finished = 0;

        public void startMonitor() {
            this.cnt = ExecutorCongestionMonitorImpl.this.executors.length;
            this.monitorList = new ExecutorTestMonitor[this.cnt];
            for (int i1 = 0; i1 < this.cnt; ++i1) {
                ExecutorService ex = ExecutorCongestionMonitorImpl.this.executors[i1];
                this.monitorList[i1] = new ExecutorTestMonitor(this);
                ex.execute(this.monitorList[i1]);
            }
        }

        public synchronized void monitor() {
            if (++this.finished >= this.cnt - 1) {
                double maxValue = 0.0;
                for (ExecutorTestMonitor testMonitor : this.monitorList) {
                    if (testMonitor == null || !(maxValue < testMonitor.getDelay())) continue;
                    maxValue = testMonitor.getDelay();
                }
                ExecutorCongestionMonitorImpl.this.registerResults(maxValue);
            }
        }
    }
}

