/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.oam;

import java.util.Arrays;
import java.util.Map;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.tcap.TCAPStackImpl;
import org.restcomm.ss7.management.console.ShellExecutor;

public class TCAPExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(TCAPExecutor.class);
    private FastMap<String, TCAPStackImpl> tcapStacks = new FastMap();
    private TCAPStackImpl tcapStack = null;

    public Map<String, TCAPStackImpl> getTcapStacks() {
        return this.tcapStacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTcapStacks(Map<String, TCAPStackImpl> mtp3UserPartsTemp) {
        if (mtp3UserPartsTemp != null) {
            TCAPExecutor tCAPExecutor = this;
            synchronized (tCAPExecutor) {
                FastMap<String, TCAPStackImpl> newMtp3UserPart = new FastMap<String, TCAPStackImpl>();
                newMtp3UserPart.putAll(mtp3UserPartsTemp);
                this.tcapStacks = newMtp3UserPart;
            }
        }
    }

    private void setDefaultValue() {
        if (this.tcapStack == null) {
            Map.Entry<String, TCAPStackImpl> sccpStacksTmp = this.tcapStacks.entrySet().iterator().next();
            this.tcapStack = sccpStacksTmp.getValue();
        }
    }

    public String execute(String[] options) {
        if (this.tcapStacks == null || this.tcapStacks.size() == 0) {
            logger.warn("TCAPStackImpl not set. Command will not be executed ");
            return "Server Error";
        }
        if (options == null || options.length < 2) {
            return "Invalid Command";
        }
        String firstOption = options[1];
        if (firstOption == null) {
            return "Invalid Command";
        }
        try {
            if (firstOption.equals("set")) {
                return this.manageSet(options);
            }
            if (firstOption.equals("get")) {
                return this.manageGet(options);
            }
        }
        catch (Throwable t) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(options)), t);
            return t.getMessage();
        }
        return "Invalid Command";
    }

    public boolean handles(String command) {
        return command.startsWith("tcap");
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        int count = 4;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                TCAPStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = this.tcapStacks.get(m3uaStackName = options[count++])) == null) {
                    return String.format("No TCAP stack configured for name %s", m3uaStackName);
                }
                this.tcapStack = sccpStaclImpl;
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        String parName = options[2].toLowerCase();
        if (parName.equals("dialogidletimeout")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setDialogIdleTimeout(val);
        } else if (parName.equals("invoketimeout")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setInvokeTimeout(val);
        } else if (parName.equals("maxdialogs")) {
            int val = Integer.parseInt(options[3]);
            this.tcapStack.setMaxDialogs(val);
        } else if (parName.equals("dialogidrangestart")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setDialogIdRangeStart(val);
        } else if (parName.equals("dialogidrangeend")) {
            long val = Long.parseLong(options[3]);
            this.tcapStack.setDialogIdRangeEnd(val);
        } else if (parName.equals("donotsendprotocolversion")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.tcapStack.setDoNotSendProtocolVersion(val);
        } else if (parName.equals("statisticsenabled")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.tcapStack.setStatisticsEnabled(val);
        } else if (parName.equals("executordelaythreshold_1")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_ExecutorDelayThreshold_1(val);
        } else if (parName.equals("executordelaythreshold_2")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_ExecutorDelayThreshold_2(val);
        } else if (parName.equals("executordelaythreshold_3")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_ExecutorDelayThreshold_3(val);
        } else if (parName.equals("executorbacktonormaldelaythreshold_1")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_ExecutorBackToNormalDelayThreshold_1(val);
        } else if (parName.equals("executorbacktonormaldelaythreshold_2")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_ExecutorBackToNormalDelayThreshold_2(val);
        } else if (parName.equals("executorbacktonormaldelaythreshold_3")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_ExecutorBackToNormalDelayThreshold_3(val);
        } else if (parName.equals("memorythreshold_1")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_MemoryThreshold_1(val);
        } else if (parName.equals("memorythreshold_2")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_MemoryThreshold_2(val);
        } else if (parName.equals("memorythreshold_3")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_MemoryThreshold_3(val);
        } else if (parName.equals("backtonormalmemorythreshold_1")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_BackToNormalMemoryThreshold_1(val);
        } else if (parName.equals("backtonormalmemorythreshold_2")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_BackToNormalMemoryThreshold_2(val);
        } else if (parName.equals("backtonormalmemorythreshold_3")) {
            double val = Double.parseDouble(options[3]);
            this.tcapStack.setCongControl_BackToNormalMemoryThreshold_3(val);
        } else if (parName.equals("blockingincomingtcapmessages")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.tcapStack.setCongControl_blockingIncomingTcapMessages(val);
        } else if (parName.equals("slsrange")) {
            String val = String.valueOf(options[3]);
            this.tcapStack.setSlsRange(val);
        } else {
            return "Invalid Command";
        }
        return String.format("Parameter has been successfully set for stack=%s", this.tcapStack.getName());
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            this.setDefaultValue();
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("dialogidletimeout")) {
                sb.append(this.tcapStack.getDialogIdleTimeout());
            } else if (parName.equals("invoketimeout")) {
                sb.append(this.tcapStack.getInvokeTimeout());
            } else if (parName.equals("maxdialogs")) {
                sb.append(this.tcapStack.getMaxDialogs());
            } else if (parName.equals("dialogidrangestart")) {
                sb.append(this.tcapStack.getDialogIdRangeStart());
            } else if (parName.equals("dialogidrangeend")) {
                sb.append(this.tcapStack.getDialogIdRangeEnd());
            } else if (parName.equals("previewmode")) {
                sb.append(this.tcapStack.getPreviewMode());
            } else if (parName.equals("donotsendprotocolversion")) {
                sb.append(this.tcapStack.getDoNotSendProtocolVersion());
            } else if (parName.equals("statisticsenabled")) {
                sb.append(this.tcapStack.getStatisticsEnabled());
            } else if (parName.equals("ssn")) {
                sb.append(this.tcapStack.getSubSystemNumber());
            } else if (parName.equals("executordelaythreshold_1")) {
                sb.append(this.tcapStack.getCongControl_ExecutorDelayThreshold_1());
            } else if (parName.equals("executordelaythreshold_2")) {
                sb.append(this.tcapStack.getCongControl_ExecutorDelayThreshold_2());
            } else if (parName.equals("executordelaythreshold_3")) {
                sb.append(this.tcapStack.getCongControl_ExecutorDelayThreshold_3());
            } else if (parName.equals("executorbacktonormaldelaythreshold_1")) {
                sb.append(this.tcapStack.getCongControl_ExecutorBackToNormalDelayThreshold_1());
            } else if (parName.equals("executorbacktonormaldelaythreshold_2")) {
                sb.append(this.tcapStack.getCongControl_ExecutorBackToNormalDelayThreshold_2());
            } else if (parName.equals("executorbacktonormaldelaythreshold_3")) {
                sb.append(this.tcapStack.getCongControl_ExecutorBackToNormalDelayThreshold_3());
            } else if (parName.equals("memorythreshold_1")) {
                sb.append(this.tcapStack.getCongControl_MemoryThreshold_1());
            } else if (parName.equals("memorythreshold_2")) {
                sb.append(this.tcapStack.getCongControl_MemoryThreshold_2());
            } else if (parName.equals("memorythreshold_3")) {
                sb.append(this.tcapStack.getCongControl_MemoryThreshold_3());
            } else if (parName.equals("backtonormalmemorythreshold_1")) {
                sb.append(this.tcapStack.getCongControl_BackToNormalMemoryThreshold_1());
            } else if (parName.equals("backtonormalmemorythreshold_2")) {
                sb.append(this.tcapStack.getCongControl_BackToNormalMemoryThreshold_2());
            } else if (parName.equals("backtonormalmemorythreshold_3")) {
                sb.append(this.tcapStack.getCongControl_BackToNormalMemoryThreshold_3());
            } else if (parName.equals("blockingincomingtcapmessages")) {
                sb.append(this.tcapStack.isCongControl_blockingIncomingTcapMessages());
            } else if (parName.equals("slsrange")) {
                sb.append(this.tcapStack.getSlsRange());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        FastCollection.Record e = this.tcapStacks.head();
        FastMap.Entry<String, TCAPStackImpl> end = this.tcapStacks.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            TCAPStackImpl tcapStackImpl = (TCAPStackImpl)((FastMap.Entry)e).getValue();
            String tcapStackname = (String)((FastMap.Entry)e).getKey();
            sb.append("Properties for ");
            sb.append(tcapStackname);
            sb.append("\n");
            sb.append("*******************\n");
            sb.append("dialogidletimeout = ");
            sb.append(tcapStackImpl.getDialogIdleTimeout());
            sb.append("\n");
            sb.append("invoketimeout = ");
            sb.append(tcapStackImpl.getInvokeTimeout());
            sb.append("\n");
            sb.append("maxdialogs = ");
            sb.append(tcapStackImpl.getMaxDialogs());
            sb.append("\n");
            sb.append("dialogidrangestart = ");
            sb.append(tcapStackImpl.getDialogIdRangeStart());
            sb.append("\n");
            sb.append("dialogidrangeend = ");
            sb.append(tcapStackImpl.getDialogIdRangeEnd());
            sb.append("\n");
            sb.append("previewmode = ");
            sb.append(tcapStackImpl.getPreviewMode());
            sb.append("\n");
            sb.append("donotsendprotocolversion = ");
            sb.append(tcapStackImpl.getDoNotSendProtocolVersion());
            sb.append("\n");
            sb.append("statisticsenabled = ");
            sb.append(tcapStackImpl.getStatisticsEnabled());
            sb.append("\n");
            sb.append("subsystemnumber = ");
            sb.append(tcapStackImpl.getSubSystemNumber());
            sb.append("\n");
            sb.append("executordelaythreshold_1 = ");
            sb.append(tcapStackImpl.getCongControl_ExecutorDelayThreshold_1());
            sb.append("\n");
            sb.append("executordelaythreshold_2 = ");
            sb.append(tcapStackImpl.getCongControl_ExecutorDelayThreshold_2());
            sb.append("\n");
            sb.append("executordelaythreshold_3 = ");
            sb.append(tcapStackImpl.getCongControl_ExecutorDelayThreshold_3());
            sb.append("\n");
            sb.append("executorbacktonormaldelaythreshold_1 = ");
            sb.append(tcapStackImpl.getCongControl_ExecutorBackToNormalDelayThreshold_1());
            sb.append("\n");
            sb.append("executorbacktonormaldelaythreshold_2 = ");
            sb.append(tcapStackImpl.getCongControl_ExecutorBackToNormalDelayThreshold_2());
            sb.append("\n");
            sb.append("executorbacktonormaldelaythreshold_3 = ");
            sb.append(tcapStackImpl.getCongControl_ExecutorBackToNormalDelayThreshold_3());
            sb.append("\n");
            sb.append("memorythreshold_1 = ");
            sb.append(tcapStackImpl.getCongControl_MemoryThreshold_1());
            sb.append("\n");
            sb.append("memorythreshold_2 = ");
            sb.append(tcapStackImpl.getCongControl_MemoryThreshold_2());
            sb.append("\n");
            sb.append("memorythreshold_3 = ");
            sb.append(tcapStackImpl.getCongControl_MemoryThreshold_3());
            sb.append("\n");
            sb.append("backtonormalmemorythreshold_1 = ");
            sb.append(tcapStackImpl.getCongControl_BackToNormalMemoryThreshold_1());
            sb.append("\n");
            sb.append("backtonormalmemorythreshold_2 = ");
            sb.append(tcapStackImpl.getCongControl_BackToNormalMemoryThreshold_2());
            sb.append("\n");
            sb.append("backtonormalmemorythreshold_3 = ");
            sb.append(tcapStackImpl.getCongControl_BackToNormalMemoryThreshold_3());
            sb.append("\n");
            sb.append("blockingincomingtcapmessages = ");
            sb.append(tcapStackImpl.isCongControl_blockingIncomingTcapMessages());
            sb.append("\n");
            sb.append("slsrange = ");
            sb.append(tcapStackImpl.getSlsRange());
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }
}

