/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLSerializable;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.EncodingScheme;
import org.restcomm.protocols.ss7.sccp.parameter.EncodingSchemeType;

public class DefaultEncodingScheme
implements EncodingScheme,
XMLSerializable {
    public static final EncodingScheme INSTANCE = new DefaultEncodingScheme();
    public static final int SCHEMA_CODE = 0;

    @Override
    public EncodingSchemeType getType() {
        return EncodingSchemeType.UNKNOWN;
    }

    @Override
    public byte getSchemeCode() {
        return 0;
    }

    protected boolean isOdd() {
        return false;
    }

    @Override
    public void encode(String digits, OutputStream out) throws ParseException {
        try {
            boolean odd = this.getSchemeCode() != 0 ? this.isOdd() : digits.length() % 2 != 0;
            byte b = 0;
            int count = odd ? digits.length() - 1 : digits.length();
            for (int i = 0; i < count - 1; i += 2) {
                String ds1 = digits.substring(i, i + 1);
                String ds2 = digits.substring(i + 1, i + 2);
                int d1 = Integer.parseInt(ds1, 16);
                int d2 = Integer.parseInt(ds2, 16);
                b = (byte)(d2 << 4 | d1);
                out.write(b);
            }
            if (odd) {
                String ds1 = digits.substring(count, count + 1);
                int d = Integer.parseInt(ds1, 16);
                b = (byte)(d & 0xF);
                out.write(b);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public String decode(InputStream is) throws ParseException {
        try {
            StringBuilder digits = new StringBuilder();
            while (is.available() > 0) {
                int b = is.read() & 0xFF;
                digits.append(Integer.toHexString(b & 0xF));
                digits.append(Integer.toHexString((b & 0xF0) >> 4));
            }
            if (this.isOdd()) {
                digits.deleteCharAt(digits.length() - 1);
            }
            return digits.toString().toLowerCase();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = this.getSchemeCode();
        result = 31 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getSchemeCode() == ((EncodingScheme)obj).getSchemeCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this.getType()) + ", code=" + this.getSchemeCode() + "]";
    }
}

