/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageUtil;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnReferencedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ImportanceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.RefusalCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnCrefMessage;
import org.restcomm.protocols.ss7.sccp.parameter.Importance;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.RefusalCause;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpConnCrefMessageImpl
extends SccpConnReferencedMessageImpl
implements SccpConnCrefMessage {
    protected SccpAddress calledPartyAddress;
    protected byte[] userData;
    protected RefusalCause refusalCause;
    protected Importance importance;

    public SccpConnCrefMessageImpl(int sls, int localSsn) {
        super(130, 3, sls, localSsn);
    }

    protected SccpConnCrefMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(130, 3, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public SccpAddress getCalledPartyAddress() {
        return this.calledPartyAddress;
    }

    @Override
    public void setCalledPartyAddress(SccpAddress calledPartyAddress) {
        this.calledPartyAddress = calledPartyAddress;
    }

    @Override
    public byte[] getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(byte[] userData) {
        this.userData = userData;
    }

    @Override
    public RefusalCause getRefusalCause() {
        return this.refusalCause;
    }

    @Override
    public void setRefusalCause(RefusalCause refusalCause) {
        this.refusalCause = refusalCause;
    }

    @Override
    public Importance getImportance() {
        return this.importance;
    }

    @Override
    public void setImportance(Importance importance) {
        this.importance = importance;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            RefusalCauseImpl cause = new RefusalCauseImpl();
            cause.decode(buffer, factory, sccpProtocolVersion);
            this.refusalCause = cause;
            int pointer = in.read() & 0xFF;
            in.mark(in.available());
            if (pointer == 0) {
                return;
            }
            if ((long)(pointer - 1) != in.skip(pointer - 1)) {
                throw new IOException("Not enough data in buffer");
            }
            int paramCode = 0;
            while ((paramCode = in.read() & 0xFF) != 0) {
                if (paramCode != 3 && paramCode != 15 && paramCode != 18) {
                    throw new ParseException(String.format("Code %d is not supported for CREF message", paramCode));
                }
                int len = in.read() & 0xFF;
                buffer = new byte[len];
                in.read(buffer);
                this.decodeOptional(paramCode, buffer, sccpProtocolVersion, factory);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            int fieldsLen;
            int availLen;
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.refusalCause == null) {
                return new EncodingResultData(EncodingResult.RefusalCauseMissing, null, null, null);
            }
            byte[] cdp = new byte[]{};
            if (this.calledPartyAddress != null) {
                cdp = ((SccpAddressImpl)this.calledPartyAddress).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            }
            byte[] bf = new byte[]{};
            if (this.userData != null) {
                bf = this.userData;
            }
            if ((availLen = maxMtp3UserDataLength - (fieldsLen = MessageUtil.calculateCrefFieldsLengthWithoutData(cdp.length, this.importance != null))) > 130) {
                availLen = 130;
            }
            if (bf.length > availLen) {
                if (logger.isEnabledFor(Level.WARN)) {
                    logger.warn(String.format("Failure when sending a CREF message: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_NOT_SUPPORTED);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLen + bf.length);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] ref = ((RefusalCauseImpl)this.refusalCause).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(ref);
            int len = 1;
            boolean optionalPresent = false;
            if (this.calledPartyAddress != null || this.userData != null || this.importance != null) {
                out.write(len);
                optionalPresent = true;
            } else {
                out.write(0);
            }
            if (this.calledPartyAddress != null) {
                out.write(3);
                out.write(cdp.length);
                out.write(cdp);
            }
            if (this.userData != null) {
                out.write(15);
                out.write(this.userData.length);
                out.write(this.userData);
            }
            if (this.importance != null) {
                out.write(18);
                byte[] b = ((ImportanceImpl)this.importance).encode(removeSPC, sccpProtocolVersion);
                out.write(b.length);
                out.write(b);
            }
            if (optionalPresent) {
                out.write(0);
            }
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    protected void decodeOptional(int code, byte[] buffer, SccpProtocolVersion sccpProtocolVersion, ParameterFactory factory) throws ParseException {
        switch (code) {
            case 3: {
                SccpAddressImpl address2 = new SccpAddressImpl();
                address2.decode(buffer, factory, sccpProtocolVersion);
                this.calledPartyAddress = address2;
                break;
            }
            case 15: {
                this.userData = buffer;
                break;
            }
            case 18: {
                ImportanceImpl imp = new ImportanceImpl();
                imp.decode(buffer, factory, sccpProtocolVersion);
                this.importance = imp;
                break;
            }
            default: {
                throw new ParseException("Unknown optional parameter code: " + code);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=Cref");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" CalledParty(");
        sb.append(this.calledPartyAddress);
        sb.append(")");
        sb.append(" DataLen=");
        if (this.userData != null) {
            sb.append(this.userData.length);
        }
        sb.append(" destLR=");
        if (this.destinationLocalReferenceNumber != null) {
            sb.append(this.destinationLocalReferenceNumber.getValue());
        }
        sb.append(" refusalCause=");
        if (this.refusalCause != null) {
            sb.append((Object)this.refusalCause.getValue());
        }
        sb.append(" importance=");
        if (this.importance != null) {
            sb.append(this.importance.getValue());
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

