/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.restcomm.protocols.ss7.sccp.SccpConnection;
import org.restcomm.protocols.ss7.sccp.SccpConnectionState;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpFlowControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnAkMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt2MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRsrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnCrMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.Credit;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.ResetCause;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpConnectionWithFlowControlImpl
extends SccpConnectionImpl
implements SccpConnection {
    protected SccpFlowControl flow;
    private boolean overloaded;

    public SccpConnectionWithFlowControlImpl(int localSsn, LocalReference localReference, ProtocolClass protocol, SccpStackImpl stack, SccpRoutingControl sccpRoutingControl) {
        super(localSsn, localReference, protocol, stack, sccpRoutingControl);
        if (protocol.getProtocolClass() != 3) {
            this.logger.error("Using connection class for non-supported protocol class 2");
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void establish(SccpConnCrMessage message) throws IOException {
        this.flow = this.newSccpFlowControl(message.getCredit());
        super.establish(message);
    }

    @Override
    public void confirm(SccpAddress respondingAddress, Credit credit, byte[] data) throws Exception {
        if (this.getState() != SccpConnectionState.CR_RECEIVED) {
            this.logger.error(String.format("Trying to confirm connection in non-compatible state %s", new Object[]{this.getState()}));
            throw new IllegalStateException(String.format("Trying to confirm connection in non-compatible state %s", new Object[]{this.getState()}));
        }
        this.flow = this.newSccpFlowControl(credit);
        super.confirm(respondingAddress, credit, data);
    }

    protected SccpFlowControl newSccpFlowControl(Credit credit) {
        return new SccpFlowControl(this.stack.name, credit.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverloaded(boolean overloaded) throws Exception {
        try {
            this.connectionLock.lock();
            if (this.overloaded == overloaded) {
                return;
            }
            if (overloaded) {
                this.sendAk(new CreditImpl(0));
            } else {
                this.sendAk();
            }
            this.overloaded = overloaded;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    @Override
    protected void prepareMessageForSending(SccpConnSegmentableMessageImpl message) {
        if (message instanceof SccpConnDt2MessageImpl) {
            SccpConnDt2MessageImpl dt2 = (SccpConnDt2MessageImpl)message;
            this.flow.initializeMessageNumbering(dt2);
            this.flow.checkOutputMessageNumbering(dt2);
            if (!this.flow.isAuthorizedToTransmitAnotherMessage()) {
                this.setState(SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected void prepareMessageForSending(SccpConnItMessageImpl it) {
        it.setCredit(new CreditImpl(this.flow.getReceiveCredit()));
        this.flow.initializeMessageNumbering(it);
        this.flow.checkOutputMessageNumbering(it);
        if (!this.flow.isAuthorizedToTransmitAnotherMessage()) {
            this.setState(SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receiveMessage(SccpConnMessage message) throws Exception {
        try {
            this.connectionLock.lock();
            super.receiveMessage(message);
            if (message instanceof SccpConnCcMessageImpl) {
                SccpConnCcMessageImpl cc = (SccpConnCcMessageImpl)message;
                if (cc.getCredit() != null) {
                    this.flow = this.newSccpFlowControl(cc.getCredit());
                }
            } else if (message instanceof SccpConnAkMessageImpl) {
                this.handleAkMessage((SccpConnAkMessageImpl)message);
            } else if (message instanceof SccpConnRsrMessageImpl) {
                this.flow.reinitialize();
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    @Override
    protected void receiveDataMessage(SccpConnSegmentableMessageImpl msg) throws Exception {
        if (!this.isAvailable()) {
            this.logger.error((Object)((Object)this.getState()) + " Message discarded " + msg);
            return;
        }
        if (!(msg instanceof SccpConnDt2MessageImpl)) {
            this.logger.error("Using protocol class 3, DT1 message discarded " + msg);
            return;
        }
        SccpConnDt2MessageImpl dt2 = (SccpConnDt2MessageImpl)msg;
        boolean correctNumbering = this.flow.checkInputMessageNumbering(this, dt2.getSequencingSegmenting().getSendSequenceNumber(), dt2.getSequencingSegmenting().getReceiveSequenceNumber());
        if (this.flow.isAkSendCriterion(dt2)) {
            this.sendAk();
        }
        if (correctNumbering) {
            super.receiveDataMessage(msg);
        } else {
            this.logger.error(String.format("Message %s was discarded due to incorrect sequence numbers", msg.toString()));
        }
        if (this.flow.isAuthorizedToTransmitAnotherMessage()) {
            this.setState(SccpConnectionState.ESTABLISHED);
        } else {
            this.setState(SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED);
        }
    }

    protected void sendAk() throws Exception {
        this.sendAk(new CreditImpl(this.flow.getMaximumWindowSize()));
    }

    protected void sendAk(Credit credit) throws Exception {
        SccpConnAkMessageImpl msg = new SccpConnAkMessageImpl(0, 0);
        msg.setDestinationLocalReferenceNumber(this.getRemoteReference());
        msg.setSourceLocalReferenceNumber(this.getLocalReference());
        msg.setCredit(credit);
        this.flow.setReceiveCredit(credit.getValue());
        this.flow.initializeMessageNumbering(msg);
        this.sendMessage(msg);
    }

    private void handleAkMessage(SccpConnAkMessageImpl msg) throws Exception {
        this.flow.checkInputMessageNumbering(this, msg.getReceiveSequenceNumber().getNumber());
        this.flow.setSendCredit(msg.getCredit().getValue());
        if (this.flow.isAuthorizedToTransmitAnotherMessage()) {
            this.setState(SccpConnectionState.ESTABLISHED);
        } else {
            this.setState(SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED);
        }
    }

    @Override
    public void reset(ResetCause reason) throws Exception {
        super.reset(reason);
        this.flow.reinitialize();
    }

    @Override
    protected void setConnectionLock(ReentrantLock lock) {
        if (this.getState() != SccpConnectionState.NEW) {
            throw new IllegalStateException();
        }
        super.setConnectionLock(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isCanSendData() {
        try {
            this.connectionLock.lock();
            SccpConnectionState oldState = this.getState();
            if (oldState == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED && this.flow.isAuthorizedToTransmitAnotherMessage()) {
                this.setState(SccpConnectionState.ESTABLISHED);
            }
            boolean bl = this.getState() == SccpConnectionState.ESTABLISHED;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    @Override
    public Credit getSendCredit() {
        return new CreditImpl(this.flow.getSendCredit());
    }

    @Override
    public Credit getReceiveCredit() {
        return new CreditImpl(this.flow.getReceiveCredit());
    }

    protected boolean isPreemptiveAck() {
        return this.flow.isPreemptiveAk();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionWithFlowControl[");
        this.fillSccpConnectionFields(sb);
        if (this.overloaded) {
            sb.append(", overloaded");
        }
        sb.append("]");
        return sb.toString();
    }
}

