/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.SccpConnectionState;
import org.restcomm.protocols.ss7.sccp.SccpListener;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCrefMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnErrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRlcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRlsdMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRscMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRsrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnCrMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.Credit;
import org.restcomm.protocols.ss7.sccp.parameter.ErrorCause;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.RefusalCause;
import org.restcomm.protocols.ss7.sccp.parameter.ReleaseCause;
import org.restcomm.protocols.ss7.sccp.parameter.ResetCause;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

abstract class SccpConnectionBaseImpl {
    protected final Logger logger;
    protected SccpStackImpl stack;
    protected SccpRoutingControl sccpRoutingControl;
    protected ReentrantLock connectionLock = new ReentrantLock();
    protected Integer remoteSsn;
    protected Integer remoteDpc;
    protected boolean lastMoreDataSent;
    private SccpConnectionState state;
    private int sls;
    private int localSsn;
    private ProtocolClass protocolClass;
    private LocalReference localReference;
    private LocalReference remoteReference;

    public SccpConnectionBaseImpl(int sls, int localSsn, LocalReference localReference, ProtocolClass protocol, SccpStackImpl stack, SccpRoutingControl sccpRoutingControl) {
        this.stack = stack;
        this.sccpRoutingControl = sccpRoutingControl;
        this.sls = sls;
        this.localSsn = localSsn;
        this.protocolClass = protocol;
        this.localReference = localReference;
        this.state = SccpConnectionState.NEW;
        this.logger = Logger.getLogger(SccpConnectionBaseImpl.class.getCanonicalName() + "-" + localReference + "-" + stack.name);
    }

    protected void receiveMessage(SccpConnMessage message) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Rx : SCCP message %s", message.toString()));
        }
        if (message instanceof SccpConnCrMessageImpl) {
            SccpConnCrMessageImpl cr = (SccpConnCrMessageImpl)message;
            this.remoteReference = cr.getSourceLocalReferenceNumber();
            this.remoteDpc = cr.getCallingPartyAddress() != null && cr.getCallingPartyAddress().getSignalingPointCode() != 0 ? Integer.valueOf(cr.getCallingPartyAddress().getSignalingPointCode()) : (cr.getIncomingOpc() != -1 ? Integer.valueOf(cr.getIncomingOpc()) : Integer.valueOf(cr.getCalledPartyAddress().getSignalingPointCode()));
            this.setState(SccpConnectionState.CR_RECEIVED);
        } else if (message instanceof SccpConnCcMessageImpl) {
            SccpConnCcMessageImpl cc = (SccpConnCcMessageImpl)message;
            this.remoteReference = cc.getSourceLocalReferenceNumber();
            if (cc.getIncomingDpc() != -1) {
                this.remoteDpc = cc.getIncomingOpc();
            }
            this.setState(SccpConnectionState.ESTABLISHED);
        } else if (message instanceof SccpConnRscMessageImpl) {
            this.setState(SccpConnectionState.ESTABLISHED);
        } else if (message instanceof SccpConnRsrMessageImpl) {
            this.confirmReset();
        } else if (message instanceof SccpConnRlsdMessageImpl) {
            this.confirmRelease();
        }
    }

    protected void confirmRelease() throws Exception {
        SccpConnRlcMessageImpl rlc = new SccpConnRlcMessageImpl(this.sls, this.localSsn);
        rlc.setSourceLocalReferenceNumber(this.localReference);
        rlc.setDestinationLocalReferenceNumber(this.remoteReference);
        rlc.setOutgoingDpc(this.remoteDpc);
        this.sendMessage(rlc);
    }

    protected void confirmReset() throws Exception {
        this.setState(SccpConnectionState.RSR_RECEIVED);
        SccpConnRscMessageImpl rsc = new SccpConnRscMessageImpl(this.sls, this.localSsn);
        rsc.setDestinationLocalReferenceNumber(this.remoteReference);
        rsc.setSourceLocalReferenceNumber(this.localReference);
        this.sendMessage(rsc);
        this.setState(SccpConnectionState.ESTABLISHED);
    }

    protected void sendErr(ErrorCause cause) throws Exception {
        SccpConnErrMessageImpl err = new SccpConnErrMessageImpl(this.sls, this.localSsn);
        err.setDestinationLocalReferenceNumber(this.remoteReference);
        err.setSourceLocalReferenceNumber(this.localReference);
        err.setErrorCause(cause);
        this.sendMessage(err);
    }

    protected void sendMessage(SccpConnMessage message) throws Exception {
        if (message instanceof SccpConnSegmentableMessageImpl) {
            this.prepareMessageForSending((SccpConnSegmentableMessageImpl)message);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Tx : SCCP Message=%s", message.toString()));
        }
        try {
            this.sccpRoutingControl.routeMssgFromSccpUserConn(message);
        }
        catch (Exception e) {
            this.logger.error("IOException when sending the message to MTP3 level: " + e.getMessage(), e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(SccpConnectionState state) {
        try {
            this.connectionLock.lock();
            if (!(this.state == SccpConnectionState.NEW && state == SccpConnectionState.CONNECTION_INITIATED || this.state == SccpConnectionState.NEW && state == SccpConnectionState.CR_RECEIVED || this.state == SccpConnectionState.NEW && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.CR_RECEIVED && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.CR_RECEIVED && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.CONNECTION_INITIATED && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.CONNECTION_INITIATED && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.RSR_SENT || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.RSR_RECEIVED || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.RSR_RECEIVED_WILL_PROPAGATE || this.state == SccpConnectionState.ESTABLISHED && state == SccpConnectionState.DISCONNECT_INITIATED || this.state == SccpConnectionState.DISCONNECT_INITIATED && state == SccpConnectionState.DISCONNECT_INITIATED || this.state == SccpConnectionState.DISCONNECT_INITIATED && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED && state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED || this.state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED && state == SccpConnectionState.RSR_RECEIVED || this.state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED && state == SccpConnectionState.DISCONNECT_INITIATED || this.state == SccpConnectionState.RSR_SENT && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.RSR_SENT && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.RSR_RECEIVED && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.RSR_RECEIVED_WILL_PROPAGATE && state == SccpConnectionState.RSR_PROPAGATED_VIA_COUPLED || this.state == SccpConnectionState.RSR_PROPAGATED_VIA_COUPLED && state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.RSR_RECEIVED && state == SccpConnectionState.CLOSED || this.state == SccpConnectionState.CLOSED && state == SccpConnectionState.CLOSED)) {
                this.logger.error(String.format("state change error: from %s to %s", new Object[]{this.state, state}));
                throw new IllegalStateException(String.format("state change error: from %s to %s", new Object[]{this.state, state}));
            }
            this.state = state;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    protected void checkLocalListener() throws IOException {
        if (this.stack.sccpProvider.getSccpListener(this.getLocalSsn()) == null) {
            this.logger.error(String.format("Attempting to establish connection but the SSN %d is not available", this.getLocalSsn()));
            throw new IOException(String.format("Attempting to establish connection but the SSN %d is not available", this.getLocalSsn()));
        }
    }

    public void establish(SccpConnCrMessage message) throws IOException {
        this.checkLocalListener();
        try {
            message.setSourceLocalReferenceNumber(this.getLocalReference());
            if (message.getCalledPartyAddress() == null) {
                this.logger.error("Message to send must have filled CalledPartyAddress field");
                throw new IOException("Message to send must have filled CalledPartyAddress field");
            }
            this.setState(SccpConnectionState.CONNECTION_INITIATED);
            this.remoteSsn = message.getCalledPartyAddress().getSubsystemNumber();
            if (message.getCalledPartyAddress().getAddressIndicator().isPCPresent()) {
                this.remoteDpc = message.getCalledPartyAddress().getSignalingPointCode();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("Establishing connection to DPC=%d, SSN=%d", this.getRemoteDpc(), this.getRemoteSsn()));
            }
            this.sendMessage(message);
        }
        catch (Exception e) {
            this.logger.error(e);
            throw new IOException(e);
        }
    }

    public void reset(ResetCause reason) throws Exception {
        if (reason.getValue().isError()) {
            this.logger.warn(String.format("Resetting connection to DPC=%d, SSN=%d, DLR=%s due to %s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference(), reason));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Resetting connection to DPC=%d, SSN=%d, DLR=%s due to %s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference(), reason));
        }
        SccpConnRsrMessageImpl rsr = new SccpConnRsrMessageImpl(this.getSls(), this.getLocalSsn());
        rsr.setSourceLocalReferenceNumber(this.getLocalReference());
        rsr.setDestinationLocalReferenceNumber(this.getRemoteReference());
        rsr.setResetCause(reason);
        this.setState(SccpConnectionState.RSR_SENT);
        this.sendMessage(rsr);
    }

    public void resetSection(ResetCause reason) throws Exception {
        this.reset(reason);
    }

    public void disconnect(ReleaseCause reason, byte[] data) throws Exception {
        if (reason.getValue().isError()) {
            this.logger.warn(String.format("Disconnecting connection to DPC=%d, SSN=%d, DLR=%s due to %s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference(), reason));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Disconnecting connection to DPC=%d, SSN=%d, DLR=%s due to %s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference(), reason));
        }
        SccpConnRlsdMessageImpl rlsd = new SccpConnRlsdMessageImpl(this.getSls(), this.getLocalSsn());
        rlsd.setDestinationLocalReferenceNumber(this.getRemoteReference());
        rlsd.setReleaseCause(reason);
        rlsd.setSourceLocalReferenceNumber(this.getLocalReference());
        rlsd.setUserData(data);
        SccpConnectionState prevState = this.state;
        try {
            this.setState(SccpConnectionState.DISCONNECT_INITIATED);
            this.sendMessage(rlsd);
        }
        catch (Exception e) {
            this.state = prevState;
            throw e;
        }
    }

    public void refuse(RefusalCause reason, byte[] data) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Refusing connection from DPC=%d, SSN=%d, DLR=%s due to %s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference(), reason));
        }
        SccpConnCrefMessageImpl cref = new SccpConnCrefMessageImpl(this.getSls(), this.getLocalSsn());
        cref.setDestinationLocalReferenceNumber(this.getRemoteReference());
        cref.setSourceLocalReferenceNumber(this.getLocalReference());
        cref.setRefusalCause(reason);
        cref.setUserData(data);
        this.sendMessage(cref);
        this.stack.removeConnection(this.getLocalReference());
    }

    public void confirm(SccpAddress respondingAddress, Credit credit, byte[] data) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Confirming connection from DPC=%d, SSN=%d, DLR=%s", this.getRemoteDpc(), this.getRemoteSsn(), this.getRemoteReference()));
        }
        if (this.getState() != SccpConnectionState.CR_RECEIVED) {
            this.logger.error(String.format("Trying to confirm connection in non-compatible state %s", new Object[]{this.getState()}));
            throw new IllegalStateException(String.format("Trying to confirm connection in non-compatible state %s", new Object[]{this.getState()}));
        }
        SccpConnCcMessageImpl message = new SccpConnCcMessageImpl(this.getSls(), this.getLocalSsn());
        message.setSourceLocalReferenceNumber(this.getLocalReference());
        message.setDestinationLocalReferenceNumber(this.getRemoteReference());
        message.setProtocolClass(this.getProtocolClass());
        message.setCalledPartyAddress(respondingAddress);
        message.setUserData(data);
        message.setCredit(credit);
        this.sendMessage(message);
        this.setState(SccpConnectionState.ESTABLISHED);
    }

    protected void setConnectionLock(ReentrantLock lock) {
        if (this.getState() != SccpConnectionState.NEW) {
            throw new IllegalStateException();
        }
        this.connectionLock = lock;
    }

    public Integer getRemoteDpc() {
        return this.remoteDpc;
    }

    public Integer getRemoteSsn() {
        return this.remoteSsn;
    }

    public SccpListener getListener() {
        return this.stack.sccpProvider.getSccpListener(this.localSsn);
    }

    public int getSls() {
        return this.sls;
    }

    public int getLocalSsn() {
        return this.localSsn;
    }

    public LocalReference getLocalReference() {
        return this.localReference;
    }

    public LocalReference getRemoteReference() {
        return this.remoteReference;
    }

    public SccpConnectionState getState() {
        return this.state;
    }

    public ProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    public boolean isAvailable() {
        return this.state == SccpConnectionState.ESTABLISHED || this.state == SccpConnectionState.ESTABLISHED_SEND_WINDOW_EXHAUSTED;
    }

    protected boolean isCanSendData() {
        return this.state == SccpConnectionState.ESTABLISHED;
    }

    public Credit getSendCredit() {
        throw new IllegalArgumentException("sendCredit is supported only by flow control connection-oriented protocol class");
    }

    public Credit getReceiveCredit() {
        throw new IllegalArgumentException("receiveCredit is supported only by flow control connection-oriented protocol class");
    }

    protected abstract void prepareMessageForSending(SccpConnSegmentableMessageImpl var1);

    protected abstract void prepareMessageForSending(SccpConnItMessageImpl var1);

    protected abstract void callListenerOnData(byte[] var1);
}

