/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.mtp;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.mtp.Mtp3EndCongestionPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3PausePrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3Primitive;
import org.restcomm.protocols.ss7.mtp.Mtp3ResumePrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3StatusPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3TransferPrimitiveFactory;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPart;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPartListener;
import org.restcomm.protocols.ss7.mtp.RoutingLabelFormat;
import org.restcomm.protocols.ss7.ss7ext.Ss7ExtInterface;
import org.restcomm.protocols.ss7.ss7ext.Ss7ExtInterfaceDefault;
import org.restcomm.ss7.congestion.ExecutorCongestionMonitor;
import org.restcomm.ss7.congestion.ExecutorCongestionMonitorImpl;

public abstract class Mtp3UserPartBaseImpl
implements Mtp3UserPart {
    private static final Logger logger = Logger.getLogger(Mtp3UserPartBaseImpl.class);
    private static final String LICENSE_PRODUCT_NAME = "Restcomm-jSS7";
    protected static final String ROUTING_LABEL_FORMAT = "routingLabelFormat";
    protected static final String USE_LSB_FOR_LINKSET_SELECTION = "useLsbForLinksetSelection";
    private int maxSls = 32;
    private int slsFilter = 31;
    protected int deliveryTransferMessageThreadCount = Runtime.getRuntime().availableProcessors() * 2;
    private RoutingLabelFormat routingLabelFormat = RoutingLabelFormat.ITU;
    private boolean useLsbForLinksetSelection = false;
    protected boolean isStarted = false;
    private CopyOnWriteArrayList<Mtp3UserPartListener> userListeners = new CopyOnWriteArrayList();
    private ExecutorService[] msgDeliveryExecutors;
    private ScheduledExecutorService msgDeliveryExecutorSystem;
    private int[] slsTable = null;
    private ExecutorCongestionMonitorImpl executorCongestionMonitor = null;
    private Mtp3TransferPrimitiveFactory mtp3TransferPrimitiveFactory = null;
    private final String productName;
    private final Ss7ExtInterface ss7ExtInterface;

    public Mtp3UserPartBaseImpl(String productName, Ss7ExtInterface ss7ExtInterface) {
        this.productName = productName == null ? LICENSE_PRODUCT_NAME : productName;
        this.ss7ExtInterface = ss7ExtInterface != null ? ss7ExtInterface : new Ss7ExtInterfaceDefault();
    }

    @Override
    public int getDeliveryMessageThreadCount() {
        return this.deliveryTransferMessageThreadCount;
    }

    @Override
    public void setDeliveryMessageThreadCount(int deliveryMessageThreadCount) throws Exception {
        if (deliveryMessageThreadCount > 0 && deliveryMessageThreadCount <= 100) {
            this.deliveryTransferMessageThreadCount = deliveryMessageThreadCount;
        }
    }

    @Override
    public void addMtp3UserPartListener(Mtp3UserPartListener listener) {
        this.userListeners.add(listener);
    }

    @Override
    public void removeMtp3UserPartListener(Mtp3UserPartListener listener) {
        this.userListeners.remove(listener);
    }

    @Override
    public RoutingLabelFormat getRoutingLabelFormat() {
        return this.routingLabelFormat;
    }

    @Override
    public void setRoutingLabelFormat(RoutingLabelFormat routingLabelFormat) throws Exception {
        if (routingLabelFormat != null) {
            this.routingLabelFormat = routingLabelFormat;
        }
    }

    @Override
    public boolean isUseLsbForLinksetSelection() {
        return this.useLsbForLinksetSelection;
    }

    @Override
    public void setUseLsbForLinksetSelection(boolean useLsbForLinksetSelection) throws Exception {
        this.useLsbForLinksetSelection = useLsbForLinksetSelection;
    }

    @Override
    public int getMaxUserDataLength(int dpc) {
        switch (this.routingLabelFormat) {
            case ITU: {
                return 268;
            }
            case ANSI_Sls8Bit: 
            case ANSI_Sls5Bit: {
                return 265;
            }
        }
        return -1;
    }

    @Override
    public Mtp3TransferPrimitiveFactory getMtp3TransferPrimitiveFactory() {
        return this.mtp3TransferPrimitiveFactory;
    }

    @Override
    public ExecutorCongestionMonitor getExecutorCongestionMonitor() {
        return this.executorCongestionMonitor;
    }

    @Override
    public void start() throws Exception {
        this.ss7ExtInterface.startMtpSs7Ext(this.productName);
        this.startNoLce();
    }

    protected void startNoLce() throws Exception {
        if (this.isStarted) {
            return;
        }
        if (this.routingLabelFormat != RoutingLabelFormat.ITU && this.routingLabelFormat != RoutingLabelFormat.ANSI_Sls8Bit && this.routingLabelFormat != RoutingLabelFormat.ANSI_Sls5Bit) {
            throw new Exception("Invalid PointCodeFormat set. We support only ITU or ANSI now");
        }
        switch (this.routingLabelFormat) {
            case ITU: {
                this.maxSls = 16;
                this.slsFilter = 15;
                break;
            }
            case ANSI_Sls5Bit: {
                this.maxSls = 32;
                this.slsFilter = 31;
                break;
            }
            case ANSI_Sls8Bit: {
                this.maxSls = 256;
                this.slsFilter = 255;
                break;
            }
            default: {
                throw new Exception("Invalid SLS length");
            }
        }
        this.slsTable = new int[this.maxSls];
        this.mtp3TransferPrimitiveFactory = new Mtp3TransferPrimitiveFactory(this.routingLabelFormat);
        this.createSLSTable(this.deliveryTransferMessageThreadCount);
        this.msgDeliveryExecutors = new ExecutorService[this.deliveryTransferMessageThreadCount];
        for (int i = 0; i < this.deliveryTransferMessageThreadCount; ++i) {
            this.msgDeliveryExecutors[i] = Executors.newFixedThreadPool(1, new DefaultThreadFactory("Mtp3-DeliveryExecutor-" + i));
        }
        this.msgDeliveryExecutorSystem = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("Mtp3-DeliveryExecutorSystem"));
        this.executorCongestionMonitor = new ExecutorCongestionMonitorImpl(this.productName, this.msgDeliveryExecutors);
        this.isStarted = true;
        this.startThreadMonitoring();
    }

    @Override
    public void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        for (ExecutorService es : this.msgDeliveryExecutors) {
            es.shutdown();
        }
        this.msgDeliveryExecutorSystem.shutdown();
        this.executorCongestionMonitor = null;
    }

    private void startThreadMonitoring() {
        ExecutorCongestionMonitorImpl monitor = this.executorCongestionMonitor;
        if (this.isStarted && monitor != null) {
            monitor.monitor();
            ExecutorCongestionMonitorHandler handler = new ExecutorCongestionMonitorHandler();
            this.msgDeliveryExecutorSystem.schedule(handler, 500L, TimeUnit.MILLISECONDS);
        }
    }

    protected void sendTransferMessageToLocalUser(Mtp3TransferPrimitive msg, int seqControl) {
        if (this.isStarted) {
            MsgTransferDeliveryHandler hdl = new MsgTransferDeliveryHandler(msg);
            this.msgDeliveryExecutors[this.slsTable[seqControl &= this.slsFilter]].execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3TransferPrimitive=%s but Mtp3UserPart is not started. Message will be dropped", msg));
        }
    }

    protected void sendPauseMessageToLocalUser(Mtp3PausePrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3PausePrimitive=%s but MTP3 is not started. Message will be dropped", msg));
        }
    }

    protected void sendResumeMessageToLocalUser(Mtp3ResumePrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3ResumePrimitive=%s but MTP3 is not started. Message will be dropped", msg));
        }
    }

    protected void sendStatusMessageToLocalUser(Mtp3StatusPrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3StatusPrimitive=%s but MTP3 is not started. Message will be dropped", msg));
        }
    }

    protected void sendEndCongestionMessageToLocalUser(Mtp3EndCongestionPrimitive msg) {
        if (this.isStarted) {
            MsgSystemDeliveryHandler hdl = new MsgSystemDeliveryHandler(msg);
            this.msgDeliveryExecutorSystem.execute(hdl);
        } else {
            logger.error(String.format("Received Mtp3EndCongestionPrimitive=%s but MTP3 is not started. Message will be dropped", msg));
        }
    }

    private void createSLSTable(int minimumBoundThread) {
        int stream = 0;
        for (int i = 0; i < this.maxSls; ++i) {
            if (stream >= minimumBoundThread) {
                stream = 0;
            }
            this.slsTable[i] = stream++;
        }
    }

    private class ExecutorCongestionMonitorHandler
    implements Runnable {
        private ExecutorCongestionMonitorHandler() {
        }

        @Override
        public void run() {
            Mtp3UserPartBaseImpl.this.startThreadMonitoring();
        }
    }

    private class MsgSystemDeliveryHandler
    implements Runnable {
        Mtp3Primitive msg;

        public MsgSystemDeliveryHandler(Mtp3Primitive msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            if (Mtp3UserPartBaseImpl.this.isStarted) {
                try {
                    for (Mtp3UserPartListener lsn : Mtp3UserPartBaseImpl.this.userListeners) {
                        if (this.msg.getType() == 3) {
                            lsn.onMtp3PauseMessage((Mtp3PausePrimitive)this.msg);
                        }
                        if (this.msg.getType() == 4) {
                            lsn.onMtp3ResumeMessage((Mtp3ResumePrimitive)this.msg);
                        }
                        if (this.msg.getType() == 5) {
                            lsn.onMtp3StatusMessage((Mtp3StatusPrimitive)this.msg);
                        }
                        if (this.msg.getType() != 11) continue;
                        lsn.onMtp3EndCongestionMessage((Mtp3EndCongestionPrimitive)this.msg);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while delivering a payload messages to the MTP3-user: " + e.getMessage(), e);
                }
            } else {
                logger.error(String.format("Received Mtp3Primitive=%s but Mtp3UserPart is not started. Message will be dropped", this.msg));
            }
        }
    }

    private class MsgTransferDeliveryHandler
    implements Runnable {
        private Mtp3TransferPrimitive msg;

        public MsgTransferDeliveryHandler(Mtp3TransferPrimitive msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            if (Mtp3UserPartBaseImpl.this.isStarted) {
                try {
                    for (Mtp3UserPartListener lsn : Mtp3UserPartBaseImpl.this.userListeners) {
                        lsn.onMtp3TransferMessage(this.msg);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while delivering a system messages to the MTP3-user: " + e.getMessage(), e);
                }
            } else {
                logger.error(String.format("Received Mtp3TransferPrimitive=%s but Mtp3UserPart is not started. Message will be dropped", this.msg));
            }
        }
    }
}

