/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.oam;

import org.restcomm.protocols.ss7.map.api.service.oam.BssRecordType;
import org.restcomm.protocols.ss7.map.api.service.oam.HlrRecordType;
import org.restcomm.protocols.ss7.map.api.service.oam.MscRecordType;
import org.restcomm.protocols.ss7.map.api.service.oam.TraceType;
import org.restcomm.protocols.ss7.map.api.service.oam.TraceTypeInvokingEvent;
import org.restcomm.protocols.ss7.map.primitives.OctetStringLength1Base;

public class TraceTypeImpl
extends OctetStringLength1Base
implements TraceType {
    public TraceTypeImpl() {
        super("TraceType");
    }

    public TraceTypeImpl(int data) {
        super("TraceType", data);
    }

    public TraceTypeImpl(BssRecordType bssRecordType, MscRecordType mscRecordType, TraceTypeInvokingEvent traceTypeInvokingEvent, boolean priorityIndication) {
        super("TraceType");
        int mscRecordTypeInt = 3;
        if (mscRecordType != null) {
            mscRecordTypeInt = mscRecordType.getCode();
        }
        int bssRecordTypeInt = 3;
        if (bssRecordType != null) {
            bssRecordTypeInt = bssRecordType.getCode();
        }
        int traceTypeInvokingEventInt = 0;
        if (traceTypeInvokingEvent != null) {
            traceTypeInvokingEventInt = traceTypeInvokingEvent.getCode();
        }
        this.data = bssRecordTypeInt << 4 | mscRecordTypeInt << 2 | traceTypeInvokingEventInt | (priorityIndication ? 128 : 0);
    }

    public TraceTypeImpl(HlrRecordType hlrRecordType, TraceTypeInvokingEvent traceTypeInvokingEvent, boolean priorityIndication) {
        super("TraceType");
        int hlrRecordTypeInt = 3;
        if (hlrRecordType != null) {
            hlrRecordTypeInt = hlrRecordType.getCode();
        }
        int traceTypeInvokingEventInt = 0;
        if (traceTypeInvokingEvent != null) {
            traceTypeInvokingEventInt = traceTypeInvokingEvent.getCode();
        }
        this.data = hlrRecordTypeInt << 2 | traceTypeInvokingEventInt | (priorityIndication ? 128 : 0);
    }

    @Override
    public int getData() {
        return this.data;
    }

    @Override
    public boolean isPriorityIndication() {
        return (this.data & 0x80) != 0;
    }

    @Override
    public BssRecordType getBssRecordType() {
        int code = this.data >> 4 & 3;
        return BssRecordType.getInstance(code);
    }

    @Override
    public MscRecordType getMscRecordType() {
        int code = this.data >> 2 & 3;
        return MscRecordType.getInstance(code);
    }

    @Override
    public HlrRecordType getHlrRecordType() {
        int code = this.data >> 2 & 3;
        return HlrRecordType.getInstance(code);
    }

    @Override
    public TraceTypeInvokingEvent getTraceTypeInvokingEvent() {
        int code = this.data & 3;
        return TraceTypeInvokingEvent.getInstance(code);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("bssRecordType=");
        sb.append((Object)this.getBssRecordType());
        sb.append(", ");
        sb.append("mscRecordType=");
        sb.append((Object)this.getMscRecordType());
        sb.append(", ");
        sb.append("hlrRecordType=");
        sb.append((Object)this.getHlrRecordType());
        sb.append(", ");
        sb.append("traceTypeInvokingEvent=");
        sb.append((Object)this.getTraceTypeInvokingEvent());
        sb.append(", ");
        if (this.isPriorityIndication()) {
            sb.append("priorityIndication, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

