/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.DPAnalysedInfoCriterium;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.DefaultCallHandling;
import org.restcomm.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;

public class DPAnalysedInfoCriteriumImpl
extends SequenceBase
implements DPAnalysedInfoCriterium {
    private ISDNAddressString dialledNumber;
    private long serviceKey;
    private ISDNAddressString gsmSCFAddress;
    private DefaultCallHandling defaultCallHandling;
    private MAPExtensionContainer extensionContainer;

    public DPAnalysedInfoCriteriumImpl() {
        super("DPAnalysedInfoCriterium");
    }

    public DPAnalysedInfoCriteriumImpl(ISDNAddressString dialledNumber, long serviceKey, ISDNAddressString gsmSCFAddress, DefaultCallHandling defaultCallHandling, MAPExtensionContainer extensionContainer) {
        super("DPAnalysedInfoCriterium");
        this.dialledNumber = dialledNumber;
        this.serviceKey = serviceKey;
        this.gsmSCFAddress = gsmSCFAddress;
        this.defaultCallHandling = defaultCallHandling;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public ISDNAddressString getDialledNumber() {
        return this.dialledNumber;
    }

    @Override
    public long getServiceKey() {
        return this.serviceKey;
    }

    @Override
    public ISDNAddressString getGsmSCFAddress() {
        return this.gsmSCFAddress;
    }

    @Override
    public DefaultCallHandling getDefaultCallHandling() {
        return this.defaultCallHandling;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.dialledNumber = null;
        this.serviceKey = -1L;
        this.gsmSCFAddress = null;
        this.defaultCallHandling = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".dialledNumber: Parameter is bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.dialledNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.dialledNumber).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (tag != 2 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".serviceKey :Parameter is bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.serviceKey = ais.readInteger();
                    break;
                }
                case 2: {
                    if (tag != 4 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gsmSCFAddress: Parameter is bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.gsmSCFAddress = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.gsmSCFAddress).decodeAll(ais);
                    break;
                }
                case 3: {
                    if (tag != 2 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".defaultCallHandling: Parameter is bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int i1 = (int)ais.readInteger();
                    this.defaultCallHandling = DefaultCallHandling.getInstance(i1);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.dialledNumber == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament dialledNumber is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.gsmSCFAddress == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament gsmSCFAddress is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.defaultCallHandling == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament defaultCallHandling is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.serviceKey == -1L) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament serviceKey is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.dialledNumber == null) {
                throw new MAPException("Error while encoding" + this._PrimitiveName + ": dialledNumber must not be null");
            }
            if (this.gsmSCFAddress == null) {
                throw new MAPException("Error while encoding" + this._PrimitiveName + ": gsmSCFAddress must not be null");
            }
            if (this.defaultCallHandling == null) {
                throw new MAPException("Error while encoding" + this._PrimitiveName + ": defaultCallHandling must not be null");
            }
            ((ISDNAddressStringImpl)this.dialledNumber).encodeAll(asnOs);
            asnOs.writeInteger(this.serviceKey);
            ((ISDNAddressStringImpl)this.gsmSCFAddress).encodeAll(asnOs);
            asnOs.writeInteger(this.defaultCallHandling.getCode());
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.dialledNumber != null) {
            sb.append("dialledNumber=");
            sb.append(this.dialledNumber.toString());
            sb.append(", ");
        }
        sb.append("serviceKey=");
        sb.append(this.serviceKey);
        sb.append(", ");
        if (this.gsmSCFAddress != null) {
            sb.append("gsmSCFAddress=");
            sb.append(this.gsmSCFAddress.toString());
            sb.append(", ");
        }
        if (this.defaultCallHandling != null) {
            sb.append("defaultCallHandling=");
            sb.append(this.defaultCallHandling.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

