/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.EpcAv;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class EpcAvImpl
implements EpcAv,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "EpcAv";
    private byte[] rand;
    private byte[] xres;
    private byte[] autn;
    private byte[] kasme;
    private MAPExtensionContainer extensionContainer;

    public EpcAvImpl() {
    }

    public EpcAvImpl(byte[] rand, byte[] xres, byte[] autn, byte[] kasme, MAPExtensionContainer extensionContainer) {
        this.rand = rand;
        this.xres = xres;
        this.autn = autn;
        this.kasme = kasme;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public byte[] getRand() {
        return this.rand;
    }

    @Override
    public byte[] getXres() {
        return this.xres;
    }

    @Override
    public byte[] getAutn() {
        return this.autn;
    }

    @Override
    public byte[] getKasme() {
        return this.kasme;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding EpcAv: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding EpcAv: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding EpcAv: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding EpcAv: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.rand = null;
        this.xres = null;
        this.autn = null;
        this.kasme = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding EpcAv.rand: Parameter 0 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.rand = ais.readOctetString();
                    if (this.rand.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding EpcAv.rand: Bad field length: 16 is needed, found: " + this.rand.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding EpcAv.sres: Parameter 1 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.xres = ais.readOctetString();
                    if (this.xres.length >= 4 && this.xres.length <= 16) break;
                    throw new MAPParsingComponentException("Error while decoding EpcAv.xres: Bad field length: from 4 to 16 is needed, found: " + this.xres.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 2: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding EpcAv.autn: Parameter 2 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.autn = ais.readOctetString();
                    if (this.autn.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding EpcAv.autn: Bad field length: 16 is needed, found: " + this.autn.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 3: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding EpcAv.kasme: Parameter 2 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.kasme = ais.readOctetString();
                    if (this.kasme.length == 32) break;
                    throw new MAPParsingComponentException("Error while decoding EpcAv.kasme: Bad field length: 32 is needed, found: " + this.kasme.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding EpcAv.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 4) {
            throw new MAPParsingComponentException("Error while decoding EpcAv: Needs at least 4 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding EpcAv: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.rand == null || this.xres == null || this.autn == null || this.kasme == null) {
            throw new MAPException("rand, xres, autn and kasme fields must not be null");
        }
        if (this.rand.length != 16) {
            throw new MAPException("Wrong rand field length: must be 16, found " + this.rand.length);
        }
        if (this.xres.length < 4 || this.xres.length > 16) {
            throw new MAPException("Wrong xres field length: must be from 4 to 16, found " + this.xres.length);
        }
        if (this.autn.length != 16) {
            throw new MAPException("Wrong autn field length: must be 16, found " + this.autn.length);
        }
        if (this.kasme.length != 32) {
            throw new MAPException("Wrong kasme field length: must be 32, found " + this.kasme.length);
        }
        try {
            asnOs.writeOctetString(this.rand);
            asnOs.writeOctetString(this.xres);
            asnOs.writeOctetString(this.autn);
            asnOs.writeOctetString(this.kasme);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding EpcAv: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding EpcAv: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.rand != null) {
            sb.append("rand=[");
            sb.append(this.printDataArr(this.rand));
            sb.append("], ");
        }
        if (this.xres != null) {
            sb.append("xres=[");
            sb.append(this.printDataArr(this.xres));
            sb.append("], ");
        }
        if (this.autn != null) {
            sb.append("autn=[");
            sb.append(this.printDataArr(this.autn));
            sb.append("]");
        }
        if (this.kasme != null) {
            sb.append("kasme=[");
            sb.append(this.printDataArr(this.kasme));
            sb.append("]");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=[");
            sb.append(this.extensionContainer);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

