/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.api;

import java.io.Serializable;
import java.util.Arrays;
import javolution.util.FastMap;
import org.restcomm.protocols.ss7.map.api.MAPApplicationContextName;
import org.restcomm.protocols.ss7.map.api.MAPApplicationContextVersion;

public class MAPApplicationContext
implements Serializable {
    private static long[] oidTemplate = new long[]{0L, 4L, 0L, 0L, 1L, 0L, 0L, 0L};
    private static FastMap<MAPApplicationContextName, FastMap<MAPApplicationContextVersion, MAPApplicationContext>> appContextCache = new FastMap().shared();
    private MAPApplicationContextName contextName;
    private MAPApplicationContextVersion contextVersion;
    private long[] res = new long[]{0L, 4L, 0L, 0L, 1L, 0L, 0L, 0L};

    private MAPApplicationContext(MAPApplicationContextName contextName, MAPApplicationContextVersion contextVersion) {
        this.contextName = contextName;
        this.contextVersion = contextVersion;
        this.res[6] = this.contextName.getApplicationContextCode();
        this.res[7] = this.contextVersion.getVersion();
    }

    public long[] getOID() {
        return this.res;
    }

    public MAPApplicationContextName getApplicationContextName() {
        return this.contextName;
    }

    public MAPApplicationContextVersion getApplicationContextVersion() {
        return this.contextVersion;
    }

    private static MAPApplicationContext getMAPApplicationContext(MAPApplicationContextName contextName, MAPApplicationContextVersion contextVersion) {
        MAPApplicationContext mapApplicationContext;
        FastMap<MAPApplicationContextVersion, MAPApplicationContext> verCache = appContextCache.get((Object)contextName);
        if (verCache == null) {
            verCache = new FastMap();
            appContextCache.put(contextName, verCache);
        }
        if ((mapApplicationContext = verCache.get((Object)contextVersion)) == null) {
            mapApplicationContext = new MAPApplicationContext(contextName, contextVersion);
            verCache.put(contextVersion, mapApplicationContext);
        }
        return mapApplicationContext;
    }

    public static MAPApplicationContext getInstance(MAPApplicationContextName contextName, MAPApplicationContextVersion contextVersion) {
        if (MAPApplicationContext.availableApplicationContextVersion(contextName, contextVersion.getVersion())) {
            return MAPApplicationContext.getMAPApplicationContext(contextName, contextVersion);
        }
        return null;
    }

    public static MAPApplicationContext getInstance(long[] oid) {
        if (oid == null || oid.length != oidTemplate.length) {
            return null;
        }
        for (int i1 = 0; i1 < oidTemplate.length - 2; ++i1) {
            if (oid[i1] == oidTemplate[i1]) continue;
            return null;
        }
        MAPApplicationContextName contextName = MAPApplicationContextName.getInstance(oid[6]);
        MAPApplicationContextVersion contextVersion = MAPApplicationContextVersion.getInstance(oid[7]);
        if (contextName == null || contextVersion == null) {
            return null;
        }
        if (!MAPApplicationContext.availableApplicationContextVersion(contextName, (int)oid[7])) {
            return null;
        }
        return MAPApplicationContext.getMAPApplicationContext(contextName, contextVersion);
    }

    public static boolean availableApplicationContextVersion(MAPApplicationContextName contextName, int contextVersion) {
        switch (contextName) {
            case networkLocUpContext: 
            case locationCancellationContext: 
            case gprsLocationUpdateContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case interVlrInfoRetrievalContext: 
            case msPurgingContext: {
                return contextVersion >= 2 && contextVersion <= 3;
            }
            case mmEventReportingContext: {
                return contextVersion == 3;
            }
            case handoverControlContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case infoRetrievalContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case authenticationFailureReportContext: {
                return contextVersion == 3;
            }
            case equipmentMngtContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case subscriberDataMngtContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case resetContext: {
                return contextVersion >= 1 && contextVersion <= 2;
            }
            case anyTimeEnquiryContext: 
            case subscriberInfoEnquiryContext: 
            case anyTimeInfoHandlingContext: 
            case subscriberDataModificationNotificationContext: {
                return contextVersion == 3;
            }
            case tracingContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case imsiRetrievalContext: {
                return contextVersion == 2;
            }
            case locationInfoRetrievalContext: 
            case roamingNumberEnquiryContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case callControlTransferContext: {
                return contextVersion >= 3 && contextVersion <= 4;
            }
            case groupCallControlContext: 
            case groupCallInfoRetrievalContext: 
            case reportingContext: 
            case istAlertingContext: 
            case ServiceTerminationContext: 
            case resourceManagementContext: {
                return contextVersion == 3;
            }
            case networkFunctionalSsContext: {
                return contextVersion >= 1 && contextVersion <= 2;
            }
            case networkUnstructuredSsContext: {
                return contextVersion == 2;
            }
            case ssInvocationNotificationContext: 
            case callCompletionContext: {
                return contextVersion == 3;
            }
            case shortMsgGatewayContext: 
            case shortMsgMORelayContext: 
            case shortMsgMTRelayContext: 
            case mwdMngtContext: {
                return contextVersion >= 1 && contextVersion <= 3;
            }
            case shortMsgMTVgcsRelayContext: {
                return contextVersion == 3;
            }
            case shortMsgAlertContext: {
                return contextVersion >= 1 && contextVersion <= 2;
            }
            case gprsLocationInfoRetrievalContext: {
                return contextVersion >= 3 && contextVersion <= 4;
            }
            case failureReportContext: 
            case gprsNotifyContext: {
                return contextVersion == 3;
            }
            case locationSvcEnquiryContext: 
            case locationSvcGatewayContext: {
                return contextVersion == 3;
            }
        }
        return false;
    }

    public static int getProtocolVersion(long[] oid) {
        if (oid == null || oid.length != 8) {
            return 0;
        }
        return (int)oid[7];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextName == null ? 0 : this.contextName.hashCode());
        result = 31 * result + (this.contextVersion == null ? 0 : this.contextVersion.hashCode());
        result = 31 * result + Arrays.hashCode(this.res);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MAPApplicationContext other = (MAPApplicationContext)obj;
        if (this.contextName != other.contextName) {
            return false;
        }
        if (this.contextVersion != other.contextVersion) {
            return false;
        }
        return Arrays.equals(this.res, other.res);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("MAPApplicationContext [Name=");
        s.append(this.contextName.toString());
        s.append(", Version=");
        s.append(this.contextVersion.toString());
        s.append(", Oid=");
        for (long l : this.getOID()) {
            s.append(l).append(", ");
        }
        s.append("]");
        return s.toString();
    }
}

