/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.hardware.dahdi.oam;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp3;
import org.mobicents.protocols.ss7.mtp.Mtp3Listener;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.SelectorProvider;
import org.mobicents.protocols.stream.api.StreamSelector;
import org.mobicents.ss7.hardware.dahdi.oam.DahdiLink;
import org.mobicents.ss7.linkset.oam.FormatterHelp;
import org.mobicents.ss7.linkset.oam.Link;
import org.mobicents.ss7.linkset.oam.Linkset;
import org.mobicents.ss7.linkset.oam.LinksetSelector;
import org.mobicents.ss7.linkset.oam.LinksetStream;

public class DahdiLinkset
extends Linkset
implements Mtp3Listener {
    private static final Logger logger = Logger.getLogger(DahdiLinkset.class);
    private Mtp3 mtp3 = null;
    private ConcurrentLinkedQueue<byte[]> queue = new ConcurrentLinkedQueue();
    protected static final XMLFormat<DahdiLinkset> DAHDI_LINKSET_XML = new XMLFormat<DahdiLinkset>(DahdiLinkset.class){

        @Override
        public void read(XMLFormat.InputElement xml, DahdiLinkset linkSet) throws XMLStreamException {
            LINKSET_XML.read(xml, linkSet);
            try {
                linkSet.configure();
            }
            catch (Exception e) {
                logger.error("Error while initializing dahdi linkset", e);
            }
        }

        @Override
        public void write(DahdiLinkset linkSet, XMLFormat.OutputElement xml) throws XMLStreamException {
            LINKSET_XML.write(linkSet, xml);
        }
    };

    public DahdiLinkset() {
    }

    public DahdiLinkset(String linksetName, int opc, int dpc, int ni) {
        super(linksetName, opc, dpc, ni);
    }

    protected void initialize() {
        this.linksetStream = new LinksetStreamImpl();
    }

    protected void configure() throws Exception {
        if (this.mode == 2) {
            if (this.mtp3 == null) {
                this.mtp3 = new Mtp3(this.linksetName, this.scheduler);
            }
            this.mtp3.clearLinks();
            try {
                this.mtp3.addMtp3Listener(this);
            }
            catch (Exception e) {
                // empty catch block
            }
            FastCollection.Record e = this.links.head();
            FastMap.Entry end = this.links.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Link value = (Link)((FastMap.Entry)e).getValue();
                if (value.getMode() != 2) continue;
                this.mtp3.addLink(((DahdiLink)value).getMtp2());
            }
            this.mtp3.setDpc(this.apc);
            this.mtp3.setOpc(this.opc);
            this.mtp3.setNetworkIndicator(this.ni);
            if (this.state != 2) {
                this.mtp3.start();
            }
        }
    }

    public void setScheduler(Scheduler scheduler) {
        Link link;
        this.scheduler = scheduler;
        if (this.mtp3 != null) {
            this.mtp3.setScheduler(scheduler);
        }
        FastCollection.Record e = this.links.head();
        FastMap.Entry end = this.links.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            link = (Link)((FastMap.Entry)e).getValue();
            link.setScheduler(scheduler);
        }
        e = this.loadedLinks.head();
        end = this.loadedLinks.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            link = (Link)((FastMap.Entry)e).getValue();
            link.setScheduler(scheduler);
        }
    }

    public void createLink(String[] options) throws Exception {
        if (options.length != 11) {
            throw new Exception("Invalid Command");
        }
        String option = options[3];
        if (option == null || option.compareTo("span") != 0) {
            throw new Exception("Invalid Command");
        }
        int span = Integer.parseInt(options[4]);
        option = options[5];
        if (option == null || option.compareTo("code") != 0) {
            throw new Exception("Invalid Command");
        }
        int code = Integer.parseInt(options[6]);
        option = options[7];
        if (option == null || option.compareTo("channel") != 0) {
            throw new Exception("Invalid Command");
        }
        int channel = Integer.parseInt(options[8]);
        option = options[10];
        if (option == null) {
            throw new Exception("Invalid Command");
        }
        if (this.links.containsKey(option)) {
            throw new Exception("Link already exist");
        }
        DahdiLink link = new DahdiLink(option, span, channel, code);
        link.setScheduler(this.scheduler);
        link.setLinkSet(this);
        this.links.put(option, link);
    }

    public void deleteLink(String linkName) throws Exception {
        Link link = (Link)this.links.get(linkName);
        if (link == null) {
            throw new Exception("Link doesn't exist");
        }
        if (link.getState() == 3) {
            throw new Exception("Link is Active. Can't delete. Please Shutdown first");
        }
        this.links.remove(linkName);
    }

    public void activate() throws Exception {
        if (this.state == 3) {
            throw new Exception("Linkset already active");
        }
        FastCollection.Record e = this.links.head();
        FastMap.Entry end = this.links.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Link value = (Link)((FastMap.Entry)e).getValue();
            if (value.getMode() != 2) continue;
            this.mode = 2;
            this.configure();
            this.state = 1;
            return;
        }
        throw new Exception("No Links for this LinkSet are configured");
    }

    public void deactivate() throws Exception {
        throw new Exception("Not implemented yet");
    }

    public void activateLink(String linkName) throws Exception {
        Link link = (Link)this.links.get(linkName);
        if (link == null) {
            throw new Exception("Link doesn't exist");
        }
        link.activate();
    }

    public void deactivateLink(String linkName) throws Exception {
        Link link = (Link)this.links.get(linkName);
        if (link == null) {
            throw new Exception("Link doesn't exist");
        }
        link.deactivate();
    }

    public void linkDown() {
        this.state = 1;
    }

    public void linkUp() {
        this.queue.clear();
        this.state = 3;
    }

    public void receive(byte[] msgBuff) {
        this.queue.offer(msgBuff);
    }

    public void print(StringBuffer sb, int leftPad, int descPad) {
        FormatterHelp.createPad(sb, leftPad);
        sb.append(this.linksetName);
        if (this.linksetName.length() < 10) {
            FormatterHelp.createPad(sb, 10 - this.linksetName.length());
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append("dahdi");
        FormatterHelp.createPad(sb, descPad);
        sb.append("opc").append("=").append(this.opc);
        int length = Integer.toString(this.opc).length();
        if (length < 8) {
            FormatterHelp.createPad(sb, 8 - length);
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append("apc").append("=").append(this.apc);
        length = Integer.toString(this.apc).length();
        if (length < 8) {
            FormatterHelp.createPad(sb, 8 - length);
        }
        FormatterHelp.createPad(sb, descPad);
        sb.append("ni").append("=").append(this.ni);
        FormatterHelp.createPad(sb, descPad);
        sb.append("state").append("=").append(FormatterHelp.getLinksetState(this.state));
        sb.append("\n");
        FastCollection.Record e = this.links.head();
        FastMap.Entry end = this.links.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Link link = (Link)((FastMap.Entry)e).getValue();
            link.print(sb, 4, 2);
            sb.append("\n");
        }
    }

    private class LinksetStreamImpl
    extends LinksetStream {
        private LinksetStreamImpl() {
        }

        public boolean poll(int arg0, int arg1) {
            if (DahdiLinkset.this.mtp3 != null) {
                DahdiLinkset.this.mtp3.run();
                return true;
            }
            return false;
        }

        public String getName() {
            return DahdiLinkset.this.linksetName;
        }

        public void close() {
        }

        public SelectorProvider provider() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int read(byte[] paramArrayOfByte) throws IOException {
            if (DahdiLinkset.this.queue.isEmpty()) {
                return 0;
            }
            byte[] data = (byte[])DahdiLinkset.this.queue.poll();
            if (data != null) {
                System.arraycopy(data, 0, paramArrayOfByte, 0, data.length);
            }
            return paramArrayOfByte == null ? 0 : data.length;
        }

        public SelectorKey register(StreamSelector selector) throws IOException {
            return ((LinksetSelector)selector).register(this);
        }

        public int write(byte[] paramArrayOfByte) throws IOException {
            DahdiLinkset.this.mtp3.send(paramArrayOfByte, paramArrayOfByte.length);
            return paramArrayOfByte.length;
        }

        public int read(ByteBuffer arg0) throws IOException {
            return 0;
        }

        public int write(ByteBuffer arg0) throws IOException {
            return 0;
        }
    }
}

