/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.oam.common.sccp;

import java.util.Map;
import org.mobicents.protocols.ss7.indicator.AddressIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.oam.common.sccp.SccpRouterJmxMBean;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.LongMessageRule;
import org.mobicents.protocols.ss7.sccp.LongMessageRuleType;
import org.mobicents.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.Router;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SccpRouterJmx
implements SccpRouterJmxMBean {
    private final Router wrappedRouter;
    private final ParameterFactory parameterFactory;

    public SccpRouterJmx(Router wrappedRouter, SccpProvider sccpProvider) {
        this.wrappedRouter = wrappedRouter;
        this.parameterFactory = sccpProvider.getParameterFactory();
    }

    @Override
    public void addLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        this.wrappedRouter.addLongMessageRule(id, firstSpc, lastSpc, ruleType);
    }

    @Override
    public void addMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        this.wrappedRouter.addMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
    }

    @Override
    public void addMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni, int networkId) throws Exception {
        this.wrappedRouter.addMtp3ServiceAccessPoint(id, mtp3Id, opc, ni, networkId);
    }

    @Override
    public void addRoutingAddress(int id, SccpAddress routingAddress) throws Exception {
        this.wrappedRouter.addRoutingAddress(id, routingAddress);
    }

    @Override
    public void addRule(int id, RuleType ruleType, LoadSharingAlgorithm algo, OriginationType originationType, SccpAddress pattern, String mask, int pAddressId, int sAddressId, Integer newCallingPartyAddressAddressId, int networkId) throws Exception {
        this.wrappedRouter.addRule(id, ruleType, algo, originationType, pattern, mask, pAddressId, sAddressId, newCallingPartyAddressAddressId, networkId);
    }

    @Override
    public LongMessageRule getLongMessageRule(int id) {
        return this.wrappedRouter.getLongMessageRule(id);
    }

    @Override
    public Map<Integer, LongMessageRule> getLongMessageRules() {
        return this.wrappedRouter.getLongMessageRules();
    }

    @Override
    public Mtp3ServiceAccessPoint getMtp3ServiceAccessPoint(int id) {
        return this.wrappedRouter.getMtp3ServiceAccessPoint(id);
    }

    @Override
    public Map<Integer, Mtp3ServiceAccessPoint> getMtp3ServiceAccessPoints() {
        return this.wrappedRouter.getMtp3ServiceAccessPoints();
    }

    @Override
    public SccpAddress getRoutingAddress(int id) {
        return this.wrappedRouter.getRoutingAddress(id);
    }

    @Override
    public Map<Integer, SccpAddress> getRoutingAddresses() {
        return this.wrappedRouter.getRoutingAddresses();
    }

    @Override
    public Rule getRule(int id) {
        return this.wrappedRouter.getRule(id);
    }

    @Override
    public Map<Integer, Rule> getRules() {
        return this.wrappedRouter.getRules();
    }

    @Override
    public void modifyLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        this.wrappedRouter.modifyLongMessageRule(id, firstSpc, lastSpc, ruleType);
    }

    @Override
    public void modifyMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        this.wrappedRouter.modifyMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
    }

    @Override
    public void modifyMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni, int networkId) throws Exception {
        this.wrappedRouter.modifyMtp3ServiceAccessPoint(id, mtp3Id, opc, ni, networkId);
    }

    @Override
    public void modifyRoutingAddress(int routingAddressId, SccpAddress routingAddress) throws Exception {
        this.wrappedRouter.modifyRoutingAddress(routingAddressId, routingAddress);
    }

    @Override
    public void modifyRule(int id, RuleType ruleType, LoadSharingAlgorithm algo, OriginationType originationType, SccpAddress pattern, String mask, int pAddressId, int sAddressId, Integer newCallingPartyAddressAddressId, int networkId) throws Exception {
        this.wrappedRouter.modifyRule(id, ruleType, algo, originationType, pattern, mask, pAddressId, sAddressId, newCallingPartyAddressAddressId, networkId);
    }

    @Override
    public void removeLongMessageRule(int id) throws Exception {
        this.wrappedRouter.removeLongMessageRule(id);
    }

    @Override
    public void removeMtp3Destination(int sapId, int destId) throws Exception {
        this.wrappedRouter.removeMtp3Destination(sapId, destId);
    }

    @Override
    public void removeMtp3ServiceAccessPoint(int id) throws Exception {
        this.wrappedRouter.removeMtp3ServiceAccessPoint(id);
    }

    @Override
    public void removeRoutingAddress(int id) throws Exception {
        this.wrappedRouter.removeRoutingAddress(id);
    }

    @Override
    public void removeRule(int id) throws Exception {
        this.wrappedRouter.removeRule(id);
    }

    @Override
    public void addRoutingAddress(int id, int ai, int pc, int ssn, int tt, int np, int nao, String digits) throws Exception {
        SccpAddress sccpAddress = this.createSccpAddress(ai, pc, ssn, tt, np, nao, digits);
        this.wrappedRouter.addRoutingAddress(id, sccpAddress);
    }

    private SccpAddress createSccpAddress(int ai, int pc, int ssn, int tt, int np, int nao, String digits) throws Exception {
        AddressIndicator aiObj = new AddressIndicator((byte)ai, SccpProtocolVersion.ITU);
        if (aiObj.isSSNPresent() && ssn == 0) {
            throw new Exception(String.format("Address Indicator %d indicates that SSN is present, however SSN passed is 0", ai));
        }
        if (aiObj.isPCPresent() && pc == 0) {
            throw new Exception(String.format("Address Indicator %d indicates that PointCode is present, however PointCode passed is 0", ai));
        }
        NumberingPlan npObj = NumberingPlan.valueOf(np);
        NatureOfAddress naiObj = NatureOfAddress.valueOf(nao);
        GlobalTitle gt = null;
        switch (aiObj.getGlobalTitleIndicator()) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                gt = this.parameterFactory.createGlobalTitle(digits, naiObj);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                gt = this.parameterFactory.createGlobalTitle(digits, tt);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                gt = this.parameterFactory.createGlobalTitle(digits, tt, npObj, null);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                gt = this.parameterFactory.createGlobalTitle(digits, tt, npObj, null, naiObj);
                break;
            }
            case NO_GLOBAL_TITLE_INCLUDED: {
                gt = this.parameterFactory.createGlobalTitle(digits);
            }
        }
        SccpAddress sccpAddress = this.parameterFactory.createSccpAddress(aiObj.getRoutingIndicator(), gt, pc, ssn);
        return sccpAddress;
    }

    @Override
    public void addRule(int id, String ruleType, String algo, String originationType, int ai, int pc, int ssn, int tt, int np, int nao, String digits, String mask, int pAddressId, int sAddressId, int newCallingPartyAddressAddressId, int networkId) throws Exception {
        SccpAddress patternAddress = this.createSccpAddress(ai, pc, ssn, tt, np, nao, digits);
        this.wrappedRouter.addRule(id, RuleType.getInstance(ruleType), LoadSharingAlgorithm.getInstance(algo), OriginationType.getInstance(originationType), patternAddress, mask, pAddressId, sAddressId, newCallingPartyAddressAddressId == -1 ? null : Integer.valueOf(newCallingPartyAddressAddressId), networkId);
    }
}

