/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.callhandling;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.callhandling.CamelRoutingInfo;
import org.mobicents.protocols.ss7.map.api.service.callhandling.ExtendedRoutingInfo;
import org.mobicents.protocols.ss7.map.api.service.callhandling.RoutingInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.callhandling.CamelRoutingInfoImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.RoutingInfoImpl;

public class ExtendedRoutingInfoImpl
implements ExtendedRoutingInfo,
MAPAsnPrimitive {
    private RoutingInfo routingInfo = null;
    private CamelRoutingInfo camelRoutingInfo = null;
    public static final int TAG_camel = 8;
    private static final String _PrimitiveName = "ExtendedRoutingInfo";

    public ExtendedRoutingInfoImpl() {
    }

    public ExtendedRoutingInfoImpl(RoutingInfo routingInfo) {
        this.routingInfo = routingInfo;
    }

    public ExtendedRoutingInfoImpl(CamelRoutingInfo camelRoutingInfo) {
        this.camelRoutingInfo = camelRoutingInfo;
    }

    public RoutingInfo getRoutingInfo() {
        return this.routingInfo;
    }

    public CamelRoutingInfo getCamelRoutingInfo() {
        return this.camelRoutingInfo;
    }

    public int getTag() throws MAPException {
        if (this.routingInfo != null) {
            return ((RoutingInfoImpl)this.routingInfo).getTag();
        }
        return 8;
    }

    public int getTagClass() {
        if (this.routingInfo != null) {
            return ((RoutingInfoImpl)this.routingInfo).getTagClass();
        }
        return 2;
    }

    public boolean getIsPrimitive() {
        if (this.routingInfo != null) {
            return ((RoutingInfoImpl)this.routingInfo).getIsPrimitive();
        }
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ExtendedRoutingInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ExtendedRoutingInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ExtendedRoutingInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ExtendedRoutingInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        block7: {
            block8: {
                int tag;
                block6: {
                    this.routingInfo = null;
                    this.camelRoutingInfo = null;
                    tag = ais.getTag();
                    if (ais.getTagClass() != 0) break block6;
                    switch (tag) {
                        case 4: 
                        case 16: {
                            this.routingInfo = new RoutingInfoImpl();
                            ((RoutingInfoImpl)this.routingInfo).decodeData(ais, length);
                            break block7;
                        }
                        default: {
                            throw new MAPParsingComponentException("Error while decoding ExtendedRoutingInfo: bad choice tagNumber", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                    }
                }
                if (ais.getTagClass() != 2) break block8;
                switch (tag) {
                    case 8: {
                        this.camelRoutingInfo = new CamelRoutingInfoImpl();
                        ((CamelRoutingInfoImpl)this.camelRoutingInfo).decodeData(ais, length);
                        break block7;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding ExtendedRoutingInfo: bad choice tagNumber", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new MAPParsingComponentException("Error while decoding ExtendedRoutingInfo: bad choice tagClass", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ExtendedRoutingInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.routingInfo == null && this.camelRoutingInfo == null) {
            throw new MAPException("Both routingInfo and camelRoutingInfo must not be null");
        }
        if (this.routingInfo != null && this.camelRoutingInfo != null) {
            throw new MAPException("Both routingInfo and camelRoutingInfo must not be not null");
        }
        if (this.routingInfo != null) {
            ((RoutingInfoImpl)this.routingInfo).encodeData(asnOs);
        } else {
            ((CamelRoutingInfoImpl)this.camelRoutingInfo).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.routingInfo != null) {
            sb.append(this.routingInfo.toString());
        } else if (this.camelRoutingInfo != null) {
            sb.append(this.camelRoutingInfo.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

