/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.datacoding;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import org.mobicents.protocols.ss7.map.api.datacoding.NationalLanguageIdentifier;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncoder;

public class GSMCharset
extends Charset {
    public static final String GSM_CANONICAL_NAME = "GSM";
    protected static final float averageCharsPerByte = 1.1428572f;
    protected static final float maxCharsPerByte = 2.0f;
    protected static final float averageBytesPerChar = 2.0f;
    protected static final float maxBytesPerChar = 2.0f;
    protected static final int BUFFER_SIZE = 256;
    public static final byte ESCAPE = 27;
    protected int[] mainTable;
    protected int[] extensionTable;
    public static final int[] BYTE_TO_CHAR_DefaultAlphabet = new int[]{64, 163, 36, 165, 232, 233, 249, 236, 242, 231, 10, 216, 248, 13, 197, 229, 916, 95, 934, 915, 923, 937, 928, 936, 931, 920, 926, 160, 198, 230, 223, 201, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 161, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 196, 214, 209, 220, 167, 191, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 228, 246, 241, 252, 224};
    public static final int[] BYTE_TO_CHAR_DefaultAlphabetExtentionTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 13, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 125, 0, 0, 0, 0, 0, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 126, 93, 0, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8364, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] BYTE_TO_CHAR_UrduAlphabet = new int[]{1575, 1570, 1576, 1659, 1664, 1662, 1702, 1578, 1730, 1663, 10, 1657, 1661, 13, 1658, 1660, 1579, 1580, 1665, 1668, 1667, 1669, 1670, 1671, 1581, 1582, 1583, 160, 1676, 1672, 1673, 1674, 32, 33, 1679, 1677, 1584, 1585, 1681, 1683, 40, 41, 1689, 1586, 44, 1686, 46, 1688, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 1690, 1587, 1588, 63, 1589, 1590, 1591, 1592, 1593, 1601, 1602, 1705, 1706, 1707, 1711, 1715, 1713, 1604, 1605, 1606, 1722, 1723, 1724, 1608, 1732, 1749, 1729, 1726, 1569, 1740, 1744, 1746, 1613, 1616, 1615, 1623, 1623, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 1621, 1617, 1619, 1622, 1648};
    public static final int[] BYTE_TO_CHAR_UrduAlphabetExtentionTable = new int[]{64, 163, 36, 165, 191, 34, 164, 37, 38, 39, 12, 42, 43, 13, 45, 47, 60, 61, 62, 161, 94, 161, 95, 35, 42, 1536, 1537, 0, 1776, 1777, 1778, 1779, 1780, 1781, 1782, 1783, 1784, 1785, 1548, 1549, 123, 125, 1550, 1551, 1552, 1553, 1554, 92, 1555, 1556, 1563, 1567, 1600, 1618, 1624, 1643, 1644, 1650, 1651, 1741, 91, 126, 93, 1748, 124, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8364, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public GSMCharset(String canonicalName, String[] aliases) {
        this(canonicalName, aliases, BYTE_TO_CHAR_DefaultAlphabet, BYTE_TO_CHAR_DefaultAlphabetExtentionTable);
    }

    public GSMCharset(String canonicalName, String[] aliases, int[] mainTable, int[] extentionTable) {
        super(canonicalName, aliases);
        this.mainTable = mainTable;
        this.extensionTable = extentionTable;
    }

    public GSMCharset(String canonicalName, String[] aliases, NationalLanguageIdentifier nationalLanguageLockingShiftIdentifier, NationalLanguageIdentifier nationalLanguageSingleShiftIdentifier) {
        super(canonicalName, aliases);
        if (nationalLanguageLockingShiftIdentifier == null) {
            this.mainTable = BYTE_TO_CHAR_DefaultAlphabet;
        } else {
            switch (nationalLanguageLockingShiftIdentifier) {
                case Urdu: {
                    this.mainTable = BYTE_TO_CHAR_UrduAlphabet;
                    break;
                }
                default: {
                    this.mainTable = BYTE_TO_CHAR_DefaultAlphabet;
                }
            }
        }
        if (nationalLanguageSingleShiftIdentifier == null) {
            this.extensionTable = BYTE_TO_CHAR_DefaultAlphabetExtentionTable;
        } else {
            switch (nationalLanguageSingleShiftIdentifier) {
                case Urdu: {
                    this.extensionTable = BYTE_TO_CHAR_UrduAlphabetExtentionTable;
                    break;
                }
                default: {
                    this.extensionTable = BYTE_TO_CHAR_DefaultAlphabetExtentionTable;
                }
            }
        }
    }

    public boolean contains(Charset cs) {
        return this.getClass().isInstance(cs);
    }

    public CharsetDecoder newDecoder() {
        return new GSMCharsetDecoder(this, 1.1428572f, 2.0f);
    }

    public CharsetEncoder newEncoder() {
        return new GSMCharsetEncoder(this, 2.0f, 2.0f);
    }

    public boolean checkAllCharsCanBeEncoded(String data) {
        return GSMCharset.checkAllCharsCanBeEncoded(data, this.mainTable, this.extensionTable);
    }

    public static boolean checkAllCharsCanBeEncoded(String data, int[] mainTable, int[] extentionTable) {
        if (data == null) {
            return true;
        }
        if (mainTable == null) {
            return false;
        }
        for (int i1 = 0; i1 < data.length(); ++i1) {
            int i;
            char c = data.charAt(i1);
            boolean found = false;
            for (i = 0; i < mainTable.length; ++i) {
                if (mainTable[i] != c) continue;
                found = true;
                break;
            }
            if (!found && extentionTable != null) {
                for (i = 0; i < extentionTable.length; ++i) {
                    if (extentionTable[i] != c) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int checkEncodedDataLengthInChars(String data) {
        return GSMCharset.checkEncodedDataLengthInChars(data, this.mainTable, this.extensionTable);
    }

    public static int checkEncodedDataLengthInChars(String data, int[] mainTable, int[] extentionTable) {
        if (data == null) {
            return 0;
        }
        if (mainTable == null) {
            return 0;
        }
        int cnt = 0;
        for (int i1 = 0; i1 < data.length(); ++i1) {
            int i;
            char c = data.charAt(i1);
            boolean found = false;
            for (i = 0; i < mainTable.length; ++i) {
                if (mainTable[i] != c) continue;
                found = true;
                ++cnt;
                break;
            }
            if (!found && extentionTable != null) {
                for (i = 0; i < extentionTable.length; ++i) {
                    if (extentionTable[i] != c) continue;
                    found = true;
                    cnt += 2;
                    break;
                }
            }
            if (found) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int septetsToOctets(int septCnt) {
        int byteCnt = (septCnt + 1) * 7 / 8;
        return byteCnt;
    }

    public static int octetsToSeptets(int byteCnt) {
        int septCnt = (byteCnt * 8 - 1) / 7 + 1;
        return septCnt;
    }

    public String[] sliceString(String data, int charCount) {
        return GSMCharset.sliceString(data, charCount, this.mainTable, this.extensionTable);
    }

    public static String[] sliceString(String data, int charCount, int[] mainTable, int[] extentionTable) {
        if (data == null) {
            return null;
        }
        if (mainTable == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int chCnt = 0;
        for (int i1 = 0; i1 < data.length(); ++i1) {
            int i;
            char c = data.charAt(i1);
            boolean found = false;
            for (i = 0; i < mainTable.length; ++i) {
                if (mainTable[i] != c) continue;
                found = true;
                if (++chCnt > charCount) {
                    chCnt = 1;
                    res.add(sb.toString());
                    sb = new StringBuilder();
                }
                sb.append(c);
                break;
            }
            if (!found && extentionTable != null) {
                for (i = 0; i < extentionTable.length; ++i) {
                    if (extentionTable[i] != c) continue;
                    found = true;
                    if ((chCnt += 2) > charCount) {
                        chCnt = 2;
                        res.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    sb.append(c);
                    break;
                }
            }
            if (found) continue;
            if (++chCnt > charCount) {
                chCnt = 1;
                res.add(sb.toString());
                sb = new StringBuilder();
            }
            sb.append(c);
        }
        res.add(sb.toString());
        String[] arr = new String[res.size()];
        res.toArray(arr);
        return arr;
    }
}

