/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPStack;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;
import org.mobicents.ss7.congestion.CongestionListener;

public class MAPStackImpl
implements MAPStack,
CongestionListener {
    protected TCAPStack tcapStack = null;
    protected MAPProviderImpl mapProvider = null;
    private State state = State.IDLE;
    private final String name;

    public MAPStackImpl(String name, SccpProvider sccpPprovider, int ssn) {
        this.name = name;
        this.tcapStack = new TCAPStackImpl(name, sccpPprovider, ssn);
        TCAPProvider tcapProvider = this.tcapStack.getProvider();
        this.mapProvider = new MAPProviderImpl(name, tcapProvider);
        this.state = State.CONFIGURED;
    }

    public MAPStackImpl(String name, TCAPProvider tcapProvider) {
        this.name = name;
        this.mapProvider = new MAPProviderImpl(name, tcapProvider);
        this.state = State.CONFIGURED;
    }

    public String getName() {
        return this.name;
    }

    public MAPProvider getMAPProvider() {
        return this.mapProvider;
    }

    public void start() throws Exception {
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Stack has not been configured or is already running!");
        }
        if (this.tcapStack != null) {
            this.tcapStack.start();
        }
        this.mapProvider.start();
        this.state = State.RUNNING;
    }

    public void stop() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stack is not running!");
        }
        this.mapProvider.stop();
        if (this.tcapStack != null) {
            this.tcapStack.stop();
        }
        this.state = State.CONFIGURED;
    }

    public TCAPStack getTCAPStack() {
        return this.tcapStack;
    }

    public void onCongestionStart(String congName) {
        this.mapProvider.onCongestionStart(congName);
    }

    public void onCongestionFinish(String congName) {
        this.mapProvider.onCongestionFinish(congName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

