/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.TerminatingNetworkRoutingNumber;

public class TerminatingNetworkRoutingNumberImpl
extends AbstractNumber
implements TerminatingNetworkRoutingNumber {
    private int tnrnLengthIndicator;
    private int numberingPlanIndicator;
    private int natureOfAddressIndicator;

    public TerminatingNetworkRoutingNumberImpl() {
    }

    public TerminatingNetworkRoutingNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public TerminatingNetworkRoutingNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public TerminatingNetworkRoutingNumberImpl(int numberingPlanIndicator) {
        this.setNumberingPlanIndicator(numberingPlanIndicator);
        this.tnrnLengthIndicator = 0;
    }

    public TerminatingNetworkRoutingNumberImpl(int numberingPlanIndicator, int natureOfAddressIndicator) {
        this.setNumberingPlanIndicator(numberingPlanIndicator);
        this.setNatureOfAddressIndicator(natureOfAddressIndicator);
        this.tnrnLengthIndicator = 1;
    }

    public TerminatingNetworkRoutingNumberImpl(String address, int numberingPlanIndicator, int natureOfAddressIndicator) {
        this.setNumberingPlanIndicator(numberingPlanIndicator);
        this.setNatureOfAddressIndicator(natureOfAddressIndicator);
        this.setAddress(address);
    }

    public int decode(byte[] b) throws ParameterException {
        return super.decode(b);
    }

    public byte[] encode() throws ParameterException {
        return super.encode();
    }

    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.tnrnLengthIndicator = b & 0xF;
        this.numberingPlanIndicator = b >> 4 & 7;
        return 1;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = 0;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        b |= this.tnrnLengthIndicator & 0xF;
        bos.write(b |= (this.numberingPlanIndicator & 7) << 4);
        return 1;
    }

    public int decodeBody(ByteArrayInputStream bis) throws ParameterException {
        if (this.tnrnLengthIndicator > 0) {
            if (bis.available() == 0) {
                throw new ParameterException("No more data to read.");
            }
            this.setNatureOfAddressIndicator(bis.read());
            return 1;
        }
        return 0;
    }

    public int encodeBody(ByteArrayOutputStream bos) {
        if (this.tnrnLengthIndicator > 0) {
            bos.write(this.natureOfAddressIndicator);
            return 1;
        }
        return 0;
    }

    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (this.tnrnLengthIndicator - 1 > 0) {
            if (bis.available() == 0) {
                throw new ParameterException("No more data to read.");
            }
            return super.decodeDigits(bis, this.tnrnLengthIndicator - 1);
        }
        return 0;
    }

    public int encodeDigits(ByteArrayOutputStream bos) {
        if (this.tnrnLengthIndicator - 1 > 0) {
            return super.encodeDigits(bos);
        }
        return 0;
    }

    public void setAddress(String address) {
        super.setAddress(address);
        int l = this.address.length();
        this.tnrnLengthIndicator = l / 2 + l % 2 + 1;
        if (this.tnrnLengthIndicator > 9) {
            throw new IllegalArgumentException("Maximum octets for this parameter in digits part is 8.");
        }
        if (this.tnrnLengthIndicator == 9 && !this.isOddFlag()) {
            throw new IllegalArgumentException("To many digits. Maximum number of digits is 15 for tnr length of 9.");
        }
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator & 7;
    }

    public int getNatureOfAddressIndicator() {
        return this.natureOfAddressIndicator;
    }

    public void setNatureOfAddressIndicator(int natureOfAddressIndicator) {
        this.natureOfAddressIndicator = natureOfAddressIndicator & 0x7F;
    }

    public int getTnrnLengthIndicator() {
        return this.tnrnLengthIndicator;
    }

    public int getCode() {
        return 0;
    }
}

