/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.ConnectionRequest;

public class ConnectionRequestImpl
extends AbstractISUPParameter
implements ConnectionRequest {
    private int localReference;
    private int signalingPointCode;
    private boolean protocolClassSet = false;
    private int protocolClass;
    private boolean creditSet = false;
    private int credit;

    public ConnectionRequestImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public ConnectionRequestImpl() {
    }

    public ConnectionRequestImpl(int localReference, int signalingPointCode, int protocolClass, int credit) {
        this.localReference = localReference;
        this.signalingPointCode = signalingPointCode;
        this.protocolClass = protocolClass;
        this.credit = credit;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null) {
            throw new ParameterException("byte[] must not be null");
        }
        if (b.length != 5 && b.length != 7) {
            throw new ParameterException("byte[] length must be 5 or 7");
        }
        this.localReference |= b[0];
        this.localReference |= b[1] << 8;
        this.localReference |= b[2] << 16;
        this.signalingPointCode = b[3];
        this.signalingPointCode |= (b[4] & 0x3F) << 8;
        if (b.length == 7) {
            this.creditSet = true;
            this.protocolClassSet = true;
            this.protocolClass = b[5];
            this.credit = b[6];
        }
        return 0;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = null;
        if (this.creditSet || this.protocolClassSet) {
            b = new byte[7];
            b[5] = (byte)this.protocolClass;
            b[6] = (byte)this.credit;
        } else {
            b = new byte[]{(byte)this.localReference, (byte)(this.localReference >> 8), (byte)(this.localReference >> 16), (byte)this.signalingPointCode, (byte)(this.signalingPointCode >> 8 & 0x3F)};
        }
        return b;
    }

    public int getLocalReference() {
        return this.localReference;
    }

    public void setLocalReference(int localReference) {
        this.localReference = localReference;
    }

    public int getSignalingPointCode() {
        return this.signalingPointCode;
    }

    public void setSignalingPointCode(int signalingPointCode) {
        this.signalingPointCode = signalingPointCode;
    }

    public int getProtocolClass() {
        return this.protocolClass;
    }

    public void setProtocolClass(int protocolClass) {
        this.protocolClassSet = true;
        this.protocolClass = protocolClass;
    }

    public int getCredit() {
        return this.credit;
    }

    public void setCredit(int credit) {
        this.creditSet = true;
        this.credit = credit;
    }

    public int getCode() {
        return 13;
    }
}

