/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.InformationRequestMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CallReference;
import org.mobicents.protocols.ss7.isup.message.parameter.InformationRequestIndicators;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageName;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;
import org.mobicents.protocols.ss7.isup.message.parameter.NetworkSpecificFacility;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationRequestMessageImpl
extends ISUPMessageImpl
implements InformationRequestMessage {
    public static final MessageType _MESSAGE_TYPE = new MessageTypeImpl(MessageName.InformationRequest);
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_F_InformationRequestIndicators = 1;
    static final int _INDEX_O_CallReference = 0;
    static final int _INDEX_O_ParameterCompatibilityInformation = 1;
    static final int _INDEX_O_NetworkSpecificFacility = 2;
    static final int _INDEX_O_EndOfOptionalParameters = 3;

    public InformationRequestMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, this.getMessageType());
        this.o_Parameters.put(3, _END_OF_OPTIONAL_PARAMETERS);
    }

    @Override
    public void setInformationRequestIndicators(InformationRequestIndicators inri) {
        this.f_Parameters.put(1, inri);
    }

    @Override
    public InformationRequestIndicators getInformationRequestIndicators() {
        return (InformationRequestIndicators)this.f_Parameters.get(1);
    }

    @Override
    public void setCallReference(CallReference inri) {
        this.o_Parameters.put(0, inri);
    }

    @Override
    public CallReference getCallReference() {
        return (CallReference)this.o_Parameters.get(0);
    }

    @Override
    public void setParameterCompatibilityInformation(ParameterCompatibilityInformation inri) {
        this.o_Parameters.put(1, inri);
    }

    @Override
    public ParameterCompatibilityInformation getParameterCompatibilityInformation() {
        return (ParameterCompatibilityInformation)this.o_Parameters.get(1);
    }

    @Override
    public void setNetworkSpecificFacility(NetworkSpecificFacility inri) {
        this.o_Parameters.put(2, inri);
    }

    @Override
    public NetworkSpecificFacility getNetworkSpecificFacility() {
        return (NetworkSpecificFacility)this.o_Parameters.get(2);
    }

    @Override
    protected int decodeMandatoryParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int localIndex = index;
        if (b.length - (index += super.decodeMandatoryParameters(parameterFactory, b, index)) > 1) {
            try {
                byte[] informationInd = new byte[]{b[index++], b[index++]};
                InformationRequestIndicators bci = parameterFactory.createInformationRequestIndicators();
                ((AbstractISUPParameter)((Object)bci)).decode(informationInd);
                this.setInformationRequestIndicators(bci);
            }
            catch (Exception e) {
                throw new ParameterException("Failed to parse BackwardCallIndicators due to: ", e);
            }
            return index - localIndex;
        }
        throw new IllegalArgumentException("byte[] must have atleast 2 octets");
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 1: {
                CallReference RS = parameterFactory.createCallReference();
                ((AbstractISUPParameter)((Object)RS)).decode(parameterBody);
                this.setCallReference(RS);
                break;
            }
            case 57: {
                ParameterCompatibilityInformation pri = parameterFactory.createParameterCompatibilityInformation();
                ((AbstractISUPParameter)((Object)pri)).decode(parameterBody);
                this.setParameterCompatibilityInformation(pri);
                break;
            }
            case 47: {
                NetworkSpecificFacility nsf = parameterFactory.createNetworkSpecificFacility();
                ((AbstractISUPParameter)((Object)nsf)).decode(parameterBody);
                this.setNetworkSpecificFacility(nsf);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    public MessageType getMessageType() {
        return _MESSAGE_TYPE;
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 0;
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        return this.getInformationRequestIndicators() != null;
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }
}

