/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javolution.util.FastList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.isup.CircuitManager;
import org.mobicents.protocols.ss7.isup.ISUPEvent;
import org.mobicents.protocols.ss7.isup.ISUPListener;
import org.mobicents.protocols.ss7.isup.ISUPMessageFactory;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ISUPProvider;
import org.mobicents.protocols.ss7.isup.ISUPTimeoutEvent;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.Circuit;
import org.mobicents.protocols.ss7.isup.impl.ISUPStackImpl;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageFactoryImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ISUPParameterFactoryImpl;
import org.mobicents.protocols.ss7.isup.message.ISUPMessage;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.scheduler.Scheduler;

public class ISUPProviderImpl
implements ISUPProvider {
    protected static final Logger logger = Logger.getLogger(ISUPProviderImpl.class);
    protected final List<ISUPListener> listeners = new FastList<ISUPListener>();
    protected final transient ISUPStackImpl stack;
    protected final transient ISUPMessageFactory messageFactory;
    protected final transient ISUPParameterFactory parameterFactory;
    protected final transient Scheduler scheduler;
    protected final transient ConcurrentHashMap<Long, Circuit> cic2Circuit = new ConcurrentHashMap();
    protected final int ni;
    protected final int localSpc;
    protected final boolean automaticTimerMessages;
    private long T1Timeout = 15000L;
    private long T5Timeout = 360000L;
    private long T7Timeout = 20000L;
    private long T12Timeout = 15000L;
    private long T13Timeout = 300000L;
    private long T14Timeout = 15000L;
    private long T15Timeout = 300000L;
    private long T16Timeout = 15000L;
    private long T17Timeout = 300000L;
    private long T18Timeout = 15000L;
    private long T19Timeout = 300000L;
    private long T20Timeout = 15000L;
    private long T21Timeout = 300000L;
    private long T22Timeout = 15000L;
    private long T23Timeout = 300000L;
    private long T28Timeout = 10000L;
    private long T33Timeout = 12000L;

    public ISUPProviderImpl(ISUPStackImpl isupStackImpl, Scheduler scheduler, int ni, int localSpc, boolean automaticTimerMessages) {
        this.stack = isupStackImpl;
        this.scheduler = scheduler;
        this.ni = ni;
        this.localSpc = localSpc;
        this.automaticTimerMessages = automaticTimerMessages;
        this.parameterFactory = new ISUPParameterFactoryImpl();
        this.messageFactory = new ISUPMessageFactoryImpl(this.parameterFactory);
    }

    public int getNi() {
        return this.ni;
    }

    public int getLocalSpc() {
        return this.localSpc;
    }

    public boolean isAutomaticTimerMessages() {
        return this.automaticTimerMessages;
    }

    public void addListener(ISUPListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must not be null!");
        }
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("Listener already present: " + listener + " !");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ISUPListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must not be null!");
        }
        this.listeners.remove(listener);
    }

    public ISUPMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public ISUPParameterFactory getParameterFactory() {
        return this.parameterFactory;
    }

    public void sendMessage(ISUPMessage msg, int dpc) throws ParameterException, IOException {
        if (!msg.hasAllMandatoryParameters()) {
            throw new ParameterException("Message does not have all required parameters!");
        }
        this.sendOnCircuit(this.getCircuit(msg, dpc), msg);
    }

    void sendOnCircuit(Circuit c, ISUPMessage msg) throws ParameterException, IOException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        if (msg.getCircuitIdentificationCode() == null || msg.getCircuitIdentificationCode().getCIC() != c.getCic()) {
            throw new IllegalArgumentException();
        }
        c.send(msg);
    }

    public boolean cancelTimer(int cic, int dpc, int timerId) {
        long channelID = this.stack.getCircuitManager().getChannelID(cic, dpc);
        if (this.cic2Circuit.containsKey(channelID)) {
            Circuit c = this.cic2Circuit.get(channelID);
            return c.cancelTimer(timerId);
        }
        return false;
    }

    public void cancelAllTimers(int cic, int dpc) {
        long channelID = this.stack.getCircuitManager().getChannelID(cic, dpc);
        if (this.cic2Circuit.containsKey(channelID)) {
            Circuit c = this.cic2Circuit.get(channelID);
            c.onStop();
        }
    }

    public void start() {
        CircuitManager cm = this.stack.getCircuitManager();
        long[] channelIDs = cm.getChannelIDs();
        this.cic2Circuit.clear();
        for (long channelID : channelIDs) {
            Circuit c = new Circuit(cm.getCIC(channelID), cm.getDPC(channelID), this, this.scheduler);
            this.cic2Circuit.put(channelID, c);
        }
    }

    public void stop() {
        Enumeration<Long> keys = this.cic2Circuit.keys();
        while (keys.hasMoreElements()) {
            try {
                this.cic2Circuit.remove(keys.nextElement()).onStop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void receive(ISUPMessage message, int dpc) {
        Circuit c = this.getCircuit(message, dpc);
        if (c != null) {
            c.receive(message);
        }
    }

    private Circuit getCircuit(ISUPMessage message, int dpc) {
        Circuit c = null;
        int cic = message.getCircuitIdentificationCode().getCIC();
        long channelID = this.stack.getCircuitManager().getChannelID(cic, dpc);
        if (!this.stack.getCircuitManager().isCircuitPresent(cic, dpc)) {
            if (this.cic2Circuit.containsKey(channelID)) {
                this.cic2Circuit.remove(channelID);
            }
            this.stack.getCircuitManager().addCircuit(cic, dpc);
            c = new Circuit(cic, dpc, this, this.scheduler);
            this.cic2Circuit.put(channelID, c);
        } else {
            c = this.cic2Circuit.get(channelID);
        }
        return c;
    }

    void send(Mtp3TransferPrimitive encoded) throws IOException {
        this.stack.send(encoded);
    }

    public void deliver(ISUPEvent event) {
        for (int index = 0; index < this.listeners.size(); ++index) {
            try {
                this.listeners.get(index).onEvent(event);
                continue;
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) continue;
                logger.error("Exception thrown from listener.", e);
            }
        }
    }

    public void deliver(ISUPTimeoutEvent timeoutEvent) {
        for (int index = 0; index < this.listeners.size(); ++index) {
            try {
                this.listeners.get(index).onTimeout(timeoutEvent);
                continue;
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) continue;
                logger.error("Exception thrown from listener.", e);
            }
        }
    }

    long getT1Timeout() {
        return this.T1Timeout;
    }

    long getT5Timeout() {
        return this.T5Timeout;
    }

    long getT7Timeout() {
        return this.T7Timeout;
    }

    long getT12Timeout() {
        return this.T12Timeout;
    }

    long getT13Timeout() {
        return this.T13Timeout;
    }

    long getT14Timeout() {
        return this.T14Timeout;
    }

    long getT15Timeout() {
        return this.T15Timeout;
    }

    long getT16Timeout() {
        return this.T16Timeout;
    }

    long getT17Timeout() {
        return this.T17Timeout;
    }

    long getT18Timeout() {
        return this.T18Timeout;
    }

    long getT19Timeout() {
        return this.T19Timeout;
    }

    long getT20Timeout() {
        return this.T20Timeout;
    }

    long getT21Timeout() {
        return this.T21Timeout;
    }

    long getT22Timeout() {
        return this.T22Timeout;
    }

    long getT23Timeout() {
        return this.T23Timeout;
    }

    long getT28Timeout() {
        return this.T28Timeout;
    }

    long getT33Timeout() {
        return this.T33Timeout;
    }
}

