/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.primitives.CalledPartyBCDNumber;
import org.mobicents.protocols.ss7.cap.primitives.OctetStringBase;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecodingData;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncoder;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.mobicents.protocols.ss7.map.primitives.TbcdString;

public class CalledPartyBCDNumberImpl
extends OctetStringBase
implements CalledPartyBCDNumber {
    private static final String NAI = "nai";
    private static final String NPI = "npi";
    private static final String NUMBER = "number";
    private static final String DEFAULT_STRING_VALUE = null;
    protected static final int NO_EXTENSION_MASK = 128;
    protected static final int NATURE_OF_ADD_IND_MASK = 112;
    protected static final int NUMBERING_PLAN_IND_MASK = 15;
    protected static final XMLFormat<CalledPartyBCDNumberImpl> CALLED_PARTY_BCD_NUMBER_XML = new XMLFormat<CalledPartyBCDNumberImpl>(CalledPartyBCDNumberImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, CalledPartyBCDNumberImpl calledPartyBCDNumber) throws XMLStreamException {
            try {
                AddressNature addressNature = null;
                NumberingPlan numberingPlan = null;
                String nai = xml.getAttribute(CalledPartyBCDNumberImpl.NAI, DEFAULT_STRING_VALUE);
                String npi = xml.getAttribute(CalledPartyBCDNumberImpl.NPI, DEFAULT_STRING_VALUE);
                if (nai != null) {
                    addressNature = Enum.valueOf(AddressNature.class, nai);
                }
                if (npi != null) {
                    numberingPlan = Enum.valueOf(NumberingPlan.class, npi);
                }
                calledPartyBCDNumber.setParameters(addressNature, numberingPlan, xml.getAttribute(CalledPartyBCDNumberImpl.NUMBER, ""));
            }
            catch (CAPException e) {
                throw new XMLStreamException("CAPException when CalledPartyBCDNumber data setting", e);
            }
        }

        @Override
        public void write(CalledPartyBCDNumberImpl calledPartyBCDNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(CalledPartyBCDNumberImpl.NUMBER, calledPartyBCDNumber.getAddress());
            xml.setAttribute(CalledPartyBCDNumberImpl.NAI, calledPartyBCDNumber.getAddressNature().toString());
            xml.setAttribute(CalledPartyBCDNumberImpl.NPI, calledPartyBCDNumber.getNumberingPlan().toString());
        }
    };

    public CalledPartyBCDNumberImpl() {
        super(1, 41, "CalledPartyBCDNumber");
    }

    public CalledPartyBCDNumberImpl(byte[] data) {
        super(1, 41, "CalledPartyBCDNumber", data);
    }

    public CalledPartyBCDNumberImpl(AddressNature addressNature, NumberingPlan numberingPlan, String address) throws CAPException {
        super(1, 41, "CalledPartyBCDNumber");
        this.setParameters(addressNature, numberingPlan, address);
    }

    protected void setParameters(AddressNature addressNature, NumberingPlan numberingPlan, String address) throws CAPException {
        if (addressNature == null || numberingPlan == null || address == null) {
            throw new CAPException("Error when encoding " + this._PrimitiveName + ": addressNature, numberingPlan or address is empty");
        }
        this._testLengthEncode(address);
        ByteArrayOutputStream stm = new ByteArrayOutputStream();
        int nature = 128;
        nature |= addressNature.getIndicator() << 4;
        stm.write(nature |= numberingPlan.getIndicator());
        if (numberingPlan == NumberingPlan.spare_5) {
            GSMCharset cs = new GSMCharset("GSM", new String[0]);
            GSMCharsetEncoder encoder = (GSMCharsetEncoder)cs.newEncoder();
            try {
                ByteBuffer bb = encoder.encode(CharBuffer.wrap(address));
                int dataLength = bb.limit();
                byte[] data = new byte[dataLength];
                bb.get(data);
                stm.write(data);
            }
            catch (CharacterCodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                TbcdString.encodeString(stm, address);
            }
            catch (MAPException e) {
                throw new CAPException(e);
            }
        }
        this.data = stm.toByteArray();
    }

    public byte[] getData() {
        return this.data;
    }

    public AddressNature getAddressNature() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        byte nature = this.data[0];
        int natureOfAddInd = (nature & 0x70) >> 4;
        return AddressNature.getInstance(natureOfAddInd);
    }

    public NumberingPlan getNumberingPlan() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        byte nature = this.data[0];
        int numbPlanInd = nature & 0xF;
        return NumberingPlan.getInstance(numbPlanInd);
    }

    public boolean isExtension() {
        if (this.data == null || this.data.length == 0) {
            return false;
        }
        byte nature = this.data[0];
        return (nature & 0x80) != 128;
    }

    public String getAddress() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream stm = new ByteArrayInputStream(this.data);
            stm.read();
            if (this.getNumberingPlan() == NumberingPlan.spare_5) {
                if (this.data.length == 1) {
                    return "";
                }
                int addressLength = this.data.length - 1;
                ByteBuffer bb = ByteBuffer.wrap(this.data, 1, addressLength);
                GSMCharset cs = new GSMCharset("GSM", new String[0]);
                GSMCharsetDecoder decoder = (GSMCharsetDecoder)cs.newDecoder();
                int totalSeptetCount = addressLength + addressLength / 8;
                GSMCharsetDecodingData encodingData = new GSMCharsetDecodingData(Gsm7EncodingStyle.bit7_sms_style, totalSeptetCount, 0);
                decoder.setGSMCharsetDecodingData(encodingData);
                CharBuffer bf = decoder.decode(bb);
                return bf.toString();
            }
            String address = TbcdString.decodeString(stm, this.data.length - 1);
            return address;
        }
        catch (MAPParsingComponentException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void _testLengthEncode(String address) throws CAPException {
        if (address.length() > 38) {
            throw new CAPException("Error when encoding AddressString: address length must not exceed 38 digits");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.getAddressNature() != null) {
            sb.append("addressNature=");
            sb.append((Object)this.getAddressNature());
        }
        if (this.getNumberingPlan() != null) {
            sb.append(", numberingPlan=");
            sb.append((Object)this.getNumberingPlan());
        }
        if (this.getAddress() != null) {
            sb.append(", address=");
            sb.append(this.getAddress());
        }
        if (this.isExtension()) {
            sb.append(", extension");
        }
        sb.append("]");
        return sb.toString();
    }
}

