/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.api;

import java.util.Arrays;
import org.mobicents.protocols.ss7.cap.api.CAPApplicationContextVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CAPApplicationContext {
    CapV1_gsmSSF_to_gsmSCF(11),
    CapV2_gsmSSF_to_gsmSCF(21),
    CapV2_assistGsmSSF_to_gsmSCF(22),
    CapV2_gsmSRF_to_gsmSCF(24),
    CapV3_gsmSSF_scfGeneric(31),
    CapV3_gsmSSF_scfAssistHandoff(32),
    CapV3_gsmSRF_gsmSCF(34),
    CapV3_gprsSSF_gsmSCF(35),
    CapV3_gsmSCF_gprsSSF(36),
    CapV3_cap3_sms(37),
    CapV4_gsmSSF_scfGeneric(41),
    CapV4_gsmSSF_scfAssistHandoff(42),
    CapV4_scf_gsmSSFGeneric(43),
    CapV4_gsmSRF_gsmSCF(44),
    CapV4_cap4_sms(48);

    private static long[] oidTemplate;
    private int code;
    private CAPApplicationContextVersion applicationContextVersion;

    private CAPApplicationContext(int code) {
        this.code = code;
        this.applicationContextVersion = code == 11 ? CAPApplicationContextVersion.version1 : (code < 30 ? CAPApplicationContextVersion.version2 : (code < 40 ? CAPApplicationContextVersion.version3 : CAPApplicationContextVersion.version4));
    }

    public static CAPApplicationContext getInstance(long[] oid) {
        if (oid == null || oid.length != oidTemplate.length) {
            return null;
        }
        for (int i1 = 0; i1 < oidTemplate.length - 3; ++i1) {
            if (oid[i1] == oidTemplate[i1]) continue;
            return null;
        }
        if (oid[5] == 0L && oid[6] == 50L && oid[7] == 0L) {
            return CapV1_gsmSSF_to_gsmSCF;
        }
        if (oid[5] == 0L && oid[6] == 50L && oid[7] == 1L) {
            return CapV2_gsmSSF_to_gsmSCF;
        }
        if (oid[5] == 0L && oid[6] == 51L && oid[7] == 1L) {
            return CapV2_assistGsmSSF_to_gsmSCF;
        }
        if (oid[5] == 0L && oid[6] == 52L && oid[7] == 1L) {
            return CapV2_gsmSRF_to_gsmSCF;
        }
        if (oid[5] == 21L && oid[6] == 3L && oid[7] == 4L) {
            return CapV3_gsmSSF_scfGeneric;
        }
        if (oid[5] == 21L && oid[6] == 3L && oid[7] == 6L) {
            return CapV3_gsmSSF_scfAssistHandoff;
        }
        if (oid[5] == 20L && oid[6] == 3L && oid[7] == 14L) {
            return CapV3_gsmSRF_gsmSCF;
        }
        if (oid[5] == 21L && oid[6] == 3L && oid[7] == 50L) {
            return CapV3_gprsSSF_gsmSCF;
        }
        if (oid[5] == 21L && oid[6] == 3L && oid[7] == 51L) {
            return CapV3_gsmSCF_gprsSSF;
        }
        if (oid[5] == 21L && oid[6] == 3L && oid[7] == 61L) {
            return CapV3_cap3_sms;
        }
        if (oid[5] == 23L && oid[6] == 3L && oid[7] == 4L) {
            return CapV4_gsmSSF_scfGeneric;
        }
        if (oid[5] == 23L && oid[6] == 3L && oid[7] == 6L) {
            return CapV4_gsmSSF_scfAssistHandoff;
        }
        if (oid[5] == 23L && oid[6] == 3L && oid[7] == 8L) {
            return CapV4_scf_gsmSSFGeneric;
        }
        if (oid[5] == 22L && oid[6] == 3L && oid[7] == 14L) {
            return CapV4_gsmSRF_gsmSCF;
        }
        if (oid[5] == 23L && oid[6] == 3L && oid[7] == 61L) {
            return CapV4_cap4_sms;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public CAPApplicationContextVersion getVersion() {
        return this.applicationContextVersion;
    }

    public long[] getOID() {
        long[] res = Arrays.copyOf(oidTemplate, oidTemplate.length);
        switch (this) {
            case CapV1_gsmSSF_to_gsmSCF: {
                res[5] = 0L;
                res[6] = 50L;
                res[7] = 0L;
                break;
            }
            case CapV2_gsmSSF_to_gsmSCF: {
                res[5] = 0L;
                res[6] = 50L;
                res[7] = 1L;
                break;
            }
            case CapV2_assistGsmSSF_to_gsmSCF: {
                res[5] = 0L;
                res[6] = 51L;
                res[7] = 1L;
                break;
            }
            case CapV2_gsmSRF_to_gsmSCF: {
                res[5] = 0L;
                res[6] = 52L;
                res[7] = 1L;
                break;
            }
            case CapV3_gsmSSF_scfGeneric: {
                res[5] = 21L;
                res[6] = 3L;
                res[7] = 4L;
                break;
            }
            case CapV3_gsmSSF_scfAssistHandoff: {
                res[5] = 21L;
                res[6] = 3L;
                res[7] = 6L;
                break;
            }
            case CapV3_gsmSRF_gsmSCF: {
                res[5] = 20L;
                res[6] = 3L;
                res[7] = 14L;
                break;
            }
            case CapV3_gprsSSF_gsmSCF: {
                res[5] = 21L;
                res[6] = 3L;
                res[7] = 50L;
                break;
            }
            case CapV3_gsmSCF_gprsSSF: {
                res[5] = 21L;
                res[6] = 3L;
                res[7] = 51L;
                break;
            }
            case CapV3_cap3_sms: {
                res[5] = 21L;
                res[6] = 3L;
                res[7] = 61L;
                break;
            }
            case CapV4_gsmSSF_scfGeneric: {
                res[5] = 23L;
                res[6] = 3L;
                res[7] = 4L;
                break;
            }
            case CapV4_gsmSSF_scfAssistHandoff: {
                res[5] = 23L;
                res[6] = 3L;
                res[7] = 6L;
                break;
            }
            case CapV4_scf_gsmSSFGeneric: {
                res[5] = 23L;
                res[6] = 3L;
                res[7] = 8L;
                break;
            }
            case CapV4_gsmSRF_gsmSCF: {
                res[5] = 22L;
                res[6] = 3L;
                res[7] = 14L;
                break;
            }
            case CapV4_cap4_sms: {
                res[5] = 23L;
                res[6] = 3L;
                res[7] = 61L;
            }
        }
        return res;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("CAPApplicationContext [Name=");
        s.append(super.toString());
        s.append(", Version=");
        s.append(this.applicationContextVersion.toString());
        s.append(", Oid=");
        for (long l : this.getOID()) {
            s.append(l).append(", ");
        }
        s.append("]");
        return s.toString();
    }

    static {
        oidTemplate = new long[]{0L, 4L, 0L, 0L, 1L, 0L, 0L, 0L};
    }
}

