/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.asn.Encodable;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;

public class TCUnidentifiedMessage
implements Encodable {
    private static final Logger logger = Logger.getLogger(TCUnidentifiedMessage.class);
    public static final int _TAG_OTX = 8;
    public static final int _TAG_DTX = 9;
    private byte[] originatingTransactionId;
    private byte[] destinationTransactionId;

    public byte[] getOriginatingTransactionId() {
        return this.originatingTransactionId;
    }

    public byte[] getDestinationTransactionId() {
        return this.destinationTransactionId;
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        throw new EncodeException("Not Supported");
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 8) {
                return;
            }
            this.originatingTransactionId = localAis.readOctetString();
            if (localAis.available() > 0) {
                tag = localAis.readTag();
                if (tag != 9) {
                    return;
                }
                this.destinationTransactionId = localAis.readOctetString();
            }
        }
        catch (IOException e) {
            logger.error("Error while decoding for TCUnidentifiedMessage", e);
        }
        catch (AsnException e) {
            logger.error("Error while decoding for TCUnidentifiedMessage", e);
        }
    }
}

