/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.router;

import java.io.Serializable;
import javolution.text.CharArray;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.sccp.LoadSharingAlgorithm;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.Rule;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.mobicents.protocols.ss7.sccp.impl.parameter.BCDEvenEncodingScheme;
import org.mobicents.protocols.ss7.sccp.impl.parameter.BCDOddEncodingScheme;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GlobalTitle0001Impl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GlobalTitle0010Impl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GlobalTitle0011Impl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.GlobalTitle0100Impl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.mobicents.protocols.ss7.sccp.parameter.EncodingScheme;
import org.mobicents.protocols.ss7.sccp.parameter.EncodingSchemeType;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0001;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0010;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0011;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;

public class RuleImpl
implements Rule,
Serializable {
    private static final char CHAR_WILD_CARD_ALL = '*';
    private static final char CHAR_WILD_CARD_SINGLE = '?';
    private static final char CHAR_MASK_SEPARATOR = '/';
    private static final String WILD_CARD_ALL = "*";
    private static final String WILD_CARD_SINGLE = "?";
    private static final String MASK_SEPARATOR = "/";
    private static final String MASK_KEEP = "K";
    private static final String MASK_REPLACE = "R";
    private static final String MASK_IGNORE = "-";
    private static final String NETWORK_ID = "networkId";
    private static final Logger logger = Logger.getLogger(RuleImpl.class);
    private static final long serialVersionUID = 2147449454267320237L;
    private static final String RULEID = "ruleId";
    private static final String RULETYPE = "ruleType";
    private static final String ORIGINATING_TYPE = "originatingType";
    private static final String LS_ALGO = "loadSharingAlgo";
    private static final String PATTERN = "patternSccpAddress";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private static final String PRIMARY_ADDRESS = "paddress";
    private static final String SECONDARY_ADDRESS = "saddress";
    private static final String NEW_CALLING_PARTY_ADDRESS = "ncpaddress";
    private static final String MASK = "mask";
    private static final String SEPARATOR = ";";
    private RuleType ruleType = RuleType.SOLITARY;
    private LoadSharingAlgorithm loadSharingAlgo = LoadSharingAlgorithm.Undefined;
    private OriginationType originationType = OriginationType.ALL;
    private SccpAddress pattern;
    private int ruleId;
    private int primaryAddressId = 0;
    private int secondaryAddressId = 0;
    private Integer newCallingPartyAddressId = null;
    private int networkId;
    private String mask = null;
    private String[] maskPattern = null;
    public static final int MIN_SIGNIFICANT_SSN = 1;
    public static final int MAX_SIGNIFICANT_SSN = 255;
    protected static final XMLFormat<RuleImpl> RULE_XML = new XMLFormat<RuleImpl>(RuleImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, RuleImpl rule) throws XMLStreamException {
            rule.ruleType = RuleType.getInstance(xml.getAttribute(RuleImpl.RULETYPE, RuleType.SOLITARY.getValue()));
            rule.loadSharingAlgo = LoadSharingAlgorithm.getInstance(xml.getAttribute(RuleImpl.LS_ALGO, LoadSharingAlgorithm.Undefined.getValue()));
            rule.originationType = OriginationType.getInstance(xml.getAttribute(RuleImpl.ORIGINATING_TYPE, OriginationType.ALL.getValue()));
            rule.mask = xml.getAttribute(RuleImpl.MASK).toString();
            rule.primaryAddressId = xml.getAttribute(RuleImpl.PRIMARY_ADDRESS).toInt();
            rule.secondaryAddressId = xml.getAttribute(RuleImpl.SECONDARY_ADDRESS).toInt();
            rule.networkId = xml.getAttribute(RuleImpl.NETWORK_ID, 0);
            CharArray cha = xml.getAttribute(RuleImpl.NEW_CALLING_PARTY_ADDRESS);
            if (cha != null) {
                rule.newCallingPartyAddressId = cha.toInt();
            } else {
                rule.newCallingPartyAddressId = null;
            }
            rule.pattern = xml.get(RuleImpl.PATTERN, SccpAddressImpl.class);
            rule.configure();
        }

        @Override
        public void write(RuleImpl rule, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(RuleImpl.RULETYPE, rule.ruleType.getValue());
            xml.setAttribute(RuleImpl.LS_ALGO, rule.loadSharingAlgo.getValue());
            xml.setAttribute(RuleImpl.ORIGINATING_TYPE, rule.originationType.getValue());
            xml.setAttribute(RuleImpl.MASK, rule.mask);
            xml.setAttribute(RuleImpl.PRIMARY_ADDRESS, rule.primaryAddressId);
            xml.setAttribute(RuleImpl.SECONDARY_ADDRESS, rule.secondaryAddressId);
            xml.setAttribute(RuleImpl.NETWORK_ID, rule.networkId);
            if (rule.newCallingPartyAddressId != null) {
                xml.setAttribute(RuleImpl.NEW_CALLING_PARTY_ADDRESS, rule.newCallingPartyAddressId);
            }
            xml.add((SccpAddressImpl)rule.pattern, RuleImpl.PATTERN, SccpAddressImpl.class);
        }
    };

    public RuleImpl() {
    }

    public RuleImpl(RuleType ruleType, LoadSharingAlgorithm loadSharingAlgo, OriginationType originationType, SccpAddress pattern, String mask, int networkId) {
        this.ruleType = ruleType;
        this.pattern = pattern;
        this.mask = mask;
        this.networkId = networkId;
        this.setLoadSharingAlgorithm(loadSharingAlgo);
        this.setOriginationType(originationType);
        this.configure();
    }

    public String getMask() {
        return this.mask;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public LoadSharingAlgorithm getLoadSharingAlgorithm() {
        return this.loadSharingAlgo;
    }

    public void setLoadSharingAlgorithm(LoadSharingAlgorithm loadSharingAlgo) {
        this.loadSharingAlgo = loadSharingAlgo == null ? LoadSharingAlgorithm.Undefined : loadSharingAlgo;
    }

    public OriginationType getOriginationType() {
        return this.originationType;
    }

    public void setOriginationType(OriginationType originationType) {
        this.originationType = originationType;
    }

    public SccpAddress getPattern() {
        return this.pattern;
    }

    private void configure() {
        this.maskPattern = this.mask.split(MASK_SEPARATOR);
    }

    public int getPrimaryAddressId() {
        return this.primaryAddressId;
    }

    public void setPrimaryAddressId(int primaryAddressId) {
        this.primaryAddressId = primaryAddressId;
    }

    public int getSecondaryAddressId() {
        return this.secondaryAddressId;
    }

    public void setSecondaryAddressId(int secondaryAddressId) {
        this.secondaryAddressId = secondaryAddressId;
    }

    public Integer getNewCallingPartyAddressId() {
        return this.newCallingPartyAddressId;
    }

    public void setNewCallingPartyAddressId(Integer newCallingPartyAddressId) {
        this.newCallingPartyAddressId = newCallingPartyAddressId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public SccpAddress translate(SccpAddress address, SccpAddress ruleAddress) {
        GlobalTitle primaryGt;
        GlobalTitleIndicator gti;
        String digits = address.getGlobalTitle().getDigits();
        String patternDigits = this.pattern.getGlobalTitle().getDigits();
        String primaryDigits = ruleAddress.getGlobalTitle().getDigits();
        String translatedDigits = this.translateDigits(digits, this.maskPattern, patternDigits.split(MASK_SEPARATOR), primaryDigits.split(MASK_SEPARATOR));
        GlobalTitle gt = null;
        if (translatedDigits != null && !translatedDigits.equals("") && (gt = this.createNewGT(gti = ruleAddress.getAddressIndicator().getGlobalTitleIndicator(), primaryGt = ruleAddress.getGlobalTitle(), translatedDigits)) == null) {
            gt = this.createNewGT(address.getAddressIndicator().getGlobalTitleIndicator(), address.getGlobalTitle(), translatedDigits);
        }
        int ssn = address.getSubsystemNumber();
        if (ruleAddress.getSubsystemNumber() > 0) {
            ssn = ruleAddress.getSubsystemNumber();
        }
        SccpAddressImpl sccpAddress = new SccpAddressImpl(ruleAddress.getAddressIndicator().getRoutingIndicator(), gt, ruleAddress.getSignalingPointCode(), ssn);
        sccpAddress.setTranslated(true);
        return sccpAddress;
    }

    private GlobalTitle createNewGT(GlobalTitleIndicator gti, GlobalTitle primaryGt, String translatedDigits) {
        AbstractGlobalTitle gt = null;
        switch (gti) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                gt = new GlobalTitle0001Impl(translatedDigits, ((GlobalTitle0001)primaryGt).getNatureOfAddress());
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                GlobalTitle0011 globalTitle0011 = (GlobalTitle0011)primaryGt;
                gt = new GlobalTitle0011Impl(translatedDigits, globalTitle0011.getTranslationType(), this.getEncodingScheme(globalTitle0011.getEncodingScheme(), translatedDigits), globalTitle0011.getNumberingPlan());
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                GlobalTitle0100 globalTitle0100 = (GlobalTitle0100)primaryGt;
                gt = new GlobalTitle0100Impl(translatedDigits, globalTitle0100.getTranslationType(), this.getEncodingScheme(globalTitle0100.getEncodingScheme(), translatedDigits), globalTitle0100.getNumberingPlan(), globalTitle0100.getNatureOfAddress());
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                gt = new GlobalTitle0010Impl(translatedDigits, ((GlobalTitle0010)primaryGt).getTranslationType());
                break;
            }
        }
        return gt;
    }

    private EncodingScheme getEncodingScheme(EncodingScheme scheme, String translatedDigits) {
        EncodingSchemeType type = scheme.getType();
        if (type == EncodingSchemeType.BCD_EVEN || type == EncodingSchemeType.BCD_ODD) {
            return translatedDigits.length() % 2 == 1 ? BCDOddEncodingScheme.INSTANCE : BCDEvenEncodingScheme.INSTANCE;
        }
        return scheme;
    }

    public boolean matches(SccpAddress address, boolean isMtpOriginated, int msgNetworkId) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Matching rule Id=%s Rule=[%s]", this.getRuleId(), this.toString()));
        }
        if (this.networkId != msgNetworkId) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("networkId didn't match. Pattern networkId=%s Address networkId=%s Return  False", this.networkId, msgNetworkId));
            }
            return false;
        }
        if (address.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN) {
            if (logger.isDebugEnabled()) {
                logger.debug("RoutingIndicator == ROUTING_BASED_ON_DPC_AND_SSN. Return");
            }
            return false;
        }
        boolean isOriginationTypeCorrect = true;
        if (this.getOriginationType() == OriginationType.LOCAL && isMtpOriginated) {
            isOriginationTypeCorrect = false;
        }
        if (this.getOriginationType() == OriginationType.REMOTE && !isMtpOriginated) {
            isOriginationTypeCorrect = false;
        }
        if (!isOriginationTypeCorrect) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("OriginationType didn't match. Pattern OriginationType=%s Address isMtpOriginated=%s Return  False", new Object[]{this.getOriginationType(), isMtpOriginated}));
            }
            return false;
        }
        if (!this.isSsnMatch(address, this.pattern)) {
            return false;
        }
        GlobalTitleIndicator gti = address.getAddressIndicator().getGlobalTitleIndicator();
        GlobalTitle patternGT = this.pattern.getGlobalTitle();
        switch (gti) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                GlobalTitle0001 gt = (GlobalTitle0001)address.getGlobalTitle();
                if (!(patternGT instanceof GlobalTitle0001)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("patternGT not instanceof GlobalTitle0001. Return False");
                    }
                    return false;
                }
                if (((GlobalTitle0001)patternGT).getNatureOfAddress() != gt.getNatureOfAddress()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Noa didn't match. Pattern Noa=%s Address Noad=%s Return  False", new Object[]{((GlobalTitle0001)patternGT).getNatureOfAddress(), gt.getNatureOfAddress()}));
                    }
                    return false;
                }
                if (!this.matchPattern(gt.getDigits().toCharArray(), patternGT.getDigits().toCharArray())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("digits didn't match. Pattern digits=%s Address Digits=%s Return  False", patternGT.getDigits(), gt.getDigits()));
                    }
                    return false;
                }
                return true;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                GlobalTitle0011 gt1 = (GlobalTitle0011)address.getGlobalTitle();
                if (!(patternGT instanceof GlobalTitle0011)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("patternGT not instanceof GlobalTitle0011. Return False");
                    }
                    return false;
                }
                if (((GlobalTitle0011)patternGT).getTranslationType() != gt1.getTranslationType()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("TT didn't match. Pattern TT=%s Address TT=%s Return  False", ((GlobalTitle0011)patternGT).getTranslationType(), gt1.getTranslationType()));
                    }
                    return false;
                }
                if (((GlobalTitle0011)patternGT).getNumberingPlan() != gt1.getNumberingPlan()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Np didn't match. Pattern Np=%s Address Np=%s Return  False", new Object[]{((GlobalTitle0011)patternGT).getNumberingPlan(), gt1.getNumberingPlan()}));
                    }
                    return false;
                }
                if (!this.matchPattern(gt1.getDigits().toCharArray(), patternGT.getDigits().toCharArray())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("digits didn't match. Pattern digits=%s Address Digits=%s Return  False", patternGT.getDigits(), gt1.getDigits()));
                    }
                    return false;
                }
                return true;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                GlobalTitle0100 gt2 = (GlobalTitle0100)address.getGlobalTitle();
                if (!(patternGT instanceof GlobalTitle0100)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("patternGT not instanceof GlobalTitle0100. Return False");
                    }
                    return false;
                }
                if (((GlobalTitle0100)patternGT).getTranslationType() != gt2.getTranslationType()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("TT didn't match. Pattern TT=%s Address TT=%s Return  False", ((GlobalTitle0100)patternGT).getTranslationType(), gt2.getTranslationType()));
                    }
                    return false;
                }
                if (((GlobalTitle0100)patternGT).getNumberingPlan() != gt2.getNumberingPlan()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Np didn't match. Pattern Np=%s Address Np=%s Return  False", new Object[]{((GlobalTitle0100)patternGT).getNumberingPlan(), gt2.getNumberingPlan()}));
                    }
                    return false;
                }
                if (((GlobalTitle0100)patternGT).getNatureOfAddress() != gt2.getNatureOfAddress()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Noa didn't match. Pattern Noa=%s Address Noa=%s Return  False", new Object[]{((GlobalTitle0100)patternGT).getNatureOfAddress(), gt2.getNatureOfAddress()}));
                    }
                    return false;
                }
                if (!this.matchPattern(gt2.getDigits().toCharArray(), this.pattern.getGlobalTitle().getDigits().toCharArray())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("digits didn't match. Pattern digits=%s Address Digits=%s Return  False", patternGT.getDigits(), gt2.getDigits()));
                    }
                    return false;
                }
                return true;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                GlobalTitle0010 gt3 = (GlobalTitle0010)address.getGlobalTitle();
                if (!(patternGT instanceof GlobalTitle0010)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("patternGT not instanceof GlobalTitle0010. Return False");
                    }
                    return false;
                }
                if (((GlobalTitle0010)patternGT).getTranslationType() != gt3.getTranslationType()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("TT didn't match. Pattern TT=%s Address TT=%s Return  False", ((GlobalTitle0010)patternGT).getTranslationType(), gt3.getTranslationType()));
                    }
                    return false;
                }
                if (!this.matchPattern(gt3.getDigits().toCharArray(), this.pattern.getGlobalTitle().getDigits().toCharArray())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("digits didn't match. Pattern digits=%s Address Digits=%s Return  False", patternGT.getDigits(), gt3.getDigits()));
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isSsnMatch(SccpAddress address, SccpAddress pattern) {
        if (!this.isSsnSignificant(pattern.getSubsystemNumber()) || !pattern.getAddressIndicator().isSSNPresent()) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("SSN is not present or insignificant [%s]. Assume SSN matches. Return True", pattern.getSubsystemNumber()));
            }
            return true;
        }
        if (pattern.getAddressIndicator().isSSNPresent() && address.getAddressIndicator().isSSNPresent() && address.getSubsystemNumber() == pattern.getSubsystemNumber()) {
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("SSN didn't match. Pattern: isSsnPresent=%s, SSN=%s Address: isSsnPresent=%s, SSN=%s Return  False", pattern.getAddressIndicator().isSSNPresent(), pattern.getSubsystemNumber(), address.getAddressIndicator().isSSNPresent(), address.getSubsystemNumber()));
        }
        return false;
    }

    private boolean isSsnSignificant(int ssn) {
        return 1 <= ssn && ssn <= 255;
    }

    private String translateDigits(String digits, String[] masks, String[] patternDigits, String[] addressDigits) {
        int count;
        StringBuffer translatedDigits = new StringBuffer();
        String[] digitComponents = new String[patternDigits.length];
        int offset = 0;
        for (count = 0; count < patternDigits.length; ++count) {
            if (patternDigits[count].equals(WILD_CARD_ALL)) {
                digitComponents[count] = digits.substring(offset, digits.length());
                break;
            }
            digitComponents[count] = digits.substring(offset, offset + patternDigits[count].length());
            offset += patternDigits[count].length();
        }
        for (count = 0; count < patternDigits.length; ++count) {
            if (masks[count].equals(MASK_KEEP)) {
                if (digitComponents[count] == null) continue;
                translatedDigits.append(digitComponents[count]);
                continue;
            }
            if (!masks[count].equals(MASK_REPLACE) || addressDigits[count].contains(MASK_IGNORE)) continue;
            translatedDigits.append(addressDigits[count]);
        }
        return translatedDigits.toString();
    }

    private boolean matchPattern(char[] digits, char[] pattern) {
        int j = 0;
        for (int i = 0; i < pattern.length; ++i) {
            if (j >= digits.length) {
                return pattern[j] == '/' && pattern[j + 1] == '*';
            }
            if (pattern[i] == '*') {
                return true;
            }
            if (pattern[i] == '?') {
                ++j;
                continue;
            }
            if (pattern[i] == '/') continue;
            if (pattern[i] != digits[j]) {
                return false;
            }
            ++j;
        }
        return j == digits.length;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(RULEID);
        buff.append(OPEN_BRACKET);
        buff.append(this.ruleId);
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        buff.append(RULETYPE);
        buff.append(OPEN_BRACKET);
        buff.append(this.ruleType.getValue());
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        if (this.ruleType == RuleType.LOADSHARED) {
            buff.append(LS_ALGO);
            buff.append(OPEN_BRACKET);
            buff.append(this.loadSharingAlgo.getValue());
            buff.append(CLOSE_BRACKET);
            buff.append(SEPARATOR);
        }
        buff.append(ORIGINATING_TYPE);
        buff.append(OPEN_BRACKET);
        buff.append(this.originationType.getValue());
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        buff.append(PATTERN);
        buff.append(OPEN_BRACKET);
        buff.append(this.pattern.toString());
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        buff.append(PRIMARY_ADDRESS);
        buff.append(OPEN_BRACKET);
        buff.append(this.primaryAddressId);
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        buff.append(SECONDARY_ADDRESS);
        buff.append(OPEN_BRACKET);
        buff.append(this.secondaryAddressId);
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        if (this.newCallingPartyAddressId != null) {
            buff.append(NEW_CALLING_PARTY_ADDRESS);
            buff.append(OPEN_BRACKET);
            buff.append(this.newCallingPartyAddressId);
            buff.append(CLOSE_BRACKET);
            buff.append(SEPARATOR);
        }
        buff.append(MASK);
        buff.append(OPEN_BRACKET);
        buff.append(this.mask);
        buff.append(CLOSE_BRACKET);
        buff.append(SEPARATOR);
        buff.append(NETWORK_ID);
        buff.append(OPEN_BRACKET);
        buff.append(this.networkId);
        buff.append(CLOSE_BRACKET);
        return buff.toString();
    }
}

