/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.EMLPPPriority;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.AddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SupplementaryMessageImpl;

public class RegisterSSRequestImpl
extends SupplementaryMessageImpl
implements RegisterSSRequest {
    protected static final int _TAG_forwardedToNumber = 4;
    protected static final int _TAG_forwardedToSubaddress = 6;
    protected static final int _TAG_noReplyConditionTime = 5;
    protected static final int _TAG_defaultPriority = 7;
    protected static final int _TAG_nbrUser = 8;
    protected static final int _TAG_longFTN_Supported = 9;
    public static final String _PrimitiveName = "RegisterSSRequest";
    private SSCode ssCode;
    private BasicServiceCode basicService;
    private AddressString forwardedToNumber;
    private ISDNAddressString forwardedToSubaddress;
    private Integer noReplyConditionTime;
    private EMLPPPriority defaultPriority;
    private Integer nbrUser;
    private ISDNAddressString longFTNSupported;

    public RegisterSSRequestImpl() {
    }

    public RegisterSSRequestImpl(SSCode ssCode, BasicServiceCode basicService, AddressString forwardedToNumber, ISDNAddressString forwardedToSubaddress, Integer noReplyConditionTime, EMLPPPriority defaultPriority, Integer nbrUser, ISDNAddressString longFTNSupported) {
        this.ssCode = ssCode;
        this.basicService = basicService;
        this.forwardedToNumber = forwardedToNumber;
        this.forwardedToSubaddress = forwardedToSubaddress;
        this.noReplyConditionTime = noReplyConditionTime;
        this.defaultPriority = defaultPriority;
        this.nbrUser = nbrUser;
        this.longFTNSupported = longFTNSupported;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.registerSS_Request;
    }

    public int getOperationCode() {
        return 10;
    }

    public SSCode getSsCode() {
        return this.ssCode;
    }

    public BasicServiceCode getBasicService() {
        return this.basicService;
    }

    public AddressString getForwardedToNumber() {
        return this.forwardedToNumber;
    }

    public ISDNAddressString getForwardedToSubaddress() {
        return this.forwardedToSubaddress;
    }

    public Integer getNoReplyConditionTime() {
        return this.noReplyConditionTime;
    }

    public EMLPPPriority getDefaultPriority() {
        return this.defaultPriority;
    }

    public Integer getNbrUser() {
        return this.nbrUser;
    }

    public ISDNAddressString getLongFTNSupported() {
        return this.longFTNSupported;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RegisterSSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RegisterSSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RegisterSSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RegisterSSRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.basicService = null;
        this.forwardedToNumber = null;
        this.forwardedToSubaddress = null;
        this.noReplyConditionTime = null;
        this.defaultPriority = null;
        this.nbrUser = null;
        this.longFTNSupported = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.ssCode: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssCode = new SSCodeImpl();
                    ((SSCodeImpl)this.ssCode).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 2: 
                            case 3: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.basicService: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.basicService = new BasicServiceCodeImpl();
                                ((BasicServiceCodeImpl)this.basicService).decodeAll(ais);
                                break block0;
                            }
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.forwardedToNumber: Parameter extensionContainer is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.forwardedToNumber = new AddressStringImpl();
                                ((AddressStringImpl)this.forwardedToNumber).decodeAll(ais);
                                break block0;
                            }
                            case 6: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.forwardedToSubaddress: Parameter extensionContainer is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.forwardedToSubaddress = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.forwardedToSubaddress).decodeAll(ais);
                                break block0;
                            }
                            case 5: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.noReplyConditionTime: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.noReplyConditionTime = (int)ais.readInteger();
                                break block0;
                            }
                            case 7: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.defaultPriority: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                int i1 = (int)ais.readInteger();
                                this.defaultPriority = EMLPPPriority.getEMLPPPriority(i1);
                                break block0;
                            }
                            case 8: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.nbrUser: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.nbrUser = (int)ais.readInteger();
                                break block0;
                            }
                            case 9: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding RegisterSSRequest.longFTNSupported: Parameter extensionContainer is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.longFTNSupported = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.longFTNSupported).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 1) {
            throw new MAPParsingComponentException("Error while decoding RegisterSSRequest: Needs at least 1 mandatory parameter, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding RegisterSSRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.ssCode == null) {
                throw new MAPException("ssCode parameter must not be null");
            }
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
            if (this.basicService != null) {
                ((BasicServiceCodeImpl)this.basicService).encodeAll(asnOs);
            }
            if (this.forwardedToNumber != null) {
                ((AddressStringImpl)this.forwardedToNumber).encodeAll(asnOs, 2, 4);
            }
            if (this.forwardedToSubaddress != null) {
                ((ISDNAddressStringImpl)this.forwardedToSubaddress).encodeAll(asnOs, 2, 6);
            }
            if (this.noReplyConditionTime != null) {
                asnOs.writeInteger(2, 5, this.noReplyConditionTime.intValue());
            }
            if (this.defaultPriority != null) {
                asnOs.writeInteger(2, 7, this.defaultPriority.getCode());
            }
            if (this.nbrUser != null) {
                asnOs.writeInteger(2, 8, this.nbrUser.intValue());
            }
            if (this.longFTNSupported != null) {
                ((ISDNAddressStringImpl)this.longFTNSupported).encodeAll(asnOs, 2, 9);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding RegisterSSRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding RegisterSSRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode);
            sb.append(", ");
        }
        if (this.basicService != null) {
            sb.append("basicService=");
            sb.append(this.basicService);
            sb.append(", ");
        }
        if (this.forwardedToNumber != null) {
            sb.append("forwardedToNumber=");
            sb.append(this.forwardedToNumber);
            sb.append(", ");
        }
        if (this.forwardedToSubaddress != null) {
            sb.append("forwardedToSubaddress=");
            sb.append(this.forwardedToSubaddress);
            sb.append(", ");
        }
        if (this.noReplyConditionTime != null) {
            sb.append("noReplyConditionTime=");
            sb.append(this.noReplyConditionTime);
            sb.append(", ");
        }
        if (this.defaultPriority != null) {
            sb.append("defaultPriority=");
            sb.append((Object)this.defaultPriority);
            sb.append(", ");
        }
        if (this.nbrUser != null) {
            sb.append("nbrUser=");
            sb.append(this.nbrUser);
            sb.append(", ");
        }
        if (this.longFTNSupported != null) {
            sb.append("longFTNSupported=");
            sb.append(this.longFTNSupported);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

