/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MTSMSTPDUType;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MTsmsCAMELTDPCriteria;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.SMSTriggerDetectionPoint;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTsmsCAMELTDPCriteriaImpl
extends SequenceBase
implements MTsmsCAMELTDPCriteria {
    private static final int _TAG_tPDUTypeCriterion = 0;
    private SMSTriggerDetectionPoint smsTriggerDetectionPoint;
    private ArrayList<MTSMSTPDUType> tPDUTypeCriterion;

    public MTsmsCAMELTDPCriteriaImpl() {
        super("MTsmsCAMELTDPCriteria");
    }

    public MTsmsCAMELTDPCriteriaImpl(SMSTriggerDetectionPoint smsTriggerDetectionPoint, ArrayList<MTSMSTPDUType> tPDUTypeCriterion) {
        super("MTsmsCAMELTDPCriteria");
        this.smsTriggerDetectionPoint = smsTriggerDetectionPoint;
        this.tPDUTypeCriterion = tPDUTypeCriterion;
    }

    @Override
    public SMSTriggerDetectionPoint getSMSTriggerDetectionPoint() {
        return this.smsTriggerDetectionPoint;
    }

    @Override
    public ArrayList<MTSMSTPDUType> getTPDUTypeCriterion() {
        return this.tPDUTypeCriterion;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.smsTriggerDetectionPoint = null;
        this.tPDUTypeCriterion = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block10: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 10: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".smsTriggerDetectionPoint:  not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int code = (int)ais.readInteger();
                            this.smsTriggerDetectionPoint = SMSTriggerDetectionPoint.getInstance(code);
                            continue block10;
                        }
                    }
                    ais.advanceElement();
                    continue block10;
                }
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".tPDUTypeCriterion: is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.tPDUTypeCriterion = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 10 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".mtSMSTPDUType: bad tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                int code = (int)ais2.readInteger();
                                MTSMSTPDUType mtSMSTPDUType = MTSMSTPDUType.getInstance(code);
                                this.tPDUTypeCriterion.add(mtSMSTPDUType);
                            }
                            if (this.tPDUTypeCriterion.size() >= 1 && this.tPDUTypeCriterion.size() <= 6) continue block10;
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter tPDUTypeCriterion size must be from 1 to 6, found: " + this.tPDUTypeCriterion.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                    }
                    ais.advanceElement();
                    continue block10;
                }
            }
            ais.advanceElement();
        }
        if (this.smsTriggerDetectionPoint == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament smsTriggerDetectionPoint is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.smsTriggerDetectionPoint == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": smsTriggerDetectionPoint required.");
        }
        if (this.tPDUTypeCriterion != null && (this.tPDUTypeCriterion.size() < 1 || this.tPDUTypeCriterion.size() > 6)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter tPDUTypeCriterion size must be from 1 to 6, found: " + this.tPDUTypeCriterion.size());
        }
        try {
            asnOs.writeInteger(0, 10, this.smsTriggerDetectionPoint.getCode());
            if (this.tPDUTypeCriterion != null) {
                asnOs.writeTag(2, false, 0);
                int pos = asnOs.StartContentDefiniteLength();
                for (MTSMSTPDUType mtSMSTPDUType : this.tPDUTypeCriterion) {
                    asnOs.writeInteger(0, 10, mtSMSTPDUType.getCode());
                }
                asnOs.FinalizeContent(pos);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.smsTriggerDetectionPoint != null) {
            sb.append("smsTriggerDetectionPoint=");
            sb.append(this.smsTriggerDetectionPoint.toString());
            sb.append(", ");
        }
        if (this.tPDUTypeCriterion != null) {
            sb.append("mobilityTriggers=[");
            boolean firstItem = true;
            for (MTSMSTPDUType be : this.tPDUTypeCriterion) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

