/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAIdentity;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.LSAInformationWithdraw;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.LSAIdentityImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSAInformationWithdrawImpl
implements LSAInformationWithdraw,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "LSAInformationWithdraw";
    private boolean allLSAData;
    private ArrayList<LSAIdentity> lsaIdentityList;

    public LSAInformationWithdrawImpl() {
    }

    public LSAInformationWithdrawImpl(boolean allLSAData) {
        this.allLSAData = allLSAData;
    }

    public LSAInformationWithdrawImpl(ArrayList<LSAIdentity> lsaIdentityList) {
        this.lsaIdentityList = lsaIdentityList;
    }

    @Override
    public boolean getAllLSAData() {
        return this.allLSAData;
    }

    @Override
    public ArrayList<LSAIdentity> getLSAIdentityList() {
        return this.lsaIdentityList;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.allLSAData) {
            return 5;
        }
        if (this.lsaIdentityList != null) {
            return 16;
        }
        throw new MAPException("Error encoding LSAInformationWithdraw: no choices are selected");
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.allLSAData;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LSAInformationWithdraw: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LSAInformationWithdraw: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LSAInformationWithdraw: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LSAInformationWithdraw: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        block10: {
            block9: {
                this.allLSAData = false;
                this.lsaIdentityList = null;
                if (ansIS.getTagClass() != 0) break block9;
                switch (ansIS.getTag()) {
                    case 5: {
                        if (!ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding allLSAData choice: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ansIS.readNullData(length);
                        this.allLSAData = true;
                        break block10;
                    }
                    case 16: {
                        if (ansIS.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding lsaIdentityList choice: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ansIS.readSequenceStreamData(length);
                        this.lsaIdentityList = new ArrayList();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding LSAInformationWithdraw: bad contextIdList element tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            LSAIdentityImpl lsaIdentity = new LSAIdentityImpl();
                            lsaIdentity.decodeAll(ais2);
                            this.lsaIdentityList.add(lsaIdentity);
                        }
                        if (this.lsaIdentityList.size() < 1 || this.lsaIdentityList.size() > 20) {
                            throw new MAPParsingComponentException("Error while decoding LSAInformationWithdraw: Parameter contextIdList size must be from 1 to 20, found: " + this.lsaIdentityList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        break block10;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding LSAInformationWithdraw: bad tag for Universal TagClass: " + ansIS.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new MAPParsingComponentException("Error while decoding LSAInformationWithdraw: bad tagClass: " + ansIS.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LSAInformationWithdraw: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (!this.allLSAData && this.lsaIdentityList == null) {
            throw new MAPException("Error while encoding the LSAInformationWithdraw: no choice is defined");
        }
        if (this.allLSAData && this.lsaIdentityList != null) {
            throw new MAPException("Error while encoding the LSAInformationWithdraw: both choice is defined");
        }
        if (this.lsaIdentityList != null && (this.lsaIdentityList.size() < 1 || this.lsaIdentityList.size() > 20)) {
            throw new MAPException("Error while encoding the LSAInformationWithdrawParameter lsaIdentityList size must be from 1 to 20, found: " + this.lsaIdentityList.size());
        }
        if (this.allLSAData) {
            asnOs.writeNullData();
        } else {
            for (LSAIdentity lsaId : this.lsaIdentityList) {
                if (lsaId == null) {
                    throw new MAPException("Error while encoding the LSAInformationWithdraw: lsaIdentityList must not contain null lsaId value");
                }
                ((LSAIdentityImpl)lsaId).encodeAll(asnOs);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.allLSAData) {
            sb.append("allLSAData, ");
        }
        if (this.lsaIdentityList != null) {
            sb.append("lsaIdentityList=[");
            for (LSAIdentity lsaId : this.lsaIdentityList) {
                sb.append(lsaId);
                sb.append(", ");
            }
            sb.append("], ");
        }
        sb.append("]");
        return sb.toString();
    }
}

