/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.EMLPPInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtCallBarInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtForwInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSData;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGInfoImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.EMLPPInfoImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtCallBarInfoImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtForwInfoImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtSSDataImpl;

public class ExtSSInfoImpl
implements ExtSSInfo,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "ExtSSInfo";
    protected static final int _TAG_forwardingInfo = 0;
    protected static final int _TAG_callBarringInfo = 1;
    protected static final int _TAG_cugInfo = 2;
    protected static final int _TAG_ssData = 3;
    protected static final int _TAG_emlppInfo = 4;
    private ExtForwInfo forwardingInfo = null;
    private ExtCallBarInfo callBarringInfo = null;
    private CUGInfo cugInfo = null;
    private ExtSSData ssData = null;
    private EMLPPInfo emlppInfo = null;

    public ExtSSInfoImpl() {
    }

    public ExtSSInfoImpl(ExtForwInfo forwardingInfo) {
        this.forwardingInfo = forwardingInfo;
    }

    public ExtSSInfoImpl(ExtCallBarInfo callBarringInfo) {
        this.callBarringInfo = callBarringInfo;
    }

    public ExtSSInfoImpl(CUGInfo cugInfo) {
        this.cugInfo = cugInfo;
    }

    public ExtSSInfoImpl(ExtSSData ssData) {
        this.ssData = ssData;
    }

    public ExtSSInfoImpl(EMLPPInfo emlppInfo) {
        this.emlppInfo = emlppInfo;
    }

    public ExtForwInfo getForwardingInfo() {
        return this.forwardingInfo;
    }

    public ExtCallBarInfo getCallBarringInfo() {
        return this.callBarringInfo;
    }

    public CUGInfo getCugInfo() {
        return this.cugInfo;
    }

    public ExtSSData getSsData() {
        return this.ssData;
    }

    public EMLPPInfo getEmlppInfo() {
        return this.emlppInfo;
    }

    public int getTag() throws MAPException {
        if (this.forwardingInfo != null) {
            return 0;
        }
        if (this.callBarringInfo != null) {
            return 1;
        }
        if (this.cugInfo != null) {
            return 2;
        }
        if (this.ssData != null) {
            return 3;
        }
        if (this.emlppInfo != null) {
            return 4;
        }
        throw new MAPException("No of choices are supplied");
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ExtSSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ExtSSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ExtSSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ExtSSInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.forwardingInfo = null;
        this.callBarringInfo = null;
        this.cugInfo = null;
        this.ssData = null;
        this.emlppInfo = null;
        if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ExtSSInfo: bad tag class or is primitive: TagClass=" + ais.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.forwardingInfo = new ExtForwInfoImpl();
                ((ExtForwInfoImpl)this.forwardingInfo).decodeData(ais, length);
                break;
            }
            case 1: {
                this.callBarringInfo = new ExtCallBarInfoImpl();
                ((ExtCallBarInfoImpl)this.callBarringInfo).decodeData(ais, length);
                break;
            }
            case 2: {
                this.cugInfo = new CUGInfoImpl();
                ((CUGInfoImpl)this.cugInfo).decodeData(ais, length);
                break;
            }
            case 3: {
                this.ssData = new ExtSSDataImpl();
                ((ExtSSDataImpl)this.ssData).decodeData(ais, length);
                break;
            }
            case 4: {
                this.emlppInfo = new EMLPPInfoImpl();
                ((EMLPPInfoImpl)this.emlppInfo).decodeData(ais, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while ExtSSInfo: bad tag: " + ais.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ExtSSInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        int cnt = 0;
        if (this.forwardingInfo != null) {
            ++cnt;
        }
        if (this.callBarringInfo != null) {
            ++cnt;
        }
        if (this.cugInfo != null) {
            ++cnt;
        }
        if (this.ssData != null) {
            ++cnt;
        }
        if (this.emlppInfo != null) {
            ++cnt;
        }
        if (cnt != 1) {
            throw new MAPException("Error while encoding ExtSSInfo: one and only one choice is required.");
        }
        if (this.forwardingInfo != null) {
            ((ExtForwInfoImpl)this.forwardingInfo).encodeData(asnOs);
            return;
        }
        if (this.callBarringInfo != null) {
            ((ExtCallBarInfoImpl)this.callBarringInfo).encodeData(asnOs);
            return;
        }
        if (this.cugInfo != null) {
            ((CUGInfoImpl)this.cugInfo).encodeData(asnOs);
            return;
        }
        if (this.ssData != null) {
            ((ExtSSDataImpl)this.ssData).encodeData(asnOs);
            return;
        }
        if (this.emlppInfo != null) {
            ((EMLPPInfoImpl)this.emlppInfo).encodeData(asnOs);
            return;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtSSInfo [");
        if (this.forwardingInfo != null) {
            sb.append("forwardingInfo=");
            sb.append(this.forwardingInfo.toString());
            sb.append(", ");
        }
        if (this.callBarringInfo != null) {
            sb.append("callBarringInfo=");
            sb.append(this.callBarringInfo.toString());
            sb.append(", ");
        }
        if (this.cugInfo != null) {
            sb.append("cugInfo=");
            sb.append(this.cugInfo.toString());
            sb.append(", ");
        }
        if (this.ssData != null) {
            sb.append("ssData=");
            sb.append(this.ssData.toString());
            sb.append(", ");
        }
        if (this.emlppInfo != null) {
            sb.append("emlppInfo=");
            sb.append(this.emlppInfo.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

