/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.MNPInfoRes;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.NumberPortabilityStatus;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.RouteingNumber;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.RouteingNumberImpl;

public class MNPInfoResImpl
implements MNPInfoRes,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "MNPInfoRes";
    private static final int _ID_routeingNumber = 0;
    private static final int _ID_imsi = 1;
    private static final int _ID_msisdn = 2;
    private static final int _ID_numberPortabilityStatus = 3;
    private static final int _ID_extensionContainer = 4;
    private RouteingNumber routeingNumber;
    private IMSI imsi;
    private ISDNAddressString msisdn;
    private NumberPortabilityStatus numberPortabilityStatus;
    private MAPExtensionContainer extensionContainer;

    public MNPInfoResImpl() {
    }

    public MNPInfoResImpl(RouteingNumber routeingNumber, IMSI imsi, ISDNAddressString msisdn, NumberPortabilityStatus numberPortabilityStatus, MAPExtensionContainer extensionContainer) {
        this.routeingNumber = routeingNumber;
        this.imsi = imsi;
        this.msisdn = msisdn;
        this.numberPortabilityStatus = numberPortabilityStatus;
        this.extensionContainer = extensionContainer;
    }

    public RouteingNumber getRouteingNumber() {
        return this.routeingNumber;
    }

    public IMSI getIMSI() {
        return this.imsi;
    }

    public ISDNAddressString getMSISDN() {
        return this.msisdn;
    }

    public NumberPortabilityStatus getNumberPortabilityStatus() {
        return this.numberPortabilityStatus;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MNPInfoRes: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MNPInfoRes: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MNPInfoRes: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MNPInfoRes: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.routeingNumber = null;
        this.imsi = null;
        this.msisdn = null;
        this.numberPortabilityStatus = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding MNPInfoRes routeingNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.routeingNumber = new RouteingNumberImpl();
                        ((RouteingNumberImpl)this.routeingNumber).decodeAll(ais);
                        continue block7;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding MNPInfoRes imsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                        continue block7;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding MNPInfoRes msisdn: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.msisdn = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.msisdn).decodeAll(ais);
                        continue block7;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding MNPInfoRes numberPortabilityStatus: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.numberPortabilityStatus = NumberPortabilityStatus.getInstance(i1);
                        continue block7;
                    }
                    case 4: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding MNPInfoRes extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MNPInfoRes: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.routeingNumber != null) {
            ((RouteingNumberImpl)this.routeingNumber).encodeAll(asnOs, 2, 0);
        }
        if (this.imsi != null) {
            ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 1);
        }
        if (this.msisdn != null) {
            ((ISDNAddressStringImpl)this.msisdn).encodeAll(asnOs, 2, 2);
        }
        if (this.numberPortabilityStatus != null) {
            try {
                asnOs.writeInteger(2, 3, this.numberPortabilityStatus.getType());
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding MNPInfoRes: " + e.getMessage(), e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding MNPInfoRes: " + e.getMessage(), e);
            }
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 4);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.routeingNumber != null) {
            sb.append("routeingNumber=");
            sb.append(this.routeingNumber);
        }
        if (this.imsi != null) {
            sb.append(", imsi=");
            sb.append(this.imsi);
        }
        if (this.msisdn != null) {
            sb.append(", msisdn=");
            sb.append(this.msisdn);
        }
        if (this.numberPortabilityStatus != null) {
            sb.append(", numberPortabilityStatus=");
            sb.append((Object)this.numberPortabilityStatus);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        sb.append("]");
        return sb.toString();
    }
}

