/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.faultRecovery;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NetworkResource;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ResetRequest;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetRequestImpl
extends MobilityMessageImpl
implements ResetRequest {
    public static final String _PrimitiveName = "ResetRequest";
    private NetworkResource networkResource;
    private ISDNAddressString hlrNumber;
    private ArrayList<IMSI> hlrList;
    private long mapProtocolVersion;

    public ResetRequestImpl(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public ResetRequestImpl(NetworkResource networkResource, ISDNAddressString hlrNumber, ArrayList<IMSI> hlrList, long mapProtocolVersion) {
        this.networkResource = networkResource;
        this.hlrNumber = hlrNumber;
        this.hlrList = hlrList;
        this.mapProtocolVersion = mapProtocolVersion;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    @Override
    public MAPMessageType getMessageType() {
        return MAPMessageType.reset_Request;
    }

    @Override
    public int getOperationCode() {
        return 37;
    }

    @Override
    public NetworkResource getNetworkResource() {
        return this.networkResource;
    }

    @Override
    public ISDNAddressString getHlrNumber() {
        return this.hlrNumber;
    }

    @Override
    public ArrayList<IMSI> getHlrList() {
        return this.hlrList;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ResetRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ResetRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ResetRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ResetRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.networkResource = null;
        this.hlrNumber = null;
        this.hlrList = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 10: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding ResetRequest.networkResource: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int i1 = (int)ais.readInteger();
                            this.networkResource = NetworkResource.getInstance(i1);
                            break;
                        }
                        case 4: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding ResetRequest.hlrNumber: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.hlrNumber = new ISDNAddressStringImpl();
                            ((ISDNAddressStringImpl)this.hlrNumber).decodeAll(ais);
                            break;
                        }
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding ResetRequest.hlrList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            AsnInputStream ais2 = ais.readSequenceStream();
                            this.hlrList = new ArrayList();
                            while (ais2.available() != 0) {
                                int tag2 = ais2.readTag();
                                if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ResetRequest: bad hlrList element tag or tagClass or is not primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                IMSIImpl imsi = new IMSIImpl();
                                imsi.decodeAll(ais2);
                                this.hlrList.add(imsi);
                            }
                            if (this.hlrList.size() >= 1 && this.hlrList.size() <= 50) break block0;
                            throw new MAPParsingComponentException("Error while decoding ResetRequest: Parameter hlrList size must be from 1 to 50, found: " + this.hlrList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        default: {
                            ais.advanceElement();
                            break;
                        }
                    }
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.hlrNumber == null) {
            throw new MAPParsingComponentException("Error while decoding ResetRequest: hlrNumber is mandatory but absent absent", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int posk = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(posk);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ResetRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion == 1L && this.networkResource == null) {
            throw new MAPException("For MAP version 1 networkResource must be present but it is empty");
        }
        if (this.hlrNumber == null) {
            throw new MAPException("hlrNumber must not be null");
        }
        if (this.hlrList != null && (this.hlrList.size() < 1 || this.hlrList.size() > 50)) {
            throw new MAPException("hlrList size must be from 1 to 50, found: " + this.hlrList.size());
        }
        if (this.mapProtocolVersion == 1L) {
            try {
                asnOs.writeInteger(0, 10, this.networkResource.getCode());
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding ResetRequest parameter hlrList", e);
            }
            catch (AsnException e) {
                throw new MAPException("IOException while encoding ResetRequest parameter hlrList", e);
            }
        }
        ((ISDNAddressStringImpl)this.hlrNumber).encodeAll(asnOs);
        if (this.hlrList != null) {
            try {
                asnOs.writeTag(0, false, 16);
                int pos = asnOs.StartContentDefiniteLength();
                for (IMSI imsi : this.hlrList) {
                    ((IMSIImpl)imsi).encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException when encoding ResetRequest parameter hlrList: " + e.getMessage(), e);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.networkResource != null) {
            sb.append("networkResource=");
            sb.append((Object)this.networkResource);
            sb.append(", ");
        }
        if (this.hlrNumber != null) {
            sb.append("hlrNumber=");
            sb.append(this.hlrNumber.toString());
            sb.append(", ");
        }
        if (this.hlrList != null) {
            sb.append("hlrList=[");
            boolean firstItem = true;
            for (IMSI imsi : this.hlrList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(imsi.toString());
            }
            sb.append("], ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

