/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.GSNAddress;
import org.mobicents.protocols.ss7.map.api.primitives.IMEI;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.lsm.AreaEventInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSClientID;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSCodeword;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSPriority;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSPrivacyCheck;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSQoS;
import org.mobicents.protocols.ss7.map.api.service.lsm.LocationType;
import org.mobicents.protocols.ss7.map.api.service.lsm.PeriodicLDRInfo;
import org.mobicents.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.lsm.ReportingPLMNList;
import org.mobicents.protocols.ss7.map.api.service.lsm.SupportedGADShapes;
import org.mobicents.protocols.ss7.map.primitives.GSNAddressImpl;
import org.mobicents.protocols.ss7.map.primitives.IMEIImpl;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.lsm.AreaEventInfoImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSClientIDImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSCodewordImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSPrivacyCheckImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LCSQoSImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LocationTypeImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;
import org.mobicents.protocols.ss7.map.service.lsm.PeriodicLDRInfoImpl;
import org.mobicents.protocols.ss7.map.service.lsm.ReportingPLMNListImpl;
import org.mobicents.protocols.ss7.map.service.lsm.SupportedGADShapesImpl;

public class ProvideSubscriberLocationRequestImpl
extends LsmMessageImpl
implements ProvideSubscriberLocationRequest {
    private static final int _TAG_LCS_CLIENT_ID = 0;
    private static final int _TAG_PRIVACY_OVERRIDE = 1;
    private static final int _TAG_IMSI = 2;
    private static final int _TAG_MSISDN = 3;
    private static final int _TAG_LMSI = 4;
    private static final int _TAG_IMEI = 5;
    private static final int _TAG_LCS_PRIORITY = 6;
    private static final int _TAG_LCS_QOS = 7;
    private static final int _TAG_EXTENSION_CONTAINER = 8;
    private static final int _TAG_SUPPORTED_GAD_SHAPES = 9;
    private static final int _TAG_LCS_REFERENCE_NUMBER = 10;
    private static final int _TAG_LCS_SERVICE_TYPE_ID = 11;
    private static final int _TAG_LCS_CODEWORD = 12;
    private static final int _TAG_LCS_PRIVACY_CHECK = 13;
    private static final int _TAG_AREA_EVENT_INFO = 14;
    private static final int _TAG_H_GMLC_ADDRESS = 15;
    private static final int _TAG_mo_lrShortCircuitIndicator = 16;
    private static final int _TAG_periodicLDRInfo = 17;
    private static final int _TAG_reportingPLMNList = 18;
    public static final String _PrimitiveName = "ProvideSubscriberLocationRequest";
    private LocationType locationType;
    private ISDNAddressString mlcNumber;
    private LCSClientID lcsClientID;
    private boolean privacyOverride;
    private IMSI imsi;
    private ISDNAddressString msisdn;
    private LMSI lmsi;
    private IMEI imei;
    private LCSPriority lcsPriority;
    private LCSQoS lcsQoS;
    private MAPExtensionContainer extensionContainer;
    private SupportedGADShapes supportedGADShapes;
    private Integer lcsReferenceNumber;
    private Integer lcsServiceTypeID;
    private LCSCodeword lcsCodeword;
    private LCSPrivacyCheck lcsPrivacyCheck;
    private AreaEventInfo areaEventInfo;
    private GSNAddress hgmlcAddress;
    private boolean moLrShortCircuitIndicator;
    private PeriodicLDRInfo periodicLDRInfo;
    private ReportingPLMNList reportingPLMNList;

    public ProvideSubscriberLocationRequestImpl() {
    }

    public ProvideSubscriberLocationRequestImpl(LocationType locationType, ISDNAddressString mlcNumber, LCSClientID lcsClientID, boolean privacyOverride, IMSI imsi, ISDNAddressString msisdn, LMSI lmsi, IMEI imei, LCSPriority lcsPriority, LCSQoS lcsQoS, MAPExtensionContainer extensionContainer, SupportedGADShapes supportedGADShapes, Integer lcsReferenceNumber, Integer lcsServiceTypeID, LCSCodeword lcsCodeword, LCSPrivacyCheck lcsPrivacyCheck, AreaEventInfo areaEventInfo, GSNAddress hgmlcAddress, boolean moLrShortCircuitIndicator, PeriodicLDRInfo periodicLDRInfo, ReportingPLMNList reportingPLMNList) {
        this.locationType = locationType;
        this.mlcNumber = mlcNumber;
        this.lcsClientID = lcsClientID;
        this.privacyOverride = privacyOverride;
        this.imsi = imsi;
        this.msisdn = msisdn;
        this.lmsi = lmsi;
        this.imei = imei;
        this.lcsPriority = lcsPriority;
        this.lcsQoS = lcsQoS;
        this.extensionContainer = extensionContainer;
        this.supportedGADShapes = supportedGADShapes;
        this.lcsReferenceNumber = lcsReferenceNumber;
        this.lcsServiceTypeID = lcsServiceTypeID;
        this.lcsCodeword = lcsCodeword;
        this.lcsPrivacyCheck = lcsPrivacyCheck;
        this.areaEventInfo = areaEventInfo;
        this.hgmlcAddress = hgmlcAddress;
        this.moLrShortCircuitIndicator = moLrShortCircuitIndicator;
        this.periodicLDRInfo = periodicLDRInfo;
        this.reportingPLMNList = reportingPLMNList;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.provideSubscriberLocation_Request;
    }

    public int getOperationCode() {
        return 83;
    }

    public LocationType getLocationType() {
        return this.locationType;
    }

    public ISDNAddressString getMlcNumber() {
        return this.mlcNumber;
    }

    public LCSClientID getLCSClientID() {
        return this.lcsClientID;
    }

    public boolean getPrivacyOverride() {
        return this.privacyOverride;
    }

    public IMSI getIMSI() {
        return this.imsi;
    }

    public ISDNAddressString getMSISDN() {
        return this.msisdn;
    }

    public LMSI getLMSI() {
        return this.lmsi;
    }

    public LCSPriority getLCSPriority() {
        return this.lcsPriority;
    }

    public LCSQoS getLCSQoS() {
        return this.lcsQoS;
    }

    public IMEI getIMEI() {
        return this.imei;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public SupportedGADShapes getSupportedGADShapes() {
        return this.supportedGADShapes;
    }

    public Integer getLCSReferenceNumber() {
        return this.lcsReferenceNumber;
    }

    public LCSCodeword getLCSCodeword() {
        return this.lcsCodeword;
    }

    public Integer getLCSServiceTypeID() {
        return this.lcsServiceTypeID;
    }

    public LCSPrivacyCheck getLCSPrivacyCheck() {
        return this.lcsPrivacyCheck;
    }

    public AreaEventInfo getAreaEventInfo() {
        return this.areaEventInfo;
    }

    public GSNAddress getHGMLCAddress() {
        return this.hgmlcAddress;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public boolean getMoLrShortCircuitIndicator() {
        return this.moLrShortCircuitIndicator;
    }

    public PeriodicLDRInfo getPeriodicLDRInfo() {
        return this.periodicLDRInfo;
    }

    public ReportingPLMNList getReportingPLMNList() {
        return this.reportingPLMNList;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ProvideSubscriberLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ProvideSubscriberLocationRequest: ", e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.locationType = null;
        this.mlcNumber = null;
        this.lcsClientID = null;
        this.privacyOverride = false;
        this.imsi = null;
        this.msisdn = null;
        this.lmsi = null;
        this.imei = null;
        this.lcsPriority = null;
        this.lcsQoS = null;
        this.extensionContainer = null;
        this.supportedGADShapes = null;
        this.lcsReferenceNumber = null;
        this.lcsServiceTypeID = null;
        this.lcsCodeword = null;
        this.lcsPrivacyCheck = null;
        this.areaEventInfo = null;
        this.hgmlcAddress = null;
        this.moLrShortCircuitIndicator = false;
        this.periodicLDRInfo = null;
        this.reportingPLMNList = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || ais.isTagPrimitive() || tag != 16) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest.locationType: Parameter has bad tag or tag class or is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.locationType = new LocationTypeImpl();
                    ((LocationTypeImpl)this.locationType).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest.mlcNumber: Parameter has bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.mlcNumber = new ISDNAddressStringImpl();
                    ((ISDNAddressStringImpl)this.mlcNumber).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 0: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcs-ClientID [0] LCS-ClientID] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsClientID = new LCSClientIDImpl();
                                ((LCSClientIDImpl)this.lcsClientID).decodeAll(ais);
                                break block0;
                            }
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [privacyOverride [1] NULL ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.privacyOverride = true;
                                break block0;
                            }
                            case 2: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [imsi [2] IMSI ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.imsi = new IMSIImpl();
                                ((IMSIImpl)this.imsi).decodeAll(ais);
                                break block0;
                            }
                            case 3: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [msisdn [3] ISDN-AddressString ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.msisdn = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.msisdn).decodeAll(ais);
                                break block0;
                            }
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lmsi [4] LMSI ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lmsi = new LMSIImpl();
                                ((LMSIImpl)this.lmsi).decodeAll(ais);
                                break block0;
                            }
                            case 5: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [imei [5] IMEI ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.imei = new IMEIImpl();
                                ((IMEIImpl)this.imei).decodeAll(ais);
                                break block0;
                            }
                            case 6: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcs-Priority [6] LCS-Priority ] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsPriority = LCSPriority.getInstance(ais.readOctetString()[0]);
                                break block0;
                            }
                            case 7: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcs-QoS [7] LCS-QoS ] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsQoS = new LCSQoSImpl();
                                ((LCSQoSImpl)this.lcsQoS).decodeAll(ais);
                                break block0;
                            }
                            case 8: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break block0;
                            }
                            case 9: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [supportedGADShapes [9] SupportedGADShapes] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.supportedGADShapes = new SupportedGADShapesImpl();
                                ((SupportedGADShapesImpl)this.supportedGADShapes).decodeAll(ais);
                                break block0;
                            }
                            case 10: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcs-ReferenceNumber [10] LCS-ReferenceNumber] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsReferenceNumber = ais.readOctetString()[0];
                                break block0;
                            }
                            case 11: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcsServiceTypeID [11] LCSServiceTypeID] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsServiceTypeID = (int)ais.readInteger();
                                break block0;
                            }
                            case 12: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcsCodeword [12] LCSCodeword] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsCodeword = new LCSCodewordImpl();
                                ((LCSCodewordImpl)this.lcsCodeword).decodeAll(ais);
                                break block0;
                            }
                            case 13: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [lcs-PrivacyCheck [13] LCS-PrivacyCheck] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.lcsPrivacyCheck = new LCSPrivacyCheckImpl();
                                ((LCSPrivacyCheckImpl)this.lcsPrivacyCheck).decodeAll(ais);
                                break block0;
                            }
                            case 14: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [areaEventInfo [14] AreaEventInfo] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.areaEventInfo = new AreaEventInfoImpl();
                                ((AreaEventInfoImpl)this.areaEventInfo).decodeAll(ais);
                                break block0;
                            }
                            case 15: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter [h-gmlc-Address [15] GSN-Address] is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.hgmlcAddress = new GSNAddressImpl();
                                ((GSNAddressImpl)this.hgmlcAddress).decodeAll(ais);
                                break block0;
                            }
                            case 16: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter mo_lrShortCircuitIndicator is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.moLrShortCircuitIndicator = true;
                                break block0;
                            }
                            case 17: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter periodicLDRInfo is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.periodicLDRInfo = new PeriodicLDRInfoImpl();
                                ((PeriodicLDRInfoImpl)this.periodicLDRInfo).decodeAll(ais);
                                break block0;
                            }
                            case 18: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Parameter reportingPLMNList is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.reportingPLMNList = new ReportingPLMNListImpl();
                                ((ReportingPLMNListImpl)this.reportingPLMNList).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 2) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberLocationRequest: Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ProvideSubscriberLocationRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.locationType == null) {
            throw new MAPException("Error while encoding ProvideSubscriberLocationRequest the mandatory parameter locationType is not defined");
        }
        if (this.mlcNumber == null) {
            throw new MAPException("Error while encoding ProvideSubscriberLocationRequest the mandatory parameter mlc-Number is not defined");
        }
        ((LocationTypeImpl)this.locationType).encodeAll(asnOs);
        ((ISDNAddressStringImpl)this.mlcNumber).encodeAll(asnOs);
        if (this.lcsClientID != null) {
            ((LCSClientIDImpl)this.lcsClientID).encodeAll(asnOs, 2, 0);
        }
        if (this.privacyOverride) {
            try {
                asnOs.writeNull(2, 1);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding ProvideSubscriberLocationRequest parameter privacyOverride", e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding ProvideSubscriberLocationRequest parameter privacyOverride", e);
            }
        }
        if (this.imsi != null) {
            ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 2);
        }
        if (this.msisdn != null) {
            ((ISDNAddressStringImpl)this.msisdn).encodeAll(asnOs, 2, 3);
        }
        if (this.lmsi != null) {
            ((LMSIImpl)this.lmsi).encodeAll(asnOs, 2, 4);
        }
        if (this.imei != null) {
            ((IMEIImpl)this.imei).encodeAll(asnOs, 2, 5);
        }
        if (this.lcsPriority != null) {
            try {
                asnOs.writeOctetString(2, 6, new byte[]{(byte)this.lcsPriority.getCode()});
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding ProvideSubscriberLocationRequest parameter lcsPriority", e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding ProvideSubscriberLocationRequest parameter lcsPriority", e);
            }
        }
        if (this.lcsQoS != null) {
            ((LCSQoSImpl)this.lcsQoS).encodeAll(asnOs, 2, 7);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 8);
        }
        if (this.supportedGADShapes != null) {
            ((SupportedGADShapesImpl)this.supportedGADShapes).encodeAll(asnOs, 2, 9);
        }
        if (this.lcsReferenceNumber != null) {
            try {
                asnOs.writeOctetString(2, 10, new byte[]{this.lcsReferenceNumber.byteValue()});
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding ProvideSubscriberLocationRequest parameter lcsReferenceNumber", e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding ProvideSubscriberLocationRequest parameter lcsReferenceNumber", e);
            }
        }
        if (this.lcsServiceTypeID != null) {
            try {
                asnOs.writeInteger(2, 11, this.lcsServiceTypeID.intValue());
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding ProvideSubscriberLocationRequest parameter lcsReferenceNumber", e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding ProvideSubscriberLocationRequest parameter lcsReferenceNumber", e);
            }
        }
        if (this.lcsCodeword != null) {
            ((LCSCodewordImpl)this.lcsCodeword).encodeAll(asnOs, 2, 12);
        }
        if (this.lcsPrivacyCheck != null) {
            ((LCSPrivacyCheckImpl)this.lcsPrivacyCheck).encodeAll(asnOs, 2, 13);
        }
        if (this.areaEventInfo != null) {
            ((AreaEventInfoImpl)this.areaEventInfo).encodeAll(asnOs, 2, 14);
        }
        if (this.hgmlcAddress != null) {
            ((GSNAddressImpl)this.hgmlcAddress).encodeAll(asnOs, 2, 15);
        }
        if (this.moLrShortCircuitIndicator) {
            try {
                asnOs.writeNull(2, 16);
            }
            catch (IOException e) {
                throw new MAPException("IOException while encoding ProvideSubscriberLocationRequest parameter moLrShortCircuitIndicator", e);
            }
            catch (AsnException e) {
                throw new MAPException("AsnException while encoding ProvideSubscriberLocationRequest parameter moLrShortCircuitIndicator", e);
            }
        }
        if (this.periodicLDRInfo != null) {
            ((PeriodicLDRInfoImpl)this.periodicLDRInfo).encodeAll(asnOs, 2, 17);
        }
        if (this.reportingPLMNList != null) {
            ((ReportingPLMNListImpl)this.reportingPLMNList).encodeAll(asnOs, 2, 18);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.locationType != null) {
            sb.append("locationType=");
            sb.append(this.locationType.toString());
        }
        if (this.mlcNumber != null) {
            sb.append(", mlcNumber=");
            sb.append(this.mlcNumber.toString());
        }
        if (this.lcsClientID != null) {
            sb.append(", lcsClientID=");
            sb.append(this.lcsClientID.toString());
        }
        if (this.privacyOverride) {
            sb.append(", privacyOverride");
        }
        if (this.imsi != null) {
            sb.append(", imsi=");
            sb.append(this.imsi.toString());
        }
        if (this.msisdn != null) {
            sb.append(", msisdn=");
            sb.append(this.msisdn.toString());
        }
        if (this.lmsi != null) {
            sb.append(", lmsi=");
            sb.append(this.lmsi.toString());
        }
        if (this.imei != null) {
            sb.append(", imei=");
            sb.append(this.imei.toString());
        }
        if (this.lcsPriority != null) {
            sb.append(", lcsPriority=");
            sb.append(this.lcsPriority.toString());
        }
        if (this.lcsQoS != null) {
            sb.append(", lcsQoS=");
            sb.append(this.lcsQoS.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        if (this.supportedGADShapes != null) {
            sb.append(", supportedGADShapes=");
            sb.append(this.supportedGADShapes.toString());
        }
        if (this.lcsReferenceNumber != null) {
            sb.append(", lcsReferenceNumber=");
            sb.append(this.lcsReferenceNumber.toString());
        }
        if (this.lcsServiceTypeID != null) {
            sb.append(", lcsServiceTypeID=");
            sb.append(this.lcsServiceTypeID.toString());
        }
        if (this.lcsCodeword != null) {
            sb.append(", lcsCodeword=");
            sb.append(this.lcsCodeword.toString());
        }
        if (this.lcsPrivacyCheck != null) {
            sb.append(", lcsPrivacyCheck=");
            sb.append(this.lcsPrivacyCheck.toString());
        }
        if (this.areaEventInfo != null) {
            sb.append(", areaEventInfo=");
            sb.append(this.areaEventInfo.toString());
        }
        if (this.hgmlcAddress != null) {
            sb.append(", hgmlcAddress=");
            sb.append(this.hgmlcAddress.toString());
        }
        if (this.moLrShortCircuitIndicator) {
            sb.append(", moLrShortCircuitIndicator");
        }
        if (this.periodicLDRInfo != null) {
            sb.append(", periodicLDRInfo=");
            sb.append(this.periodicLDRInfo.toString());
        }
        if (this.reportingPLMNList != null) {
            sb.append(", reportingPLMNList=");
            sb.append(this.reportingPLMNList.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

