/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.restcomm.protocols.ss7.tcap.api.tc.component.InvokeClass;
import org.restcomm.protocols.ss7.tcap.asn.AbortSource;
import org.restcomm.protocols.ss7.tcap.asn.AbortSourceImpl;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextNameImpl;
import org.restcomm.protocols.ss7.tcap.asn.DialogAPDU;
import org.restcomm.protocols.ss7.tcap.asn.DialogAbortAPDU;
import org.restcomm.protocols.ss7.tcap.asn.DialogAbortAPDUImpl;
import org.restcomm.protocols.ss7.tcap.asn.DialogPortion;
import org.restcomm.protocols.ss7.tcap.asn.DialogPortionImpl;
import org.restcomm.protocols.ss7.tcap.asn.DialogRequestAPDU;
import org.restcomm.protocols.ss7.tcap.asn.DialogRequestAPDUImpl;
import org.restcomm.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.restcomm.protocols.ss7.tcap.asn.DialogResponseAPDUImpl;
import org.restcomm.protocols.ss7.tcap.asn.DialogUniAPDU;
import org.restcomm.protocols.ss7.tcap.asn.DialogUniAPDUImpl;
import org.restcomm.protocols.ss7.tcap.asn.ErrorCodeImpl;
import org.restcomm.protocols.ss7.tcap.asn.InvokeImpl;
import org.restcomm.protocols.ss7.tcap.asn.OperationCodeImpl;
import org.restcomm.protocols.ss7.tcap.asn.ParameterImpl;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.ProblemImpl;
import org.restcomm.protocols.ss7.tcap.asn.ProtocolVersion;
import org.restcomm.protocols.ss7.tcap.asn.ProtocolVersionImpl;
import org.restcomm.protocols.ss7.tcap.asn.RejectImpl;
import org.restcomm.protocols.ss7.tcap.asn.Result;
import org.restcomm.protocols.ss7.tcap.asn.ResultImpl;
import org.restcomm.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.restcomm.protocols.ss7.tcap.asn.ResultSourceDiagnosticImpl;
import org.restcomm.protocols.ss7.tcap.asn.ReturnErrorImpl;
import org.restcomm.protocols.ss7.tcap.asn.ReturnResultImpl;
import org.restcomm.protocols.ss7.tcap.asn.ReturnResultLastImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCAbortMessageImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCBeginMessageImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCContinueMessageImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCEndMessageImpl;
import org.restcomm.protocols.ss7.tcap.asn.TCUniMessageImpl;
import org.restcomm.protocols.ss7.tcap.asn.UserInformation;
import org.restcomm.protocols.ss7.tcap.asn.UserInformationImpl;
import org.restcomm.protocols.ss7.tcap.asn.comp.Component;
import org.restcomm.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.restcomm.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.restcomm.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.restcomm.protocols.ss7.tcap.asn.comp.Invoke;
import org.restcomm.protocols.ss7.tcap.asn.comp.OperationCode;
import org.restcomm.protocols.ss7.tcap.asn.comp.OperationCodeType;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.restcomm.protocols.ss7.tcap.asn.comp.Parameter;
import org.restcomm.protocols.ss7.tcap.asn.comp.Problem;
import org.restcomm.protocols.ss7.tcap.asn.comp.ProblemType;
import org.restcomm.protocols.ss7.tcap.asn.comp.Reject;
import org.restcomm.protocols.ss7.tcap.asn.comp.ReturnError;
import org.restcomm.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.restcomm.protocols.ss7.tcap.asn.comp.ReturnResultLast;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCUniMessage;

public final class TcapFactory {
    public static DialogPortion createDialogPortion(AsnInputStream ais) throws ParseException {
        DialogPortionImpl dpi = new DialogPortionImpl();
        dpi.decode(ais);
        return dpi;
    }

    public static DialogPortion createDialogPortion() {
        return new DialogPortionImpl();
    }

    public static DialogAPDU createDialogAPDU(AsnInputStream ais, int tag, boolean unidirectional) throws ParseException {
        if (ais.getTagClass() != 1) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "Error decoding dialog APDU: wrong tag class for APDU, found: " + ais.getTagClass());
        }
        if (unidirectional) {
            if (tag != 0) {
                throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "Error decoding dialog APDU: wrong tag for APDU, found: " + tag);
            }
            DialogUniAPDUImpl d = new DialogUniAPDUImpl();
            d.decode(ais);
            return d;
        }
        if (tag == 0) {
            DialogRequestAPDUImpl d = new DialogRequestAPDUImpl();
            d.decode(ais);
            return d;
        }
        if (tag == 1) {
            DialogResponseAPDUImpl d = new DialogResponseAPDUImpl();
            d.decode(ais);
            return d;
        }
        if (tag == 4) {
            DialogAbortAPDUImpl da = new DialogAbortAPDUImpl();
            da.decode(ais);
            return da;
        }
        throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "Wrong tag for APDU, found: " + tag);
    }

    public static DialogRequestAPDU createDialogAPDURequest() {
        return new DialogRequestAPDUImpl();
    }

    public static DialogResponseAPDU createDialogAPDUResponse() {
        return new DialogResponseAPDUImpl();
    }

    public static DialogUniAPDU createDialogAPDUUni() {
        return new DialogUniAPDUImpl();
    }

    public static DialogAbortAPDU createDialogAPDUAbort() {
        return new DialogAbortAPDUImpl();
    }

    public static ProtocolVersion createProtocolVersion() {
        return new ProtocolVersionImpl();
    }

    public static ProtocolVersion createProtocolVersion(AsnInputStream ais) throws ParseException {
        ProtocolVersionImpl pv = new ProtocolVersionImpl();
        pv.decode(ais);
        return pv;
    }

    public static ApplicationContextName createApplicationContextName(long[] oid) {
        ApplicationContextNameImpl acn = new ApplicationContextNameImpl();
        acn.setOid(oid);
        return acn;
    }

    public static ApplicationContextName createApplicationContextName(AsnInputStream ais) throws ParseException {
        ApplicationContextNameImpl acn = new ApplicationContextNameImpl();
        acn.decode(ais);
        return acn;
    }

    public static UserInformation createUserInformation() {
        return new UserInformationImpl();
    }

    public static UserInformation createUserInformation(AsnInputStream localAis) throws ParseException {
        UserInformationImpl ui = new UserInformationImpl();
        ui.decode(localAis);
        return ui;
    }

    public static Result createResult() {
        return new ResultImpl();
    }

    public static Result createResult(AsnInputStream localAis) throws ParseException {
        ResultImpl ui = new ResultImpl();
        ui.decode(localAis);
        return ui;
    }

    public static ResultSourceDiagnostic createResultSourceDiagnostic() {
        return new ResultSourceDiagnosticImpl();
    }

    public static ResultSourceDiagnostic createResultSourceDiagnostic(AsnInputStream localAis) throws ParseException {
        ResultSourceDiagnosticImpl ui = new ResultSourceDiagnosticImpl();
        ui.decode(localAis);
        return ui;
    }

    public static AbortSource createAbortSource() {
        AbortSourceImpl as = new AbortSourceImpl();
        return as;
    }

    public static AbortSource createAbortSource(AsnInputStream localAis) throws ParseException {
        AbortSourceImpl as = new AbortSourceImpl();
        as.decode(localAis);
        return as;
    }

    public static TCUniMessage createTCUniMessage(AsnInputStream localAis) throws ParseException {
        TCUniMessageImpl tc = new TCUniMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCUniMessage createTCUniMessage() {
        TCUniMessageImpl tc = new TCUniMessageImpl();
        return tc;
    }

    public static TCContinueMessage createTCContinueMessage(AsnInputStream localAis) throws ParseException {
        TCContinueMessageImpl tc = new TCContinueMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCContinueMessage createTCContinueMessage() {
        TCContinueMessageImpl tc = new TCContinueMessageImpl();
        return tc;
    }

    public static TCEndMessage createTCEndMessage(AsnInputStream localAis) throws ParseException {
        TCEndMessageImpl tc = new TCEndMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCEndMessage createTCEndMessage() {
        TCEndMessageImpl tc = new TCEndMessageImpl();
        return tc;
    }

    public static TCAbortMessage createTCAbortMessage(AsnInputStream localAis) throws ParseException {
        TCAbortMessageImpl tc = new TCAbortMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCAbortMessage createTCAbortMessage() {
        TCAbortMessageImpl tc = new TCAbortMessageImpl();
        return tc;
    }

    public static TCBeginMessage createTCBeginMessage(AsnInputStream localAis) throws ParseException {
        TCBeginMessageImpl tc = new TCBeginMessageImpl();
        tc.decode(localAis);
        return tc;
    }

    public static TCBeginMessage createTCBeginMessage() {
        TCBeginMessageImpl tc = new TCBeginMessageImpl();
        return tc;
    }

    public static OperationCode createOperationCode() {
        OperationCodeImpl oc = new OperationCodeImpl();
        return oc;
    }

    public static OperationCode createOperationCode(int tag, AsnInputStream localAis) throws ParseException {
        OperationCodeImpl oc = new OperationCodeImpl();
        oc.setOperationType(6 == tag ? OperationCodeType.Global : OperationCodeType.Local);
        oc.decode(localAis);
        return oc;
    }

    public static Parameter createParameter() {
        ParameterImpl p = new ParameterImpl();
        return p;
    }

    public static Parameter createParameter(int tag, AsnInputStream localAis, boolean singleParameterInAsn) throws ParseException {
        ParameterImpl p = new ParameterImpl();
        p.setTag(tag);
        if (singleParameterInAsn) {
            p.setSingleParameterInAsn();
        }
        p.decode(localAis);
        return p;
    }

    public static Component createComponent(AsnInputStream localAis) throws ParseException {
        try {
            try {
                int tag = localAis.readTag();
                Component c = null;
                if (localAis.getTagClass() != 2) {
                    throw new ParseException(null, GeneralProblemType.UnrecognizedComponent, "Error decoding a component: bad tag class: " + localAis.getTagClass());
                }
                switch (tag) {
                    case 1: {
                        c = TcapFactory.createComponentInvoke();
                        c.decode(localAis);
                        break;
                    }
                    case 7: {
                        c = TcapFactory.createComponentReturnResult();
                        c.decode(localAis);
                        break;
                    }
                    case 2: {
                        c = TcapFactory.createComponentReturnResultLast();
                        c.decode(localAis);
                        break;
                    }
                    case 3: {
                        c = TcapFactory.createComponentReturnError();
                        c.decode(localAis);
                        break;
                    }
                    case 4: {
                        c = TcapFactory.createComponentReject();
                        c.decode(localAis);
                        break;
                    }
                    default: {
                        localAis.advanceElement();
                        throw new ParseException(null, GeneralProblemType.UnrecognizedComponent, "Error decoding a component: bad tag: " + tag);
                    }
                }
                return c;
            }
            catch (IOException e) {
                throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding a component: " + e.getMessage(), e);
            }
            catch (AsnException e) {
                throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding a component: " + e.getMessage(), e);
            }
        }
        catch (ParseException e) {
            if (e.getProblem() != null) {
                Reject rej = TcapFactory.createComponentReject();
                rej.setLocalOriginated(true);
                rej.setInvokeId(e.getInvokeId());
                ProblemImpl problem = new ProblemImpl();
                problem.setGeneralProblemType(e.getProblem());
                rej.setProblem(problem);
                return rej;
            }
            throw e;
        }
    }

    public static Reject createComponentReject() {
        return new RejectImpl();
    }

    public static ReturnResultLast createComponentReturnResultLast() {
        return new ReturnResultLastImpl();
    }

    public static ReturnResult createComponentReturnResult() {
        return new ReturnResultImpl();
    }

    public static Invoke createComponentInvoke() {
        return new InvokeImpl();
    }

    public static Invoke createComponentInvoke(InvokeClass invokeClass) {
        return new InvokeImpl(invokeClass);
    }

    public static ReturnError createComponentReturnError() {
        return new ReturnErrorImpl();
    }

    public static Problem createProblem(ProblemType pt, AsnInputStream ais) throws ParseException {
        Problem p = TcapFactory.createProblem(pt);
        p.decode(ais);
        return p;
    }

    public static Problem createProblem(ProblemType pt) {
        ProblemImpl p = new ProblemImpl();
        p.setType(pt);
        return p;
    }

    public static ErrorCode createErrorCode(int tag, AsnInputStream ais) throws ParseException {
        ErrorCode p = TcapFactory.createErrorCode();
        ((ErrorCodeImpl)p).setErrorCodeType(6 == tag ? ErrorCodeType.Global : ErrorCodeType.Local);
        p.decode(ais);
        return p;
    }

    public static ErrorCode createErrorCode() {
        ErrorCodeImpl p = new ErrorCodeImpl();
        return p;
    }
}

