/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.restcomm.protocols.ss7.tcap.asn.comp.InvokeProblemType;
import org.restcomm.protocols.ss7.tcap.asn.comp.Problem;
import org.restcomm.protocols.ss7.tcap.asn.comp.ProblemType;
import org.restcomm.protocols.ss7.tcap.asn.comp.ReturnErrorProblemType;
import org.restcomm.protocols.ss7.tcap.asn.comp.ReturnResultProblemType;

public class ProblemImpl
implements Problem {
    private static final String PROBLEM_TYPE = "problemType";
    private static final String PROBLEM_GENERAL = "problemGeneral";
    private static final String PROBLEM_INVOKE = "problemInvoke";
    private static final String PROBLEM_RETURN_ERROR = "problemReturnError";
    private static final String PROBLEM_RETURN_RESULT = "problemReturnResult";
    private ProblemType type;
    private GeneralProblemType generalProblemType;
    private InvokeProblemType invokeProblemType;
    private ReturnErrorProblemType returnErrorProblemType;
    private ReturnResultProblemType returnResultProblemType;
    protected static final XMLFormat<ProblemImpl> PROBLEM_BARRED_XML = new XMLFormat<ProblemImpl>(ProblemImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, ProblemImpl problem) throws XMLStreamException {
            String val = xml.getAttribute(ProblemImpl.PROBLEM_TYPE, "");
            problem.type = Enum.valueOf(ProblemType.class, val);
            switch (problem.type) {
                case General: {
                    val = xml.get(ProblemImpl.PROBLEM_GENERAL, String.class);
                    problem.generalProblemType = Enum.valueOf(GeneralProblemType.class, val);
                    break;
                }
                case Invoke: {
                    val = xml.get(ProblemImpl.PROBLEM_INVOKE, String.class);
                    problem.invokeProblemType = Enum.valueOf(InvokeProblemType.class, val);
                    break;
                }
                case ReturnResult: {
                    val = xml.get(ProblemImpl.PROBLEM_RETURN_RESULT, String.class);
                    problem.returnResultProblemType = Enum.valueOf(ReturnResultProblemType.class, val);
                    break;
                }
                case ReturnError: {
                    val = xml.get(ProblemImpl.PROBLEM_RETURN_ERROR, String.class);
                    problem.returnErrorProblemType = Enum.valueOf(ReturnErrorProblemType.class, val);
                }
            }
        }

        @Override
        public void write(ProblemImpl problem, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ProblemImpl.PROBLEM_TYPE, problem.type.toString());
            switch (problem.type) {
                case General: {
                    xml.add(problem.generalProblemType.toString(), ProblemImpl.PROBLEM_GENERAL, String.class);
                    break;
                }
                case Invoke: {
                    xml.add(problem.invokeProblemType.toString(), ProblemImpl.PROBLEM_INVOKE, String.class);
                    break;
                }
                case ReturnResult: {
                    xml.add(problem.returnResultProblemType.toString(), ProblemImpl.PROBLEM_RETURN_RESULT, String.class);
                    break;
                }
                case ReturnError: {
                    xml.add(problem.returnErrorProblemType.toString(), ProblemImpl.PROBLEM_RETURN_ERROR, String.class);
                }
            }
        }
    };

    @Override
    public ProblemType getType() {
        return this.type;
    }

    @Override
    public void setType(ProblemType type) {
        this.type = type;
    }

    @Override
    public GeneralProblemType getGeneralProblemType() {
        return this.generalProblemType;
    }

    @Override
    public void setGeneralProblemType(GeneralProblemType generalProblemType) {
        this.generalProblemType = generalProblemType;
        this.setType(ProblemType.General);
    }

    @Override
    public InvokeProblemType getInvokeProblemType() {
        return this.invokeProblemType;
    }

    @Override
    public void setInvokeProblemType(InvokeProblemType invokeProblemType) {
        this.setType(ProblemType.Invoke);
        this.invokeProblemType = invokeProblemType;
    }

    @Override
    public ReturnErrorProblemType getReturnErrorProblemType() {
        return this.returnErrorProblemType;
    }

    @Override
    public void setReturnErrorProblemType(ReturnErrorProblemType returnErrorProblemType) {
        this.returnErrorProblemType = returnErrorProblemType;
        this.setType(ProblemType.ReturnError);
    }

    @Override
    public ReturnResultProblemType getReturnResultProblemType() {
        return this.returnResultProblemType;
    }

    @Override
    public void setReturnResultProblemType(ReturnResultProblemType returnResultProblemType) {
        this.returnResultProblemType = returnResultProblemType;
        this.setType(ProblemType.ReturnResult);
    }

    public String getStringValue() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case General: {
                sb.append("generalProblemType=");
                sb.append((Object)this.generalProblemType);
                break;
            }
            case Invoke: {
                sb.append("invokeProblemType=");
                sb.append((Object)this.invokeProblemType);
                break;
            }
            case ReturnResult: {
                sb.append("returnResultProblemType=");
                sb.append((Object)this.returnResultProblemType);
                break;
            }
            case ReturnError: {
                sb.append("returnErrorProblemType=");
                sb.append((Object)this.returnErrorProblemType);
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Problem[type=");
        sb.append((Object)this.type);
        sb.append(" ");
        switch (this.type) {
            case General: {
                sb.append("generalProblemType=");
                sb.append((Object)this.generalProblemType);
                break;
            }
            case Invoke: {
                sb.append("invokeProblemType=");
                sb.append((Object)this.invokeProblemType);
                break;
            }
            case ReturnResult: {
                sb.append("returnResultProblemType=");
                sb.append((Object)this.returnResultProblemType);
                break;
            }
            case ReturnError: {
                sb.append("returnErrorProblemType=");
                sb.append((Object)this.returnErrorProblemType);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            long t = ais.readInteger();
            switch (this.type) {
                case General: {
                    this.generalProblemType = GeneralProblemType.getFromInt(t);
                    break;
                }
                case Invoke: {
                    this.invokeProblemType = InvokeProblemType.getFromInt(t);
                    break;
                }
                case ReturnError: {
                    this.returnErrorProblemType = ReturnErrorProblemType.getFromInt(t);
                    break;
                }
                case ReturnResult: {
                    this.returnResultProblemType = ReturnResultProblemType.getFromInt(t);
                    break;
                }
                default: {
                    throw new ParseException(null, GeneralProblemType.MistypedComponent);
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding Problem: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding Problem: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        try {
            switch (this.type) {
                case General: {
                    if (this.generalProblemType == null) {
                        throw new EncodeException("Problem Type is General, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.generalProblemType.getType());
                    break;
                }
                case Invoke: {
                    if (this.invokeProblemType == null) {
                        throw new EncodeException("Problem Type is Invoke, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.invokeProblemType.getType());
                    break;
                }
                case ReturnError: {
                    if (this.returnErrorProblemType == null) {
                        throw new EncodeException("Problem Type is ReturnError, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.returnErrorProblemType.getType());
                    break;
                }
                case ReturnResult: {
                    if (this.returnResultProblemType == null) {
                        throw new EncodeException("Problem Type is Result, no specific type set");
                    }
                    aos.writeInteger(2, (int)this.type.getTypeTag(), this.returnResultProblemType.getType());
                    break;
                }
                default: {
                    throw new EncodeException();
                }
            }
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding Problem: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding Problem: " + e.getMessage(), e);
        }
    }
}

