/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import org.restcomm.protocols.ss7.sccp.parameter.SequenceNumber;

public class SequenceNumberImpl
implements SequenceNumber {
    public static final int DIVISOR = 128;
    private final byte value;
    private boolean nextValueIsZero;

    public SequenceNumberImpl(int value) {
        this(value, false);
    }

    public SequenceNumberImpl(int value, boolean truncate) {
        this(value, truncate, false);
    }

    public SequenceNumberImpl(int value, boolean truncate, boolean nextValueIsZero) {
        if (!truncate) {
            if (value > 127 || value < 0) {
                throw new IllegalArgumentException();
            }
            this.value = (byte)value;
        } else {
            this.value = (byte)(value % 128);
        }
        if (nextValueIsZero) {
            this.nextValueIsZero = nextValueIsZero;
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public SequenceNumber nextNumber() {
        SequenceNumberImpl newValue = this.nextValueIsZero ? new SequenceNumberImpl(0) : (this.value + 1 > 127 ? new SequenceNumberImpl(0) : new SequenceNumberImpl(this.value + 1));
        return newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceNumberImpl that = (SequenceNumberImpl)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SequenceNumber [value=");
        sb.append(this.value);
        sb.append("]");
        return sb.toString();
    }
}

