/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SegmentationImpl;
import org.restcomm.protocols.ss7.sccp.parameter.HopCounter;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;
import org.restcomm.protocols.ss7.sccp.parameter.Segmentation;

public abstract class SccpSegmentableMessageImpl
extends SccpAddressedMessageImpl {
    protected byte[] data;
    protected SegmentationImpl segmentation;
    protected boolean isFullyRecieved;
    protected int remainingSegments;
    protected ByteArrayOutputStream buffer;
    protected SccpStackImpl.MessageReassemblyProcess mrp;

    protected SccpSegmentableMessageImpl(int maxDataLen, int type, int outgoingSls, int localSsn, SccpAddress calledParty, SccpAddress callingParty, byte[] data, HopCounter hopCounter) {
        super(maxDataLen, type, outgoingSls, localSsn, calledParty, callingParty, hopCounter);
        this.data = data;
        this.isFullyRecieved = true;
    }

    protected SccpSegmentableMessageImpl(int maxDataLen, int type, int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(maxDataLen, type, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public boolean getIsFullyRecieved() {
        return this.isFullyRecieved;
    }

    public int getRemainingSegments() {
        return this.remainingSegments;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setReceivedSingleSegment() {
        this.isFullyRecieved = true;
    }

    public void setReceivedFirstSegment() {
        if (this.segmentation == null) {
            return;
        }
        this.remainingSegments = this.segmentation.getRemainingSegments();
        this.buffer = new ByteArrayOutputStream(this.data.length * (this.remainingSegments + 1));
        try {
            this.buffer.write(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setReceivedNextSegment(SccpSegmentableMessageImpl nextSegement) {
        try {
            this.buffer.write(nextSegement.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (--this.remainingSegments == 0) {
            this.data = this.buffer.toByteArray();
            this.isFullyRecieved = true;
        }
    }

    public void cancelSegmentation() {
        this.remainingSegments = -1;
        this.isFullyRecieved = false;
    }

    public SccpStackImpl.MessageReassemblyProcess getMessageReassemblyProcess() {
        return this.mrp;
    }

    public void setMessageReassemblyProcess(SccpStackImpl.MessageReassemblyProcess mrp) {
        this.mrp = mrp;
    }
}

