/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpDataNoticeTemplateMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ReturnCauseImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.restcomm.protocols.ss7.sccp.parameter.HopCounter;
import org.restcomm.protocols.ss7.sccp.parameter.Importance;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCause;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpNoticeMessageImpl
extends SccpDataNoticeTemplateMessageImpl
implements SccpNoticeMessage {
    protected ReturnCause returnCause;

    protected SccpNoticeMessageImpl(int maxDataLen, int type, ReturnCause returnCause, SccpAddress calledParty, SccpAddress callingParty, byte[] data, HopCounter hopCounter, Importance importance) {
        super(maxDataLen, type, 0, -1, calledParty, callingParty, data, hopCounter, importance);
        this.returnCause = returnCause;
    }

    protected SccpNoticeMessageImpl(int maxDataLen, int type, int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(maxDataLen, type, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public ReturnCause getReturnCause() {
        return this.returnCause;
    }

    @Override
    public void setReturnCause(ReturnCause rc) {
        this.returnCause = rc;
    }

    @Override
    public boolean getReturnMessageOnError() {
        return false;
    }

    @Override
    public void clearReturnMessageOnError() {
    }

    @Override
    public boolean getSccpCreatesSls() {
        return true;
    }

    @Override
    protected boolean getSecondParamaterPresent() {
        return this.returnCause != null;
    }

    @Override
    protected byte[] getSecondParamaterData(boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return ((AbstractParameter)((Object)this.returnCause)).encode(removeSPC, sccpProtocolVersion);
    }

    @Override
    protected void setSecondParamaterData(int data, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.returnCause = new ReturnCauseImpl(ReturnCauseValue.getInstance(data));
    }

    @Override
    protected boolean getIsProtocolClass1() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Sccp Msg [Type=");
        switch (this.type) {
            case 10: {
                sb.append("UDTS");
                break;
            }
            case 18: {
                sb.append("XUDTS");
                break;
            }
            case 20: {
                sb.append("LUDTS");
                break;
            }
            default: {
                sb.append(this.type);
            }
        }
        sb.append(" networkId=").append(this.networkId).append(" sls=").append(this.sls).append(" returnCause=").append(this.returnCause).append(" incomingOpc=").append(this.incomingOpc).append(" incomingDpc=").append(this.incomingDpc).append(" outgoingDpc=").append(this.outgoingDpc).append(" CallingAddress(").append(this.callingParty).append(") CalledParty(").append(this.calledParty).append(")");
        sb.append(" DataLen=");
        if (this.data != null) {
            sb.append(this.data.length);
        }
        return sb.toString();
    }
}

