/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.io.IOException;
import org.restcomm.protocols.ss7.sccp.SccpConnectionState;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionWithSegmentingImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCrefMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt1MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt2MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnErrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRlcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRlsdMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRscMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRsrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;

public abstract class SccpConnectionWithCouplingImpl
extends SccpConnectionWithSegmentingImpl {
    protected SccpConnectionWithCouplingImpl nextConn;
    private boolean couplingEnabled;

    public SccpConnectionWithCouplingImpl(int sls, int localSsn, LocalReference localReference, ProtocolClass protocol, SccpStackImpl stack, SccpRoutingControl sccpRoutingControl) {
        super(sls, localSsn, localReference, protocol, stack, sccpRoutingControl);
    }

    @Override
    protected void receiveMessage(SccpConnMessage message) throws Exception {
        super.receiveMessage(message);
        if (this.couplingEnabled) {
            if (message instanceof SccpConnCcMessageImpl) {
                SccpConnCcMessageImpl cc = (SccpConnCcMessageImpl)message;
                this.nextConn.confirm(cc.getCalledPartyAddress(), cc.getCredit(), cc.getUserData());
            } else if (message instanceof SccpConnCrefMessageImpl) {
                SccpConnCrefMessageImpl cref = (SccpConnCrefMessageImpl)message;
                SccpConnCrefMessageImpl copy = new SccpConnCrefMessageImpl(this.nextConn.getSls(), this.nextConn.getLocalSsn());
                copy.setSourceLocalReferenceNumber(this.nextConn.getLocalReference());
                copy.setDestinationLocalReferenceNumber(this.nextConn.getRemoteReference());
                copy.setOutgoingDpc(this.nextConn.getRemoteDpc());
                copy.setUserData(cref.getUserData());
                copy.setImportance(cref.getImportance());
                copy.setRefusalCause(cref.getRefusalCause());
                copy.setCalledPartyAddress(cref.getCalledPartyAddress());
                this.stack.removeConnection(this.getLocalReference());
                this.nextConn.sendMessage(copy);
                this.stack.removeConnection(this.nextConn.getLocalReference());
            } else if (message instanceof SccpConnRlsdMessageImpl) {
                SccpConnRlsdMessageImpl rlsd = (SccpConnRlsdMessageImpl)message;
                this.nextConn.disconnect(rlsd.getReleaseCause(), rlsd.getUserData());
            } else if (message instanceof SccpConnRlcMessageImpl) {
                SccpConnRlcMessageImpl copy = new SccpConnRlcMessageImpl(this.nextConn.getSls(), this.nextConn.getLocalSsn());
                copy.setSourceLocalReferenceNumber(this.nextConn.getLocalReference());
                copy.setDestinationLocalReferenceNumber(this.nextConn.getRemoteReference());
                copy.setOutgoingDpc(this.nextConn.getRemoteDpc());
                this.stack.removeConnection(this.getLocalReference());
                this.nextConn.sendMessage(copy);
                this.stack.removeConnection(this.nextConn.getLocalReference());
            } else if (message instanceof SccpConnRsrMessageImpl) {
                SccpConnRsrMessageImpl rsr = (SccpConnRsrMessageImpl)message;
                this.setState(SccpConnectionState.RSR_RECEIVED_WILL_PROPAGATE);
                this.nextConn.reset(rsr.getResetCause());
                this.setState(SccpConnectionState.RSR_PROPAGATED_VIA_COUPLED);
            } else if (message instanceof SccpConnRscMessageImpl) {
                SccpConnRscMessageImpl copy = new SccpConnRscMessageImpl(this.nextConn.getSls(), this.nextConn.getLocalSsn());
                copy.setSourceLocalReferenceNumber(this.nextConn.getLocalReference());
                copy.setDestinationLocalReferenceNumber(this.nextConn.getRemoteReference());
                copy.setOutgoingDpc(this.nextConn.getRemoteDpc());
                this.nextConn.sendMessage(copy);
                this.setState(SccpConnectionState.ESTABLISHED);
                this.nextConn.setState(SccpConnectionState.ESTABLISHED);
            } else if (message instanceof SccpConnErrMessageImpl) {
                this.nextConn.sendErr(((SccpConnErrMessageImpl)message).getErrorCause());
            }
        }
    }

    @Override
    protected void receiveDataMessage(SccpConnSegmentableMessageImpl msg) throws Exception {
        if (this.couplingEnabled) {
            if (msg instanceof SccpConnDt1MessageImpl) {
                SccpConnDt1MessageImpl copy = new SccpConnDt1MessageImpl(255, this.nextConn.getSls(), this.nextConn.getLocalSsn());
                copy.setSegmentingReassembling(((SccpConnDt1MessageImpl)msg).getSegmentingReassembling());
                copy.setSourceLocalReferenceNumber(this.nextConn.getLocalReference());
                copy.setDestinationLocalReferenceNumber(this.nextConn.getRemoteReference());
                copy.setOutgoingDpc(this.nextConn.getRemoteDpc());
                copy.setUserData(msg.getUserData());
                this.nextConn.sendMessage(copy);
            } else if (msg instanceof SccpConnDt2MessageImpl) {
                SccpConnDt2MessageImpl copy = new SccpConnDt2MessageImpl(255, this.nextConn.getSls(), this.nextConn.getLocalSsn());
                copy.setSequencingSegmenting(((SccpConnDt2MessageImpl)msg).getSequencingSegmenting());
                copy.setSourceLocalReferenceNumber(this.nextConn.getLocalReference());
                copy.setDestinationLocalReferenceNumber(this.nextConn.getRemoteReference());
                copy.setOutgoingDpc(this.nextConn.getRemoteDpc());
                copy.setUserData(msg.getUserData());
                this.nextConn.sendMessage(copy);
            }
        } else {
            super.receiveDataMessage(msg);
        }
    }

    @Override
    protected void confirmRelease() throws Exception {
        if (!this.couplingEnabled) {
            super.confirmRelease();
        }
    }

    @Override
    protected void confirmReset() throws Exception {
        if (!this.couplingEnabled) {
            super.confirmReset();
        }
    }

    @Override
    protected void checkLocalListener() throws IOException {
        if (!this.couplingEnabled) {
            super.checkLocalListener();
        }
    }

    public void enableCoupling(SccpConnectionWithCouplingImpl nextConn) {
        if (nextConn == null || this.getState() != SccpConnectionState.NEW || nextConn.getState() != SccpConnectionState.NEW) {
            throw new IllegalArgumentException();
        }
        this.couplingEnabled = true;
        this.nextConn = nextConn;
        this.setConnectionLock(nextConn.connectionLock);
        if (!nextConn.couplingEnabled && nextConn.nextConn != this) {
            nextConn.enableCoupling(this);
        }
    }

    public boolean isCouplingEnabled() {
        return this.couplingEnabled;
    }
}

