/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.util.concurrent.Executors;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPart;
import org.restcomm.protocols.ss7.sccp.SccpManagementEventListener;
import org.restcomm.protocols.ss7.sccp.impl.NonPersistentSccpResourceImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpManagement;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.NonPersistentRouterImpl;
import org.restcomm.protocols.ss7.ss7ext.Ss7ExtInterface;

public class NonPersistentSccpStackImpl
extends SccpStackImpl {
    public NonPersistentSccpStackImpl(String name, Ss7ExtInterface ss7ExtInterface) {
        super(name, ss7ExtInterface);
    }

    @Override
    public void start() throws IllegalStateException {
        this.logger.info("Starting ...");
        this.ss7ExtSccpDetailedInterface.startExtBefore(this.persistDir, this.name);
        this.load();
        this.sccpManagement = new SccpManagement(this.name, this.sccpProvider, this);
        this.sccpRoutingControl = new SccpRoutingControl(this.sccpProvider, this);
        this.sccpManagement.setSccpRoutingControl(this.sccpRoutingControl);
        this.sccpRoutingControl.setSccpManagement(this.sccpManagement);
        this.router = new NonPersistentRouterImpl(this.name, this);
        this.router.start();
        this.sccpResource = new NonPersistentSccpResourceImpl(this.name, this.ss7ExtSccpDetailedInterface);
        this.sccpResource.start();
        this.logger.info("Starting routing engine...");
        this.sccpRoutingControl.start();
        this.logger.info("Starting management ...");
        this.sccpManagement.start();
        this.logger.info("Starting MSU handler...");
        this.timerExecutors = Executors.newScheduledThreadPool(1);
        FastCollection.Record e = this.mtp3UserParts.head();
        FastMap.Entry end = this.mtp3UserParts.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3UserPart mup = (Mtp3UserPart)((FastMap.Entry)e).getValue();
            mup.addMtp3UserPartListener(this);
        }
        for (SccpManagementEventListener lstr : this.sccpProvider.managementEventListeners) {
            try {
                lstr.onServiceStarted();
            }
            catch (Throwable ee) {
                this.logger.error("Exception while invoking onServiceStarted", ee);
            }
        }
        this.ss7ExtSccpDetailedInterface.startExtAfter(this.router, this.sccpManagement);
        this.state = SccpStackImpl.State.RUNNING;
    }

    @Override
    public void load() {
    }

    @Override
    public void store() {
    }
}

