/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.NotReachableReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.SubscriberState;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.SubscriberStateChoice;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SubscriberStateImpl
implements SubscriberState,
MAPAsnPrimitive {
    public static final int _ID_assumedIdle = 0;
    public static final int _ID_camelBusy = 1;
    public static final int _ID_notProvidedFromVLR = 2;
    private static final String SUBSCRIBER_STATE_CHOICE = "subscriberStateChoice";
    private static final String NOT_REACHABLE_REASON = "notReachableReason";
    private static final String DEFAULT_STRING_VALUE = null;
    public static final String _PrimitiveName = "SubscriberState";
    private SubscriberStateChoice subscriberStateChoice;
    private NotReachableReason notReachableReason;
    protected static final XMLFormat<SubscriberStateImpl> SUBSCRIBER_STATE_XML = new XMLFormat<SubscriberStateImpl>(SubscriberStateImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, SubscriberStateImpl subscriberState) throws XMLStreamException {
            String choice = xml.getAttribute(SubscriberStateImpl.SUBSCRIBER_STATE_CHOICE, DEFAULT_STRING_VALUE);
            SubscriberStateChoice subscriberStateChoice = null;
            if (choice != null) {
                subscriberStateChoice = Enum.valueOf(SubscriberStateChoice.class, choice);
            }
            String nrr = xml.get(SubscriberStateImpl.NOT_REACHABLE_REASON, String.class);
            NotReachableReason notReachableReason = null;
            if (nrr != null) {
                notReachableReason = Enum.valueOf(NotReachableReason.class, nrr);
            }
            subscriberState.setData(subscriberStateChoice, notReachableReason);
        }

        @Override
        public void write(SubscriberStateImpl subscriberState, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (subscriberState.subscriberStateChoice != null) {
                xml.setAttribute(SubscriberStateImpl.SUBSCRIBER_STATE_CHOICE, subscriberState.subscriberStateChoice.toString());
            }
            if (subscriberState.notReachableReason != null) {
                xml.add(subscriberState.notReachableReason.toString(), SubscriberStateImpl.NOT_REACHABLE_REASON, String.class);
            }
        }
    };

    public SubscriberStateImpl() {
    }

    public SubscriberStateImpl(SubscriberStateChoice subscriberStateChoice, NotReachableReason notReachableReason) {
        this.setData(subscriberStateChoice, notReachableReason);
    }

    public void setData(SubscriberStateChoice subscriberStateChoice, NotReachableReason notReachableReason) {
        this.subscriberStateChoice = subscriberStateChoice;
        this.notReachableReason = notReachableReason;
    }

    @Override
    public SubscriberStateChoice getSubscriberStateChoice() {
        return this.subscriberStateChoice;
    }

    @Override
    public NotReachableReason getNotReachableReason() {
        return this.notReachableReason;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.subscriberStateChoice == null) {
            throw new MAPException("Error encoding SubscriberState: No subscriberStateChoice value");
        }
        switch (this.subscriberStateChoice) {
            case assumedIdle: {
                return 0;
            }
            case camelBusy: {
                return 1;
            }
            case netDetNotReachable: {
                return 10;
            }
            case notProvidedFromVLR: {
                return 2;
            }
        }
        throw new MAPException("Error encoding SubscriberState: Bad subscriberStateChoice value");
    }

    @Override
    public int getTagClass() {
        if (this.subscriberStateChoice != null && this.subscriberStateChoice == SubscriberStateChoice.netDetNotReachable) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SubscriberState: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.subscriberStateChoice = null;
        this.notReachableReason = null;
        int tag = ais.getTag();
        switch (ais.getTagClass()) {
            case 0: {
                if (tag == 10) {
                    this.subscriberStateChoice = SubscriberStateChoice.netDetNotReachable;
                    int i1 = (int)ais.readIntegerData(length);
                    this.notReachableReason = NotReachableReason.getInstance(i1);
                    break;
                }
                throw new MAPParsingComponentException("Error while decoding SubscriberState: bad choice tag for universal tag class: " + tag, MAPParsingComponentExceptionReason.MistypedParameter);
            }
            case 2: {
                switch (tag) {
                    case 0: {
                        this.subscriberStateChoice = SubscriberStateChoice.assumedIdle;
                        break;
                    }
                    case 1: {
                        this.subscriberStateChoice = SubscriberStateChoice.camelBusy;
                        break;
                    }
                    case 2: {
                        this.subscriberStateChoice = SubscriberStateChoice.notProvidedFromVLR;
                        break;
                    }
                    default: {
                        throw new MAPParsingComponentException("Error while decoding SubscriberState: bad choice tag for contextSpecific tag class: " + tag, MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
                ais.readNullData(length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding SubscriberState: bad choice tagClass: " + ais.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SubscriberState: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.subscriberStateChoice == null) {
            throw new MAPException("subscriberStateChoice must not be null");
        }
        if (this.subscriberStateChoice == SubscriberStateChoice.netDetNotReachable) {
            if (this.notReachableReason == null) {
                throw new MAPException("notReachableReason must not be null when subscriberStateChoice is netDetNotReachable");
            }
            try {
                asnOs.writeIntegerData(this.notReachableReason.getCode());
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding SubscriberState: " + e.getMessage(), e);
            }
        } else {
            asnOs.writeNullData();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriberState [");
        if (this.subscriberStateChoice != null) {
            sb.append("subscriberStateChoice=");
            sb.append((Object)this.subscriberStateChoice);
        }
        if (this.notReachableReason != null) {
            sb.append(", notReachableReason=");
            sb.append((Object)this.notReachableReason);
        }
        sb.append("]");
        return sb.toString();
    }
}

